/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsecuretunneling.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotsecuretunneling.IoTSecureTunnelingClient;
import software.amazon.awssdk.services.iotsecuretunneling.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotsecuretunneling.model.ListTunnelsRequest;
import software.amazon.awssdk.services.iotsecuretunneling.model.ListTunnelsResponse;

public class ListTunnelsIterable
implements SdkIterable<ListTunnelsResponse> {
    private final IoTSecureTunnelingClient client;
    private final ListTunnelsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTunnelsIterable(IoTSecureTunnelingClient client, ListTunnelsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListTunnelsResponseFetcher();
    }

    public Iterator<ListTunnelsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListTunnelsResponseFetcher
    implements SyncPageFetcher<ListTunnelsResponse> {
        private ListTunnelsResponseFetcher() {
        }

        public boolean hasNextPage(ListTunnelsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTunnelsResponse nextPage(ListTunnelsResponse previousPage) {
            if (previousPage == null) {
                return ListTunnelsIterable.this.client.listTunnels(ListTunnelsIterable.this.firstRequest);
            }
            return ListTunnelsIterable.this.client.listTunnels((ListTunnelsRequest)((Object)ListTunnelsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

