/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsecuretunneling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotsecuretunneling.model.DestinationConfig;
import software.amazon.awssdk.services.iotsecuretunneling.model.IoTSecureTunnelingRequest;
import software.amazon.awssdk.services.iotsecuretunneling.model.Tag;
import software.amazon.awssdk.services.iotsecuretunneling.model.TagListCopier;
import software.amazon.awssdk.services.iotsecuretunneling.model.TimeoutConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OpenTunnelRequest
extends IoTSecureTunnelingRequest
implements ToCopyableBuilder<Builder, OpenTunnelRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(OpenTunnelRequest.getter(OpenTunnelRequest::description)).setter(OpenTunnelRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(OpenTunnelRequest.getter(OpenTunnelRequest::tags)).setter(OpenTunnelRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<DestinationConfig> DESTINATION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("destinationConfig").getter(OpenTunnelRequest.getter(OpenTunnelRequest::destinationConfig)).setter(OpenTunnelRequest.setter(Builder::destinationConfig)).constructor(DestinationConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationConfig").build()}).build();
    private static final SdkField<TimeoutConfig> TIMEOUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("timeoutConfig").getter(OpenTunnelRequest.getter(OpenTunnelRequest::timeoutConfig)).setter(OpenTunnelRequest.setter(Builder::timeoutConfig)).constructor(TimeoutConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, TAGS_FIELD, DESTINATION_CONFIG_FIELD, TIMEOUT_CONFIG_FIELD));
    private final String description;
    private final List<Tag> tags;
    private final DestinationConfig destinationConfig;
    private final TimeoutConfig timeoutConfig;

    private OpenTunnelRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.tags = builder.tags;
        this.destinationConfig = builder.destinationConfig;
        this.timeoutConfig = builder.timeoutConfig;
    }

    public String description() {
        return this.description;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public DestinationConfig destinationConfig() {
        return this.destinationConfig;
    }

    public TimeoutConfig timeoutConfig() {
        return this.timeoutConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeoutConfig());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpenTunnelRequest)) {
            return false;
        }
        OpenTunnelRequest other = (OpenTunnelRequest)((Object)obj);
        return Objects.equals(this.description(), other.description()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.destinationConfig(), other.destinationConfig()) && Objects.equals(this.timeoutConfig(), other.timeoutConfig());
    }

    public String toString() {
        return ToString.builder((String)"OpenTunnelRequest").add("Description", (Object)this.description()).add("Tags", this.hasTags() ? this.tags() : null).add("DestinationConfig", (Object)this.destinationConfig()).add("TimeoutConfig", (Object)this.timeoutConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "destinationConfig": {
                return Optional.ofNullable(clazz.cast(this.destinationConfig()));
            }
            case "timeoutConfig": {
                return Optional.ofNullable(clazz.cast(this.timeoutConfig()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OpenTunnelRequest, T> g) {
        return obj -> g.apply((OpenTunnelRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSecureTunnelingRequest.BuilderImpl
    implements Builder {
        private String description;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private DestinationConfig destinationConfig;
        private TimeoutConfig timeoutConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(OpenTunnelRequest model) {
            super(model);
            this.description(model.description);
            this.tags(model.tags);
            this.destinationConfig(model.destinationConfig);
            this.timeoutConfig(model.timeoutConfig);
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<Tag.Builder> getTags() {
            if (this.tags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final DestinationConfig.Builder getDestinationConfig() {
            return this.destinationConfig != null ? this.destinationConfig.toBuilder() : null;
        }

        @Override
        public final Builder destinationConfig(DestinationConfig destinationConfig) {
            this.destinationConfig = destinationConfig;
            return this;
        }

        public final void setDestinationConfig(DestinationConfig.BuilderImpl destinationConfig) {
            this.destinationConfig = destinationConfig != null ? destinationConfig.build() : null;
        }

        public final TimeoutConfig.Builder getTimeoutConfig() {
            return this.timeoutConfig != null ? this.timeoutConfig.toBuilder() : null;
        }

        @Override
        public final Builder timeoutConfig(TimeoutConfig timeoutConfig) {
            this.timeoutConfig = timeoutConfig;
            return this;
        }

        public final void setTimeoutConfig(TimeoutConfig.BuilderImpl timeoutConfig) {
            this.timeoutConfig = timeoutConfig != null ? timeoutConfig.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public OpenTunnelRequest build() {
            return new OpenTunnelRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTSecureTunnelingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, OpenTunnelRequest> {
        public Builder description(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder destinationConfig(DestinationConfig var1);

        default public Builder destinationConfig(Consumer<DestinationConfig.Builder> destinationConfig) {
            return this.destinationConfig((DestinationConfig)((DestinationConfig.Builder)DestinationConfig.builder().applyMutation(destinationConfig)).build());
        }

        public Builder timeoutConfig(TimeoutConfig var1);

        default public Builder timeoutConfig(Consumer<TimeoutConfig.Builder> timeoutConfig) {
            return this.timeoutConfig((TimeoutConfig)((TimeoutConfig.Builder)TimeoutConfig.builder().applyMutation(timeoutConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

