/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotmanagedintegrations.IotManagedIntegrationsAsyncClient;
import software.amazon.awssdk.services.iotmanagedintegrations.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ConnectorDestinationSummary;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListConnectorDestinationsRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListConnectorDestinationsResponse;

public class ListConnectorDestinationsPublisher
implements SdkPublisher<ListConnectorDestinationsResponse> {
    private final IotManagedIntegrationsAsyncClient client;
    private final ListConnectorDestinationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListConnectorDestinationsPublisher(IotManagedIntegrationsAsyncClient client, ListConnectorDestinationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListConnectorDestinationsPublisher(IotManagedIntegrationsAsyncClient client, ListConnectorDestinationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListConnectorDestinationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListConnectorDestinationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ConnectorDestinationSummary> connectorDestinationList() {
        Function<ListConnectorDestinationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.connectorDestinationList() != null) {
                return response.connectorDestinationList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListConnectorDestinationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListConnectorDestinationsResponseFetcher
    implements AsyncPageFetcher<ListConnectorDestinationsResponse> {
        private ListConnectorDestinationsResponseFetcher() {
        }

        public boolean hasNextPage(ListConnectorDestinationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListConnectorDestinationsResponse> nextPage(ListConnectorDestinationsResponse previousPage) {
            if (previousPage == null) {
                return ListConnectorDestinationsPublisher.this.client.listConnectorDestinations(ListConnectorDestinationsPublisher.this.firstRequest);
            }
            return ListConnectorDestinationsPublisher.this.client.listConnectorDestinations((ListConnectorDestinationsRequest)((Object)ListConnectorDestinationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

