/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotmanagedintegrations.model.IotManagedIntegrationsRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.RuntimeLogConfigurations;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutRuntimeLogConfigurationRequest
extends IotManagedIntegrationsRequest
implements ToCopyableBuilder<Builder, PutRuntimeLogConfigurationRequest> {
    private static final SdkField<String> MANAGED_THING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ManagedThingId").getter(PutRuntimeLogConfigurationRequest.getter(PutRuntimeLogConfigurationRequest::managedThingId)).setter(PutRuntimeLogConfigurationRequest.setter(Builder::managedThingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ManagedThingId").build()}).build();
    private static final SdkField<RuntimeLogConfigurations> RUNTIME_LOG_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RuntimeLogConfigurations").getter(PutRuntimeLogConfigurationRequest.getter(PutRuntimeLogConfigurationRequest::runtimeLogConfigurations)).setter(PutRuntimeLogConfigurationRequest.setter(Builder::runtimeLogConfigurations)).constructor(RuntimeLogConfigurations::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuntimeLogConfigurations").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MANAGED_THING_ID_FIELD, RUNTIME_LOG_CONFIGURATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutRuntimeLogConfigurationRequest.memberNameToFieldInitializer();
    private final String managedThingId;
    private final RuntimeLogConfigurations runtimeLogConfigurations;

    private PutRuntimeLogConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.managedThingId = builder.managedThingId;
        this.runtimeLogConfigurations = builder.runtimeLogConfigurations;
    }

    public final String managedThingId() {
        return this.managedThingId;
    }

    public final RuntimeLogConfigurations runtimeLogConfigurations() {
        return this.runtimeLogConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.managedThingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.runtimeLogConfigurations());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutRuntimeLogConfigurationRequest)) {
            return false;
        }
        PutRuntimeLogConfigurationRequest other = (PutRuntimeLogConfigurationRequest)((Object)obj);
        return Objects.equals(this.managedThingId(), other.managedThingId()) && Objects.equals(this.runtimeLogConfigurations(), other.runtimeLogConfigurations());
    }

    public final String toString() {
        return ToString.builder((String)"PutRuntimeLogConfigurationRequest").add("ManagedThingId", (Object)this.managedThingId()).add("RuntimeLogConfigurations", (Object)this.runtimeLogConfigurations()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ManagedThingId": {
                return Optional.ofNullable(clazz.cast(this.managedThingId()));
            }
            case "RuntimeLogConfigurations": {
                return Optional.ofNullable(clazz.cast(this.runtimeLogConfigurations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ManagedThingId", MANAGED_THING_ID_FIELD);
        map.put("RuntimeLogConfigurations", RUNTIME_LOG_CONFIGURATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutRuntimeLogConfigurationRequest, T> g) {
        return obj -> g.apply((PutRuntimeLogConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotManagedIntegrationsRequest.BuilderImpl
    implements Builder {
        private String managedThingId;
        private RuntimeLogConfigurations runtimeLogConfigurations;

        private BuilderImpl() {
        }

        private BuilderImpl(PutRuntimeLogConfigurationRequest model) {
            super(model);
            this.managedThingId(model.managedThingId);
            this.runtimeLogConfigurations(model.runtimeLogConfigurations);
        }

        public final String getManagedThingId() {
            return this.managedThingId;
        }

        public final void setManagedThingId(String managedThingId) {
            this.managedThingId = managedThingId;
        }

        @Override
        public final Builder managedThingId(String managedThingId) {
            this.managedThingId = managedThingId;
            return this;
        }

        public final RuntimeLogConfigurations.Builder getRuntimeLogConfigurations() {
            return this.runtimeLogConfigurations != null ? this.runtimeLogConfigurations.toBuilder() : null;
        }

        public final void setRuntimeLogConfigurations(RuntimeLogConfigurations.BuilderImpl runtimeLogConfigurations) {
            this.runtimeLogConfigurations = runtimeLogConfigurations != null ? runtimeLogConfigurations.build() : null;
        }

        @Override
        public final Builder runtimeLogConfigurations(RuntimeLogConfigurations runtimeLogConfigurations) {
            this.runtimeLogConfigurations = runtimeLogConfigurations;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutRuntimeLogConfigurationRequest build() {
            return new PutRuntimeLogConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IotManagedIntegrationsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutRuntimeLogConfigurationRequest> {
        public Builder managedThingId(String var1);

        public Builder runtimeLogConfigurations(RuntimeLogConfigurations var1);

        default public Builder runtimeLogConfigurations(Consumer<RuntimeLogConfigurations.Builder> runtimeLogConfigurations) {
            return this.runtimeLogConfigurations((RuntimeLogConfigurations)((RuntimeLogConfigurations.Builder)RuntimeLogConfigurations.builder().applyMutation(runtimeLogConfigurations)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

