/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotmanagedintegrations.model.AuthConfig;
import software.amazon.awssdk.services.iotmanagedintegrations.model.AuthType;
import software.amazon.awssdk.services.iotmanagedintegrations.model.IotManagedIntegrationsResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.SecretsManager;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetConnectorDestinationResponse
extends IotManagedIntegrationsResponse
implements ToCopyableBuilder<Builder, GetConnectorDestinationResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(GetConnectorDestinationResponse.getter(GetConnectorDestinationResponse::name)).setter(GetConnectorDestinationResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(GetConnectorDestinationResponse.getter(GetConnectorDestinationResponse::description)).setter(GetConnectorDestinationResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> CLOUD_CONNECTOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CloudConnectorId").getter(GetConnectorDestinationResponse.getter(GetConnectorDestinationResponse::cloudConnectorId)).setter(GetConnectorDestinationResponse.setter(Builder::cloudConnectorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudConnectorId").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(GetConnectorDestinationResponse.getter(GetConnectorDestinationResponse::id)).setter(GetConnectorDestinationResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> AUTH_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthType").getter(GetConnectorDestinationResponse.getter(GetConnectorDestinationResponse::authTypeAsString)).setter(GetConnectorDestinationResponse.setter(Builder::authType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthType").build()}).build();
    private static final SdkField<AuthConfig> AUTH_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AuthConfig").getter(GetConnectorDestinationResponse.getter(GetConnectorDestinationResponse::authConfig)).setter(GetConnectorDestinationResponse.setter(Builder::authConfig)).constructor(AuthConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthConfig").build()}).build();
    private static final SdkField<SecretsManager> SECRETS_MANAGER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SecretsManager").getter(GetConnectorDestinationResponse.getter(GetConnectorDestinationResponse::secretsManager)).setter(GetConnectorDestinationResponse.setter(Builder::secretsManager)).constructor(SecretsManager::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretsManager").build()}).build();
    private static final SdkField<String> O_AUTH_COMPLETE_REDIRECT_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OAuthCompleteRedirectUrl").getter(GetConnectorDestinationResponse.getter(GetConnectorDestinationResponse::oAuthCompleteRedirectUrl)).setter(GetConnectorDestinationResponse.setter(Builder::oAuthCompleteRedirectUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OAuthCompleteRedirectUrl").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, CLOUD_CONNECTOR_ID_FIELD, ID_FIELD, AUTH_TYPE_FIELD, AUTH_CONFIG_FIELD, SECRETS_MANAGER_FIELD, O_AUTH_COMPLETE_REDIRECT_URL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetConnectorDestinationResponse.memberNameToFieldInitializer();
    private final String name;
    private final String description;
    private final String cloudConnectorId;
    private final String id;
    private final String authType;
    private final AuthConfig authConfig;
    private final SecretsManager secretsManager;
    private final String oAuthCompleteRedirectUrl;

    private GetConnectorDestinationResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.cloudConnectorId = builder.cloudConnectorId;
        this.id = builder.id;
        this.authType = builder.authType;
        this.authConfig = builder.authConfig;
        this.secretsManager = builder.secretsManager;
        this.oAuthCompleteRedirectUrl = builder.oAuthCompleteRedirectUrl;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final String cloudConnectorId() {
        return this.cloudConnectorId;
    }

    public final String id() {
        return this.id;
    }

    public final AuthType authType() {
        return AuthType.fromValue(this.authType);
    }

    public final String authTypeAsString() {
        return this.authType;
    }

    public final AuthConfig authConfig() {
        return this.authConfig;
    }

    public final SecretsManager secretsManager() {
        return this.secretsManager;
    }

    public final String oAuthCompleteRedirectUrl() {
        return this.oAuthCompleteRedirectUrl;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudConnectorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.authTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.authConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretsManager());
        hashCode = 31 * hashCode + Objects.hashCode(this.oAuthCompleteRedirectUrl());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConnectorDestinationResponse)) {
            return false;
        }
        GetConnectorDestinationResponse other = (GetConnectorDestinationResponse)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.cloudConnectorId(), other.cloudConnectorId()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.authTypeAsString(), other.authTypeAsString()) && Objects.equals(this.authConfig(), other.authConfig()) && Objects.equals(this.secretsManager(), other.secretsManager()) && Objects.equals(this.oAuthCompleteRedirectUrl(), other.oAuthCompleteRedirectUrl());
    }

    public final String toString() {
        return ToString.builder((String)"GetConnectorDestinationResponse").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("CloudConnectorId", (Object)this.cloudConnectorId()).add("Id", (Object)this.id()).add("AuthType", (Object)this.authTypeAsString()).add("AuthConfig", (Object)this.authConfig()).add("SecretsManager", (Object)this.secretsManager()).add("OAuthCompleteRedirectUrl", (Object)this.oAuthCompleteRedirectUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "CloudConnectorId": {
                return Optional.ofNullable(clazz.cast(this.cloudConnectorId()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "AuthType": {
                return Optional.ofNullable(clazz.cast(this.authTypeAsString()));
            }
            case "AuthConfig": {
                return Optional.ofNullable(clazz.cast(this.authConfig()));
            }
            case "SecretsManager": {
                return Optional.ofNullable(clazz.cast(this.secretsManager()));
            }
            case "OAuthCompleteRedirectUrl": {
                return Optional.ofNullable(clazz.cast(this.oAuthCompleteRedirectUrl()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("CloudConnectorId", CLOUD_CONNECTOR_ID_FIELD);
        map.put("Id", ID_FIELD);
        map.put("AuthType", AUTH_TYPE_FIELD);
        map.put("AuthConfig", AUTH_CONFIG_FIELD);
        map.put("SecretsManager", SECRETS_MANAGER_FIELD);
        map.put("OAuthCompleteRedirectUrl", O_AUTH_COMPLETE_REDIRECT_URL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetConnectorDestinationResponse, T> g) {
        return obj -> g.apply((GetConnectorDestinationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotManagedIntegrationsResponse.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String cloudConnectorId;
        private String id;
        private String authType;
        private AuthConfig authConfig;
        private SecretsManager secretsManager;
        private String oAuthCompleteRedirectUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(GetConnectorDestinationResponse model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.cloudConnectorId(model.cloudConnectorId);
            this.id(model.id);
            this.authType(model.authType);
            this.authConfig(model.authConfig);
            this.secretsManager(model.secretsManager);
            this.oAuthCompleteRedirectUrl(model.oAuthCompleteRedirectUrl);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getCloudConnectorId() {
            return this.cloudConnectorId;
        }

        public final void setCloudConnectorId(String cloudConnectorId) {
            this.cloudConnectorId = cloudConnectorId;
        }

        @Override
        public final Builder cloudConnectorId(String cloudConnectorId) {
            this.cloudConnectorId = cloudConnectorId;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getAuthType() {
            return this.authType;
        }

        public final void setAuthType(String authType) {
            this.authType = authType;
        }

        @Override
        public final Builder authType(String authType) {
            this.authType = authType;
            return this;
        }

        @Override
        public final Builder authType(AuthType authType) {
            this.authType(authType == null ? null : authType.toString());
            return this;
        }

        public final AuthConfig.Builder getAuthConfig() {
            return this.authConfig != null ? this.authConfig.toBuilder() : null;
        }

        public final void setAuthConfig(AuthConfig.BuilderImpl authConfig) {
            this.authConfig = authConfig != null ? authConfig.build() : null;
        }

        @Override
        public final Builder authConfig(AuthConfig authConfig) {
            this.authConfig = authConfig;
            return this;
        }

        public final SecretsManager.Builder getSecretsManager() {
            return this.secretsManager != null ? this.secretsManager.toBuilder() : null;
        }

        public final void setSecretsManager(SecretsManager.BuilderImpl secretsManager) {
            this.secretsManager = secretsManager != null ? secretsManager.build() : null;
        }

        @Override
        public final Builder secretsManager(SecretsManager secretsManager) {
            this.secretsManager = secretsManager;
            return this;
        }

        public final String getOAuthCompleteRedirectUrl() {
            return this.oAuthCompleteRedirectUrl;
        }

        public final void setOAuthCompleteRedirectUrl(String oAuthCompleteRedirectUrl) {
            this.oAuthCompleteRedirectUrl = oAuthCompleteRedirectUrl;
        }

        @Override
        public final Builder oAuthCompleteRedirectUrl(String oAuthCompleteRedirectUrl) {
            this.oAuthCompleteRedirectUrl = oAuthCompleteRedirectUrl;
            return this;
        }

        @Override
        public GetConnectorDestinationResponse build() {
            return new GetConnectorDestinationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IotManagedIntegrationsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetConnectorDestinationResponse> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder cloudConnectorId(String var1);

        public Builder id(String var1);

        public Builder authType(String var1);

        public Builder authType(AuthType var1);

        public Builder authConfig(AuthConfig var1);

        default public Builder authConfig(Consumer<AuthConfig.Builder> authConfig) {
            return this.authConfig((AuthConfig)((AuthConfig.Builder)AuthConfig.builder().applyMutation(authConfig)).build());
        }

        public Builder secretsManager(SecretsManager var1);

        default public Builder secretsManager(Consumer<SecretsManager.Builder> secretsManager) {
            return this.secretsManager((SecretsManager)((SecretsManager.Builder)SecretsManager.builder().applyMutation(secretsManager)).build());
        }

        public Builder oAuthCompleteRedirectUrl(String var1);
    }
}

