/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DeviceDiscoveryStatus;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DiscoveryType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeviceDiscoverySummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DeviceDiscoverySummary> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(DeviceDiscoverySummary.getter(DeviceDiscoverySummary::id)).setter(DeviceDiscoverySummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> DISCOVERY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DiscoveryType").getter(DeviceDiscoverySummary.getter(DeviceDiscoverySummary::discoveryTypeAsString)).setter(DeviceDiscoverySummary.setter(Builder::discoveryType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiscoveryType").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DeviceDiscoverySummary.getter(DeviceDiscoverySummary::statusAsString)).setter(DeviceDiscoverySummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, DISCOVERY_TYPE_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeviceDiscoverySummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String discoveryType;
    private final String status;

    private DeviceDiscoverySummary(BuilderImpl builder) {
        this.id = builder.id;
        this.discoveryType = builder.discoveryType;
        this.status = builder.status;
    }

    public final String id() {
        return this.id;
    }

    public final DiscoveryType discoveryType() {
        return DiscoveryType.fromValue(this.discoveryType);
    }

    public final String discoveryTypeAsString() {
        return this.discoveryType;
    }

    public final DeviceDiscoveryStatus status() {
        return DeviceDiscoveryStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.discoveryTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeviceDiscoverySummary)) {
            return false;
        }
        DeviceDiscoverySummary other = (DeviceDiscoverySummary)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.discoveryTypeAsString(), other.discoveryTypeAsString()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DeviceDiscoverySummary").add("Id", (Object)this.id()).add("DiscoveryType", (Object)this.discoveryTypeAsString()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "DiscoveryType": {
                return Optional.ofNullable(clazz.cast(this.discoveryTypeAsString()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Id", ID_FIELD);
        map.put("DiscoveryType", DISCOVERY_TYPE_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeviceDiscoverySummary, T> g) {
        return obj -> g.apply((DeviceDiscoverySummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String discoveryType;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(DeviceDiscoverySummary model) {
            this.id(model.id);
            this.discoveryType(model.discoveryType);
            this.status(model.status);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getDiscoveryType() {
            return this.discoveryType;
        }

        public final void setDiscoveryType(String discoveryType) {
            this.discoveryType = discoveryType;
        }

        @Override
        public final Builder discoveryType(String discoveryType) {
            this.discoveryType = discoveryType;
            return this;
        }

        @Override
        public final Builder discoveryType(DiscoveryType discoveryType) {
            this.discoveryType(discoveryType == null ? null : discoveryType.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DeviceDiscoveryStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public DeviceDiscoverySummary build() {
            return new DeviceDiscoverySummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DeviceDiscoverySummary> {
        public Builder id(String var1);

        public Builder discoveryType(String var1);

        public Builder discoveryType(DiscoveryType var1);

        public Builder status(String var1);

        public Builder status(DeviceDiscoveryStatus var1);
    }
}

