/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotmanagedintegrations.IotManagedIntegrationsAsyncClient;
import software.amazon.awssdk.services.iotmanagedintegrations.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListOtaTaskConfigurationsRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListOtaTaskConfigurationsResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.OtaTaskConfigurationSummary;

public class ListOtaTaskConfigurationsPublisher
implements SdkPublisher<ListOtaTaskConfigurationsResponse> {
    private final IotManagedIntegrationsAsyncClient client;
    private final ListOtaTaskConfigurationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListOtaTaskConfigurationsPublisher(IotManagedIntegrationsAsyncClient client, ListOtaTaskConfigurationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListOtaTaskConfigurationsPublisher(IotManagedIntegrationsAsyncClient client, ListOtaTaskConfigurationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListOtaTaskConfigurationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListOtaTaskConfigurationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<OtaTaskConfigurationSummary> items() {
        Function<ListOtaTaskConfigurationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListOtaTaskConfigurationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListOtaTaskConfigurationsResponseFetcher
    implements AsyncPageFetcher<ListOtaTaskConfigurationsResponse> {
        private ListOtaTaskConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(ListOtaTaskConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListOtaTaskConfigurationsResponse> nextPage(ListOtaTaskConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return ListOtaTaskConfigurationsPublisher.this.client.listOtaTaskConfigurations(ListOtaTaskConfigurationsPublisher.this.firstRequest);
            }
            return ListOtaTaskConfigurationsPublisher.this.client.listOtaTaskConfigurations((ListOtaTaskConfigurationsRequest)((Object)ListOtaTaskConfigurationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

