/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SchemaVersionType {
    CAPABILITY("capability"),
    DEFINITION("definition"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SchemaVersionType> VALUE_MAP;
    private final String value;

    private SchemaVersionType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SchemaVersionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SchemaVersionType> knownValues() {
        EnumSet<SchemaVersionType> knownValues = EnumSet.allOf(SchemaVersionType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SchemaVersionType.class, SchemaVersionType::toString);
    }
}

