/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DeviceDiscoveryStatus;
import software.amazon.awssdk.services.iotmanagedintegrations.model.DiscoveryType;
import software.amazon.awssdk.services.iotmanagedintegrations.model.IotManagedIntegrationsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDeviceDiscoveriesRequest
extends IotManagedIntegrationsRequest
implements ToCopyableBuilder<Builder, ListDeviceDiscoveriesRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListDeviceDiscoveriesRequest.getter(ListDeviceDiscoveriesRequest::nextToken)).setter(ListDeviceDiscoveriesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListDeviceDiscoveriesRequest.getter(ListDeviceDiscoveriesRequest::maxResults)).setter(ListDeviceDiscoveriesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxResults").build()}).build();
    private static final SdkField<String> TYPE_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TypeFilter").getter(ListDeviceDiscoveriesRequest.getter(ListDeviceDiscoveriesRequest::typeFilterAsString)).setter(ListDeviceDiscoveriesRequest.setter(Builder::typeFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("TypeFilter").build()}).build();
    private static final SdkField<String> STATUS_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusFilter").getter(ListDeviceDiscoveriesRequest.getter(ListDeviceDiscoveriesRequest::statusFilterAsString)).setter(ListDeviceDiscoveriesRequest.setter(Builder::statusFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("StatusFilter").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, TYPE_FILTER_FIELD, STATUS_FILTER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListDeviceDiscoveriesRequest.memberNameToFieldInitializer();
    private final String nextToken;
    private final Integer maxResults;
    private final String typeFilter;
    private final String statusFilter;

    private ListDeviceDiscoveriesRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.typeFilter = builder.typeFilter;
        this.statusFilter = builder.statusFilter;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final DiscoveryType typeFilter() {
        return DiscoveryType.fromValue(this.typeFilter);
    }

    public final String typeFilterAsString() {
        return this.typeFilter;
    }

    public final DeviceDiscoveryStatus statusFilter() {
        return DeviceDiscoveryStatus.fromValue(this.statusFilter);
    }

    public final String statusFilterAsString() {
        return this.statusFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeFilterAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusFilterAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDeviceDiscoveriesRequest)) {
            return false;
        }
        ListDeviceDiscoveriesRequest other = (ListDeviceDiscoveriesRequest)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.typeFilterAsString(), other.typeFilterAsString()) && Objects.equals(this.statusFilterAsString(), other.statusFilterAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ListDeviceDiscoveriesRequest").add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("TypeFilter", (Object)this.typeFilterAsString()).add("StatusFilter", (Object)this.statusFilterAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "TypeFilter": {
                return Optional.ofNullable(clazz.cast(this.typeFilterAsString()));
            }
            case "StatusFilter": {
                return Optional.ofNullable(clazz.cast(this.statusFilterAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("TypeFilter", TYPE_FILTER_FIELD);
        map.put("StatusFilter", STATUS_FILTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDeviceDiscoveriesRequest, T> g) {
        return obj -> g.apply((ListDeviceDiscoveriesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotManagedIntegrationsRequest.BuilderImpl
    implements Builder {
        private String nextToken;
        private Integer maxResults;
        private String typeFilter;
        private String statusFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDeviceDiscoveriesRequest model) {
            super(model);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.typeFilter(model.typeFilter);
            this.statusFilter(model.statusFilter);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getTypeFilter() {
            return this.typeFilter;
        }

        public final void setTypeFilter(String typeFilter) {
            this.typeFilter = typeFilter;
        }

        @Override
        public final Builder typeFilter(String typeFilter) {
            this.typeFilter = typeFilter;
            return this;
        }

        @Override
        public final Builder typeFilter(DiscoveryType typeFilter) {
            this.typeFilter(typeFilter == null ? null : typeFilter.toString());
            return this;
        }

        public final String getStatusFilter() {
            return this.statusFilter;
        }

        public final void setStatusFilter(String statusFilter) {
            this.statusFilter = statusFilter;
        }

        @Override
        public final Builder statusFilter(String statusFilter) {
            this.statusFilter = statusFilter;
            return this;
        }

        @Override
        public final Builder statusFilter(DeviceDiscoveryStatus statusFilter) {
            this.statusFilter(statusFilter == null ? null : statusFilter.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListDeviceDiscoveriesRequest build() {
            return new ListDeviceDiscoveriesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IotManagedIntegrationsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDeviceDiscoveriesRequest> {
        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder typeFilter(String var1);

        public Builder typeFilter(DiscoveryType var1);

        public Builder statusFilter(String var1);

        public Builder statusFilter(DeviceDiscoveryStatus var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

