/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotfleetwise.IoTFleetWiseClient;
import software.amazon.awssdk.services.iotfleetwise.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotfleetwise.model.ListStateTemplatesRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ListStateTemplatesResponse;
import software.amazon.awssdk.services.iotfleetwise.model.StateTemplateSummary;

public class ListStateTemplatesIterable
implements SdkIterable<ListStateTemplatesResponse> {
    private final IoTFleetWiseClient client;
    private final ListStateTemplatesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListStateTemplatesIterable(IoTFleetWiseClient client, ListStateTemplatesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListStateTemplatesResponseFetcher();
    }

    public Iterator<ListStateTemplatesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<StateTemplateSummary> summaries() {
        Function<ListStateTemplatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.summaries() != null) {
                return response.summaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListStateTemplatesResponseFetcher
    implements SyncPageFetcher<ListStateTemplatesResponse> {
        private ListStateTemplatesResponseFetcher() {
        }

        public boolean hasNextPage(ListStateTemplatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListStateTemplatesResponse nextPage(ListStateTemplatesResponse previousPage) {
            if (previousPage == null) {
                return ListStateTemplatesIterable.this.client.listStateTemplates(ListStateTemplatesIterable.this.firstRequest);
            }
            return ListStateTemplatesIterable.this.client.listStateTemplates((ListStateTemplatesRequest)((Object)ListStateTemplatesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

