/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotfleetwise.model.DecoderManifestSummary;
import software.amazon.awssdk.services.iotfleetwise.model.IoTFleetWiseResponse;
import software.amazon.awssdk.services.iotfleetwise.model._decoderManifestSummariesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDecoderManifestsResponse
extends IoTFleetWiseResponse
implements ToCopyableBuilder<Builder, ListDecoderManifestsResponse> {
    private static final SdkField<List<DecoderManifestSummary>> SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("summaries").getter(ListDecoderManifestsResponse.getter(ListDecoderManifestsResponse::summaries)).setter(ListDecoderManifestsResponse.setter(Builder::summaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("summaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DecoderManifestSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListDecoderManifestsResponse.getter(ListDecoderManifestsResponse::nextToken)).setter(ListDecoderManifestsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListDecoderManifestsResponse.memberNameToFieldInitializer();
    private final List<DecoderManifestSummary> summaries;
    private final String nextToken;

    private ListDecoderManifestsResponse(BuilderImpl builder) {
        super(builder);
        this.summaries = builder.summaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasSummaries() {
        return this.summaries != null && !(this.summaries instanceof SdkAutoConstructList);
    }

    public final List<DecoderManifestSummary> summaries() {
        return this.summaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSummaries() ? this.summaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDecoderManifestsResponse)) {
            return false;
        }
        ListDecoderManifestsResponse other = (ListDecoderManifestsResponse)((Object)obj);
        return this.hasSummaries() == other.hasSummaries() && Objects.equals(this.summaries(), other.summaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListDecoderManifestsResponse").add("Summaries", this.hasSummaries() ? this.summaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "summaries": {
                return Optional.ofNullable(clazz.cast(this.summaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("summaries", SUMMARIES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDecoderManifestsResponse, T> g) {
        return obj -> g.apply((ListDecoderManifestsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTFleetWiseResponse.BuilderImpl
    implements Builder {
        private List<DecoderManifestSummary> summaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDecoderManifestsResponse model) {
            super(model);
            this.summaries(model.summaries);
            this.nextToken(model.nextToken);
        }

        public final List<DecoderManifestSummary.Builder> getSummaries() {
            List<DecoderManifestSummary.Builder> result = _decoderManifestSummariesCopier.copyToBuilder(this.summaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSummaries(Collection<DecoderManifestSummary.BuilderImpl> summaries) {
            this.summaries = _decoderManifestSummariesCopier.copyFromBuilder(summaries);
        }

        @Override
        public final Builder summaries(Collection<DecoderManifestSummary> summaries) {
            this.summaries = _decoderManifestSummariesCopier.copy(summaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder summaries(DecoderManifestSummary ... summaries) {
            this.summaries(Arrays.asList(summaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder summaries(Consumer<DecoderManifestSummary.Builder> ... summaries) {
            this.summaries(Stream.of(summaries).map(c -> (DecoderManifestSummary)((DecoderManifestSummary.Builder)DecoderManifestSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListDecoderManifestsResponse build() {
            return new ListDecoderManifestsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IoTFleetWiseResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDecoderManifestsResponse> {
        public Builder summaries(Collection<DecoderManifestSummary> var1);

        public Builder summaries(DecoderManifestSummary ... var1);

        public Builder summaries(Consumer<DecoderManifestSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

