/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotfleetwise.model.InvalidNetworkInterface;
import software.amazon.awssdk.services.iotfleetwise.model.InvalidNetworkInterfacesCopier;
import software.amazon.awssdk.services.iotfleetwise.model.InvalidSignalDecoder;
import software.amazon.awssdk.services.iotfleetwise.model.InvalidSignalDecodersCopier;
import software.amazon.awssdk.services.iotfleetwise.model.IoTFleetWiseException;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DecoderManifestValidationException
extends IoTFleetWiseException
implements ToCopyableBuilder<Builder, DecoderManifestValidationException> {
    private static final SdkField<List<InvalidSignalDecoder>> INVALID_SIGNALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("invalidSignals").getter(DecoderManifestValidationException.getter(DecoderManifestValidationException::invalidSignals)).setter(DecoderManifestValidationException.setter(Builder::invalidSignals)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invalidSignals").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InvalidSignalDecoder::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<InvalidNetworkInterface>> INVALID_NETWORK_INTERFACES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("invalidNetworkInterfaces").getter(DecoderManifestValidationException.getter(DecoderManifestValidationException::invalidNetworkInterfaces)).setter(DecoderManifestValidationException.setter(Builder::invalidNetworkInterfaces)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invalidNetworkInterfaces").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InvalidNetworkInterface::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVALID_SIGNALS_FIELD, INVALID_NETWORK_INTERFACES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DecoderManifestValidationException.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<InvalidSignalDecoder> invalidSignals;
    private final List<InvalidNetworkInterface> invalidNetworkInterfaces;

    private DecoderManifestValidationException(BuilderImpl builder) {
        super(builder);
        this.invalidSignals = builder.invalidSignals;
        this.invalidNetworkInterfaces = builder.invalidNetworkInterfaces;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public boolean hasInvalidSignals() {
        return this.invalidSignals != null && !(this.invalidSignals instanceof SdkAutoConstructList);
    }

    public List<InvalidSignalDecoder> invalidSignals() {
        return this.invalidSignals;
    }

    public boolean hasInvalidNetworkInterfaces() {
        return this.invalidNetworkInterfaces != null && !(this.invalidNetworkInterfaces instanceof SdkAutoConstructList);
    }

    public List<InvalidNetworkInterface> invalidNetworkInterfaces() {
        return this.invalidNetworkInterfaces;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("invalidSignals", INVALID_SIGNALS_FIELD);
        map.put("invalidNetworkInterfaces", INVALID_NETWORK_INTERFACES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DecoderManifestValidationException, T> g) {
        return obj -> g.apply((DecoderManifestValidationException)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTFleetWiseException.BuilderImpl
    implements Builder {
        private List<InvalidSignalDecoder> invalidSignals = DefaultSdkAutoConstructList.getInstance();
        private List<InvalidNetworkInterface> invalidNetworkInterfaces = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DecoderManifestValidationException model) {
            super(model);
            this.invalidSignals(model.invalidSignals);
            this.invalidNetworkInterfaces(model.invalidNetworkInterfaces);
        }

        public final List<InvalidSignalDecoder.Builder> getInvalidSignals() {
            List<InvalidSignalDecoder.Builder> result = InvalidSignalDecodersCopier.copyToBuilder(this.invalidSignals);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInvalidSignals(Collection<InvalidSignalDecoder.BuilderImpl> invalidSignals) {
            this.invalidSignals = InvalidSignalDecodersCopier.copyFromBuilder(invalidSignals);
        }

        @Override
        public final Builder invalidSignals(Collection<InvalidSignalDecoder> invalidSignals) {
            this.invalidSignals = InvalidSignalDecodersCopier.copy(invalidSignals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder invalidSignals(InvalidSignalDecoder ... invalidSignals) {
            this.invalidSignals(Arrays.asList(invalidSignals));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder invalidSignals(Consumer<InvalidSignalDecoder.Builder> ... invalidSignals) {
            this.invalidSignals(Stream.of(invalidSignals).map(c -> (InvalidSignalDecoder)((InvalidSignalDecoder.Builder)InvalidSignalDecoder.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<InvalidNetworkInterface.Builder> getInvalidNetworkInterfaces() {
            List<InvalidNetworkInterface.Builder> result = InvalidNetworkInterfacesCopier.copyToBuilder(this.invalidNetworkInterfaces);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInvalidNetworkInterfaces(Collection<InvalidNetworkInterface.BuilderImpl> invalidNetworkInterfaces) {
            this.invalidNetworkInterfaces = InvalidNetworkInterfacesCopier.copyFromBuilder(invalidNetworkInterfaces);
        }

        @Override
        public final Builder invalidNetworkInterfaces(Collection<InvalidNetworkInterface> invalidNetworkInterfaces) {
            this.invalidNetworkInterfaces = InvalidNetworkInterfacesCopier.copy(invalidNetworkInterfaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder invalidNetworkInterfaces(InvalidNetworkInterface ... invalidNetworkInterfaces) {
            this.invalidNetworkInterfaces(Arrays.asList(invalidNetworkInterfaces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder invalidNetworkInterfaces(Consumer<InvalidNetworkInterface.Builder> ... invalidNetworkInterfaces) {
            this.invalidNetworkInterfaces(Stream.of(invalidNetworkInterfaces).map(c -> (InvalidNetworkInterface)((InvalidNetworkInterface.Builder)InvalidNetworkInterface.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public BuilderImpl writableStackTrace(Boolean writableStackTrace) {
            this.writableStackTrace = writableStackTrace;
            return this;
        }

        @Override
        public BuilderImpl numAttempts(Integer numAttempts) {
            this.numAttempts = numAttempts;
            return this;
        }

        @Override
        public DecoderManifestValidationException build() {
            return new DecoderManifestValidationException(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DecoderManifestValidationException>,
    IoTFleetWiseException.Builder {
        public Builder invalidSignals(Collection<InvalidSignalDecoder> var1);

        public Builder invalidSignals(InvalidSignalDecoder ... var1);

        public Builder invalidSignals(Consumer<InvalidSignalDecoder.Builder> ... var1);

        public Builder invalidNetworkInterfaces(Collection<InvalidNetworkInterface> var1);

        public Builder invalidNetworkInterfaces(InvalidNetworkInterface ... var1);

        public Builder invalidNetworkInterfaces(Consumer<InvalidNetworkInterface.Builder> ... var1);

        @Override
        public Builder awsErrorDetails(AwsErrorDetails var1);

        @Override
        public Builder message(String var1);

        @Override
        public Builder requestId(String var1);

        @Override
        public Builder statusCode(int var1);

        @Override
        public Builder cause(Throwable var1);

        @Override
        public Builder writableStackTrace(Boolean var1);

        @Override
        public Builder numAttempts(Integer var1);
    }
}

