/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotfleetwise.IoTFleetWiseClient;
import software.amazon.awssdk.services.iotfleetwise.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestNetworkInterfacesRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ListDecoderManifestNetworkInterfacesResponse;
import software.amazon.awssdk.services.iotfleetwise.model.NetworkInterface;

public class ListDecoderManifestNetworkInterfacesIterable
implements SdkIterable<ListDecoderManifestNetworkInterfacesResponse> {
    private final IoTFleetWiseClient client;
    private final ListDecoderManifestNetworkInterfacesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDecoderManifestNetworkInterfacesIterable(IoTFleetWiseClient client, ListDecoderManifestNetworkInterfacesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDecoderManifestNetworkInterfacesResponseFetcher();
    }

    public Iterator<ListDecoderManifestNetworkInterfacesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<NetworkInterface> networkInterfaces() {
        Function<ListDecoderManifestNetworkInterfacesResponse, Iterator> getIterator = response -> {
            if (response != null && response.networkInterfaces() != null) {
                return response.networkInterfaces().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDecoderManifestNetworkInterfacesResponseFetcher
    implements SyncPageFetcher<ListDecoderManifestNetworkInterfacesResponse> {
        private ListDecoderManifestNetworkInterfacesResponseFetcher() {
        }

        public boolean hasNextPage(ListDecoderManifestNetworkInterfacesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDecoderManifestNetworkInterfacesResponse nextPage(ListDecoderManifestNetworkInterfacesResponse previousPage) {
            if (previousPage == null) {
                return ListDecoderManifestNetworkInterfacesIterable.this.client.listDecoderManifestNetworkInterfaces(ListDecoderManifestNetworkInterfacesIterable.this.firstRequest);
            }
            return ListDecoderManifestNetworkInterfacesIterable.this.client.listDecoderManifestNetworkInterfaces((ListDecoderManifestNetworkInterfacesRequest)((Object)ListDecoderManifestNetworkInterfacesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

