/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotfleetwise.IoTFleetWiseAsyncClient;
import software.amazon.awssdk.services.iotfleetwise.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotfleetwise.model.ListFleetsForVehicleRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ListFleetsForVehicleResponse;

public class ListFleetsForVehiclePublisher
implements SdkPublisher<ListFleetsForVehicleResponse> {
    private final IoTFleetWiseAsyncClient client;
    private final ListFleetsForVehicleRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListFleetsForVehiclePublisher(IoTFleetWiseAsyncClient client, ListFleetsForVehicleRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListFleetsForVehiclePublisher(IoTFleetWiseAsyncClient client, ListFleetsForVehicleRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListFleetsForVehicleResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListFleetsForVehicleResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> fleets() {
        Function<ListFleetsForVehicleResponse, Iterator> getIterator = response -> {
            if (response != null && response.fleets() != null) {
                return response.fleets().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListFleetsForVehicleResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListFleetsForVehicleResponseFetcher
    implements AsyncPageFetcher<ListFleetsForVehicleResponse> {
        private ListFleetsForVehicleResponseFetcher() {
        }

        public boolean hasNextPage(ListFleetsForVehicleResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListFleetsForVehicleResponse> nextPage(ListFleetsForVehicleResponse previousPage) {
            if (previousPage == null) {
                return ListFleetsForVehiclePublisher.this.client.listFleetsForVehicle(ListFleetsForVehiclePublisher.this.firstRequest);
            }
            return ListFleetsForVehiclePublisher.this.client.listFleetsForVehicle((ListFleetsForVehicleRequest)((Object)ListFleetsForVehiclePublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

