/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotfleetwise.model.IoTFleetWiseRequest;
import software.amazon.awssdk.services.iotfleetwise.model.UpdateVehicleRequestItem;
import software.amazon.awssdk.services.iotfleetwise.model._updateVehicleRequestItemsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchUpdateVehicleRequest
extends IoTFleetWiseRequest
implements ToCopyableBuilder<Builder, BatchUpdateVehicleRequest> {
    private static final SdkField<List<UpdateVehicleRequestItem>> VEHICLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("vehicles").getter(BatchUpdateVehicleRequest.getter(BatchUpdateVehicleRequest::vehicles)).setter(BatchUpdateVehicleRequest.setter(Builder::vehicles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vehicles").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UpdateVehicleRequestItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VEHICLES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchUpdateVehicleRequest.memberNameToFieldInitializer();
    private final List<UpdateVehicleRequestItem> vehicles;

    private BatchUpdateVehicleRequest(BuilderImpl builder) {
        super(builder);
        this.vehicles = builder.vehicles;
    }

    public final boolean hasVehicles() {
        return this.vehicles != null && !(this.vehicles instanceof SdkAutoConstructList);
    }

    public final List<UpdateVehicleRequestItem> vehicles() {
        return this.vehicles;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVehicles() ? this.vehicles() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateVehicleRequest)) {
            return false;
        }
        BatchUpdateVehicleRequest other = (BatchUpdateVehicleRequest)((Object)obj);
        return this.hasVehicles() == other.hasVehicles() && Objects.equals(this.vehicles(), other.vehicles());
    }

    public final String toString() {
        return ToString.builder((String)"BatchUpdateVehicleRequest").add("Vehicles", this.hasVehicles() ? this.vehicles() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "vehicles": {
                return Optional.ofNullable(clazz.cast(this.vehicles()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<UpdateVehicleRequestItem>>> map = new HashMap<String, SdkField<List<UpdateVehicleRequestItem>>>();
        map.put("vehicles", VEHICLES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchUpdateVehicleRequest, T> g) {
        return obj -> g.apply((BatchUpdateVehicleRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTFleetWiseRequest.BuilderImpl
    implements Builder {
        private List<UpdateVehicleRequestItem> vehicles = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpdateVehicleRequest model) {
            super(model);
            this.vehicles(model.vehicles);
        }

        public final List<UpdateVehicleRequestItem.Builder> getVehicles() {
            List<UpdateVehicleRequestItem.Builder> result = _updateVehicleRequestItemsCopier.copyToBuilder(this.vehicles);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVehicles(Collection<UpdateVehicleRequestItem.BuilderImpl> vehicles) {
            this.vehicles = _updateVehicleRequestItemsCopier.copyFromBuilder(vehicles);
        }

        @Override
        public final Builder vehicles(Collection<UpdateVehicleRequestItem> vehicles) {
            this.vehicles = _updateVehicleRequestItemsCopier.copy(vehicles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vehicles(UpdateVehicleRequestItem ... vehicles) {
            this.vehicles(Arrays.asList(vehicles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vehicles(Consumer<UpdateVehicleRequestItem.Builder> ... vehicles) {
            this.vehicles(Stream.of(vehicles).map(c -> (UpdateVehicleRequestItem)((UpdateVehicleRequestItem.Builder)UpdateVehicleRequestItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchUpdateVehicleRequest build() {
            return new BatchUpdateVehicleRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IoTFleetWiseRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchUpdateVehicleRequest> {
        public Builder vehicles(Collection<UpdateVehicleRequestItem> var1);

        public Builder vehicles(UpdateVehicleRequestItem ... var1);

        public Builder vehicles(Consumer<UpdateVehicleRequestItem.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

