/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotfleetwise.model.CanSignal;
import software.amazon.awssdk.services.iotfleetwise.model.CustomDecodingSignal;
import software.amazon.awssdk.services.iotfleetwise.model.MessageSignal;
import software.amazon.awssdk.services.iotfleetwise.model.ObdSignal;
import software.amazon.awssdk.services.iotfleetwise.model.SignalDecoderType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SignalDecoder
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SignalDecoder> {
    private static final SdkField<String> FULLY_QUALIFIED_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fullyQualifiedName").getter(SignalDecoder.getter(SignalDecoder::fullyQualifiedName)).setter(SignalDecoder.setter(Builder::fullyQualifiedName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fullyQualifiedName").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(SignalDecoder.getter(SignalDecoder::typeAsString)).setter(SignalDecoder.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> INTERFACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("interfaceId").getter(SignalDecoder.getter(SignalDecoder::interfaceId)).setter(SignalDecoder.setter(Builder::interfaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interfaceId").build()}).build();
    private static final SdkField<CanSignal> CAN_SIGNAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("canSignal").getter(SignalDecoder.getter(SignalDecoder::canSignal)).setter(SignalDecoder.setter(Builder::canSignal)).constructor(CanSignal::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("canSignal").build()}).build();
    private static final SdkField<ObdSignal> OBD_SIGNAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("obdSignal").getter(SignalDecoder.getter(SignalDecoder::obdSignal)).setter(SignalDecoder.setter(Builder::obdSignal)).constructor(ObdSignal::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("obdSignal").build()}).build();
    private static final SdkField<MessageSignal> MESSAGE_SIGNAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("messageSignal").getter(SignalDecoder.getter(SignalDecoder::messageSignal)).setter(SignalDecoder.setter(Builder::messageSignal)).constructor(MessageSignal::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messageSignal").build()}).build();
    private static final SdkField<CustomDecodingSignal> CUSTOM_DECODING_SIGNAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("customDecodingSignal").getter(SignalDecoder.getter(SignalDecoder::customDecodingSignal)).setter(SignalDecoder.setter(Builder::customDecodingSignal)).constructor(CustomDecodingSignal::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customDecodingSignal").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FULLY_QUALIFIED_NAME_FIELD, TYPE_FIELD, INTERFACE_ID_FIELD, CAN_SIGNAL_FIELD, OBD_SIGNAL_FIELD, MESSAGE_SIGNAL_FIELD, CUSTOM_DECODING_SIGNAL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SignalDecoder.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String fullyQualifiedName;
    private final String type;
    private final String interfaceId;
    private final CanSignal canSignal;
    private final ObdSignal obdSignal;
    private final MessageSignal messageSignal;
    private final CustomDecodingSignal customDecodingSignal;

    private SignalDecoder(BuilderImpl builder) {
        this.fullyQualifiedName = builder.fullyQualifiedName;
        this.type = builder.type;
        this.interfaceId = builder.interfaceId;
        this.canSignal = builder.canSignal;
        this.obdSignal = builder.obdSignal;
        this.messageSignal = builder.messageSignal;
        this.customDecodingSignal = builder.customDecodingSignal;
    }

    public final String fullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    public final SignalDecoderType type() {
        return SignalDecoderType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String interfaceId() {
        return this.interfaceId;
    }

    public final CanSignal canSignal() {
        return this.canSignal;
    }

    public final ObdSignal obdSignal() {
        return this.obdSignal;
    }

    public final MessageSignal messageSignal() {
        return this.messageSignal;
    }

    public final CustomDecodingSignal customDecodingSignal() {
        return this.customDecodingSignal;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fullyQualifiedName());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.interfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.canSignal());
        hashCode = 31 * hashCode + Objects.hashCode(this.obdSignal());
        hashCode = 31 * hashCode + Objects.hashCode(this.messageSignal());
        hashCode = 31 * hashCode + Objects.hashCode(this.customDecodingSignal());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SignalDecoder)) {
            return false;
        }
        SignalDecoder other = (SignalDecoder)obj;
        return Objects.equals(this.fullyQualifiedName(), other.fullyQualifiedName()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.interfaceId(), other.interfaceId()) && Objects.equals(this.canSignal(), other.canSignal()) && Objects.equals(this.obdSignal(), other.obdSignal()) && Objects.equals(this.messageSignal(), other.messageSignal()) && Objects.equals(this.customDecodingSignal(), other.customDecodingSignal());
    }

    public final String toString() {
        return ToString.builder((String)"SignalDecoder").add("FullyQualifiedName", (Object)this.fullyQualifiedName()).add("Type", (Object)this.typeAsString()).add("InterfaceId", (Object)this.interfaceId()).add("CanSignal", (Object)this.canSignal()).add("ObdSignal", (Object)this.obdSignal()).add("MessageSignal", (Object)this.messageSignal()).add("CustomDecodingSignal", (Object)this.customDecodingSignal()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "fullyQualifiedName": {
                return Optional.ofNullable(clazz.cast(this.fullyQualifiedName()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "interfaceId": {
                return Optional.ofNullable(clazz.cast(this.interfaceId()));
            }
            case "canSignal": {
                return Optional.ofNullable(clazz.cast(this.canSignal()));
            }
            case "obdSignal": {
                return Optional.ofNullable(clazz.cast(this.obdSignal()));
            }
            case "messageSignal": {
                return Optional.ofNullable(clazz.cast(this.messageSignal()));
            }
            case "customDecodingSignal": {
                return Optional.ofNullable(clazz.cast(this.customDecodingSignal()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("fullyQualifiedName", FULLY_QUALIFIED_NAME_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("interfaceId", INTERFACE_ID_FIELD);
        map.put("canSignal", CAN_SIGNAL_FIELD);
        map.put("obdSignal", OBD_SIGNAL_FIELD);
        map.put("messageSignal", MESSAGE_SIGNAL_FIELD);
        map.put("customDecodingSignal", CUSTOM_DECODING_SIGNAL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SignalDecoder, T> g) {
        return obj -> g.apply((SignalDecoder)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String fullyQualifiedName;
        private String type;
        private String interfaceId;
        private CanSignal canSignal;
        private ObdSignal obdSignal;
        private MessageSignal messageSignal;
        private CustomDecodingSignal customDecodingSignal;

        private BuilderImpl() {
        }

        private BuilderImpl(SignalDecoder model) {
            this.fullyQualifiedName(model.fullyQualifiedName);
            this.type(model.type);
            this.interfaceId(model.interfaceId);
            this.canSignal(model.canSignal);
            this.obdSignal(model.obdSignal);
            this.messageSignal(model.messageSignal);
            this.customDecodingSignal(model.customDecodingSignal);
        }

        public final String getFullyQualifiedName() {
            return this.fullyQualifiedName;
        }

        public final void setFullyQualifiedName(String fullyQualifiedName) {
            this.fullyQualifiedName = fullyQualifiedName;
        }

        @Override
        public final Builder fullyQualifiedName(String fullyQualifiedName) {
            this.fullyQualifiedName = fullyQualifiedName;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(SignalDecoderType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getInterfaceId() {
            return this.interfaceId;
        }

        public final void setInterfaceId(String interfaceId) {
            this.interfaceId = interfaceId;
        }

        @Override
        public final Builder interfaceId(String interfaceId) {
            this.interfaceId = interfaceId;
            return this;
        }

        public final CanSignal.Builder getCanSignal() {
            return this.canSignal != null ? this.canSignal.toBuilder() : null;
        }

        public final void setCanSignal(CanSignal.BuilderImpl canSignal) {
            this.canSignal = canSignal != null ? canSignal.build() : null;
        }

        @Override
        public final Builder canSignal(CanSignal canSignal) {
            this.canSignal = canSignal;
            return this;
        }

        public final ObdSignal.Builder getObdSignal() {
            return this.obdSignal != null ? this.obdSignal.toBuilder() : null;
        }

        public final void setObdSignal(ObdSignal.BuilderImpl obdSignal) {
            this.obdSignal = obdSignal != null ? obdSignal.build() : null;
        }

        @Override
        public final Builder obdSignal(ObdSignal obdSignal) {
            this.obdSignal = obdSignal;
            return this;
        }

        public final MessageSignal.Builder getMessageSignal() {
            return this.messageSignal != null ? this.messageSignal.toBuilder() : null;
        }

        public final void setMessageSignal(MessageSignal.BuilderImpl messageSignal) {
            this.messageSignal = messageSignal != null ? messageSignal.build() : null;
        }

        @Override
        public final Builder messageSignal(MessageSignal messageSignal) {
            this.messageSignal = messageSignal;
            return this;
        }

        public final CustomDecodingSignal.Builder getCustomDecodingSignal() {
            return this.customDecodingSignal != null ? this.customDecodingSignal.toBuilder() : null;
        }

        public final void setCustomDecodingSignal(CustomDecodingSignal.BuilderImpl customDecodingSignal) {
            this.customDecodingSignal = customDecodingSignal != null ? customDecodingSignal.build() : null;
        }

        @Override
        public final Builder customDecodingSignal(CustomDecodingSignal customDecodingSignal) {
            this.customDecodingSignal = customDecodingSignal;
            return this;
        }

        public SignalDecoder build() {
            return new SignalDecoder(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SignalDecoder> {
        public Builder fullyQualifiedName(String var1);

        public Builder type(String var1);

        public Builder type(SignalDecoderType var1);

        public Builder interfaceId(String var1);

        public Builder canSignal(CanSignal var1);

        default public Builder canSignal(Consumer<CanSignal.Builder> canSignal) {
            return this.canSignal((CanSignal)((CanSignal.Builder)CanSignal.builder().applyMutation(canSignal)).build());
        }

        public Builder obdSignal(ObdSignal var1);

        default public Builder obdSignal(Consumer<ObdSignal.Builder> obdSignal) {
            return this.obdSignal((ObdSignal)((ObdSignal.Builder)ObdSignal.builder().applyMutation(obdSignal)).build());
        }

        public Builder messageSignal(MessageSignal var1);

        default public Builder messageSignal(Consumer<MessageSignal.Builder> messageSignal) {
            return this.messageSignal((MessageSignal)((MessageSignal.Builder)MessageSignal.builder().applyMutation(messageSignal)).build());
        }

        public Builder customDecodingSignal(CustomDecodingSignal var1);

        default public Builder customDecodingSignal(Consumer<CustomDecodingSignal.Builder> customDecodingSignal) {
            return this.customDecodingSignal((CustomDecodingSignal)((CustomDecodingSignal.Builder)CustomDecodingSignal.builder().applyMutation(customDecodingSignal)).build());
        }
    }
}

