/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotfleetwise.model.IoTFleetWiseResponse;
import software.amazon.awssdk.services.iotfleetwise.model.UpdateVehicleError;
import software.amazon.awssdk.services.iotfleetwise.model.UpdateVehicleResponseItem;
import software.amazon.awssdk.services.iotfleetwise.model._updateVehicleErrorsCopier;
import software.amazon.awssdk.services.iotfleetwise.model._updateVehicleResponseItemsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchUpdateVehicleResponse
extends IoTFleetWiseResponse
implements ToCopyableBuilder<Builder, BatchUpdateVehicleResponse> {
    private static final SdkField<List<UpdateVehicleResponseItem>> VEHICLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("vehicles").getter(BatchUpdateVehicleResponse.getter(BatchUpdateVehicleResponse::vehicles)).setter(BatchUpdateVehicleResponse.setter(Builder::vehicles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vehicles").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UpdateVehicleResponseItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<UpdateVehicleError>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("errors").getter(BatchUpdateVehicleResponse.getter(BatchUpdateVehicleResponse::errors)).setter(BatchUpdateVehicleResponse.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UpdateVehicleError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VEHICLES_FIELD, ERRORS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("vehicles", VEHICLES_FIELD);
            this.put("errors", ERRORS_FIELD);
        }
    });
    private final List<UpdateVehicleResponseItem> vehicles;
    private final List<UpdateVehicleError> errors;

    private BatchUpdateVehicleResponse(BuilderImpl builder) {
        super(builder);
        this.vehicles = builder.vehicles;
        this.errors = builder.errors;
    }

    public final boolean hasVehicles() {
        return this.vehicles != null && !(this.vehicles instanceof SdkAutoConstructList);
    }

    public final List<UpdateVehicleResponseItem> vehicles() {
        return this.vehicles;
    }

    public final boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public final List<UpdateVehicleError> errors() {
        return this.errors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVehicles() ? this.vehicles() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateVehicleResponse)) {
            return false;
        }
        BatchUpdateVehicleResponse other = (BatchUpdateVehicleResponse)((Object)obj);
        return this.hasVehicles() == other.hasVehicles() && Objects.equals(this.vehicles(), other.vehicles()) && this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors());
    }

    public final String toString() {
        return ToString.builder((String)"BatchUpdateVehicleResponse").add("Vehicles", this.hasVehicles() ? this.vehicles() : null).add("Errors", this.hasErrors() ? this.errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "vehicles": {
                return Optional.ofNullable(clazz.cast(this.vehicles()));
            }
            case "errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchUpdateVehicleResponse, T> g) {
        return obj -> g.apply((BatchUpdateVehicleResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTFleetWiseResponse.BuilderImpl
    implements Builder {
        private List<UpdateVehicleResponseItem> vehicles = DefaultSdkAutoConstructList.getInstance();
        private List<UpdateVehicleError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpdateVehicleResponse model) {
            super(model);
            this.vehicles(model.vehicles);
            this.errors(model.errors);
        }

        public final List<UpdateVehicleResponseItem.Builder> getVehicles() {
            List<UpdateVehicleResponseItem.Builder> result = _updateVehicleResponseItemsCopier.copyToBuilder(this.vehicles);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVehicles(Collection<UpdateVehicleResponseItem.BuilderImpl> vehicles) {
            this.vehicles = _updateVehicleResponseItemsCopier.copyFromBuilder(vehicles);
        }

        @Override
        public final Builder vehicles(Collection<UpdateVehicleResponseItem> vehicles) {
            this.vehicles = _updateVehicleResponseItemsCopier.copy(vehicles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vehicles(UpdateVehicleResponseItem ... vehicles) {
            this.vehicles(Arrays.asList(vehicles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vehicles(Consumer<UpdateVehicleResponseItem.Builder> ... vehicles) {
            this.vehicles(Stream.of(vehicles).map(c -> (UpdateVehicleResponseItem)((UpdateVehicleResponseItem.Builder)UpdateVehicleResponseItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<UpdateVehicleError.Builder> getErrors() {
            List<UpdateVehicleError.Builder> result = _updateVehicleErrorsCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<UpdateVehicleError.BuilderImpl> errors) {
            this.errors = _updateVehicleErrorsCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<UpdateVehicleError> errors) {
            this.errors = _updateVehicleErrorsCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(UpdateVehicleError ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<UpdateVehicleError.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (UpdateVehicleError)((UpdateVehicleError.Builder)UpdateVehicleError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchUpdateVehicleResponse build() {
            return new BatchUpdateVehicleResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IoTFleetWiseResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchUpdateVehicleResponse> {
        public Builder vehicles(Collection<UpdateVehicleResponseItem> var1);

        public Builder vehicles(UpdateVehicleResponseItem ... var1);

        public Builder vehicles(Consumer<UpdateVehicleResponseItem.Builder> ... var1);

        public Builder errors(Collection<UpdateVehicleError> var1);

        public Builder errors(UpdateVehicleError ... var1);

        public Builder errors(Consumer<UpdateVehicleError.Builder> ... var1);
    }
}

