/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotfleetwise.model.NodeDataEncoding;
import software.amazon.awssdk.services.iotfleetwise.model.NodeDataType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CustomProperty
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CustomProperty> {
    private static final SdkField<String> FULLY_QUALIFIED_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fullyQualifiedName").getter(CustomProperty.getter(CustomProperty::fullyQualifiedName)).setter(CustomProperty.setter(Builder::fullyQualifiedName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fullyQualifiedName").build()}).build();
    private static final SdkField<String> DATA_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataType").getter(CustomProperty.getter(CustomProperty::dataTypeAsString)).setter(CustomProperty.setter(Builder::dataType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataType").build()}).build();
    private static final SdkField<String> DATA_ENCODING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataEncoding").getter(CustomProperty.getter(CustomProperty::dataEncodingAsString)).setter(CustomProperty.setter(Builder::dataEncoding)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataEncoding").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CustomProperty.getter(CustomProperty::description)).setter(CustomProperty.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> DEPRECATION_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deprecationMessage").getter(CustomProperty.getter(CustomProperty::deprecationMessage)).setter(CustomProperty.setter(Builder::deprecationMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deprecationMessage").build()}).build();
    private static final SdkField<String> COMMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("comment").getter(CustomProperty.getter(CustomProperty::comment)).setter(CustomProperty.setter(Builder::comment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comment").build()}).build();
    private static final SdkField<String> STRUCT_FULLY_QUALIFIED_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("structFullyQualifiedName").getter(CustomProperty.getter(CustomProperty::structFullyQualifiedName)).setter(CustomProperty.setter(Builder::structFullyQualifiedName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("structFullyQualifiedName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FULLY_QUALIFIED_NAME_FIELD, DATA_TYPE_FIELD, DATA_ENCODING_FIELD, DESCRIPTION_FIELD, DEPRECATION_MESSAGE_FIELD, COMMENT_FIELD, STRUCT_FULLY_QUALIFIED_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("fullyQualifiedName", FULLY_QUALIFIED_NAME_FIELD);
            this.put("dataType", DATA_TYPE_FIELD);
            this.put("dataEncoding", DATA_ENCODING_FIELD);
            this.put("description", DESCRIPTION_FIELD);
            this.put("deprecationMessage", DEPRECATION_MESSAGE_FIELD);
            this.put("comment", COMMENT_FIELD);
            this.put("structFullyQualifiedName", STRUCT_FULLY_QUALIFIED_NAME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String fullyQualifiedName;
    private final String dataType;
    private final String dataEncoding;
    private final String description;
    private final String deprecationMessage;
    private final String comment;
    private final String structFullyQualifiedName;

    private CustomProperty(BuilderImpl builder) {
        this.fullyQualifiedName = builder.fullyQualifiedName;
        this.dataType = builder.dataType;
        this.dataEncoding = builder.dataEncoding;
        this.description = builder.description;
        this.deprecationMessage = builder.deprecationMessage;
        this.comment = builder.comment;
        this.structFullyQualifiedName = builder.structFullyQualifiedName;
    }

    public final String fullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    public final NodeDataType dataType() {
        return NodeDataType.fromValue(this.dataType);
    }

    public final String dataTypeAsString() {
        return this.dataType;
    }

    public final NodeDataEncoding dataEncoding() {
        return NodeDataEncoding.fromValue(this.dataEncoding);
    }

    public final String dataEncodingAsString() {
        return this.dataEncoding;
    }

    public final String description() {
        return this.description;
    }

    public final String deprecationMessage() {
        return this.deprecationMessage;
    }

    public final String comment() {
        return this.comment;
    }

    public final String structFullyQualifiedName() {
        return this.structFullyQualifiedName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fullyQualifiedName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataEncodingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.deprecationMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.comment());
        hashCode = 31 * hashCode + Objects.hashCode(this.structFullyQualifiedName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomProperty)) {
            return false;
        }
        CustomProperty other = (CustomProperty)obj;
        return Objects.equals(this.fullyQualifiedName(), other.fullyQualifiedName()) && Objects.equals(this.dataTypeAsString(), other.dataTypeAsString()) && Objects.equals(this.dataEncodingAsString(), other.dataEncodingAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.deprecationMessage(), other.deprecationMessage()) && Objects.equals(this.comment(), other.comment()) && Objects.equals(this.structFullyQualifiedName(), other.structFullyQualifiedName());
    }

    public final String toString() {
        return ToString.builder((String)"CustomProperty").add("FullyQualifiedName", (Object)this.fullyQualifiedName()).add("DataType", (Object)this.dataTypeAsString()).add("DataEncoding", (Object)this.dataEncodingAsString()).add("Description", (Object)this.description()).add("DeprecationMessage", (Object)this.deprecationMessage()).add("Comment", (Object)this.comment()).add("StructFullyQualifiedName", (Object)this.structFullyQualifiedName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "fullyQualifiedName": {
                return Optional.ofNullable(clazz.cast(this.fullyQualifiedName()));
            }
            case "dataType": {
                return Optional.ofNullable(clazz.cast(this.dataTypeAsString()));
            }
            case "dataEncoding": {
                return Optional.ofNullable(clazz.cast(this.dataEncodingAsString()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "deprecationMessage": {
                return Optional.ofNullable(clazz.cast(this.deprecationMessage()));
            }
            case "comment": {
                return Optional.ofNullable(clazz.cast(this.comment()));
            }
            case "structFullyQualifiedName": {
                return Optional.ofNullable(clazz.cast(this.structFullyQualifiedName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CustomProperty, T> g) {
        return obj -> g.apply((CustomProperty)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String fullyQualifiedName;
        private String dataType;
        private String dataEncoding;
        private String description;
        private String deprecationMessage;
        private String comment;
        private String structFullyQualifiedName;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomProperty model) {
            this.fullyQualifiedName(model.fullyQualifiedName);
            this.dataType(model.dataType);
            this.dataEncoding(model.dataEncoding);
            this.description(model.description);
            this.deprecationMessage(model.deprecationMessage);
            this.comment(model.comment);
            this.structFullyQualifiedName(model.structFullyQualifiedName);
        }

        public final String getFullyQualifiedName() {
            return this.fullyQualifiedName;
        }

        public final void setFullyQualifiedName(String fullyQualifiedName) {
            this.fullyQualifiedName = fullyQualifiedName;
        }

        @Override
        public final Builder fullyQualifiedName(String fullyQualifiedName) {
            this.fullyQualifiedName = fullyQualifiedName;
            return this;
        }

        public final String getDataType() {
            return this.dataType;
        }

        public final void setDataType(String dataType) {
            this.dataType = dataType;
        }

        @Override
        public final Builder dataType(String dataType) {
            this.dataType = dataType;
            return this;
        }

        @Override
        public final Builder dataType(NodeDataType dataType) {
            this.dataType(dataType == null ? null : dataType.toString());
            return this;
        }

        public final String getDataEncoding() {
            return this.dataEncoding;
        }

        public final void setDataEncoding(String dataEncoding) {
            this.dataEncoding = dataEncoding;
        }

        @Override
        public final Builder dataEncoding(String dataEncoding) {
            this.dataEncoding = dataEncoding;
            return this;
        }

        @Override
        public final Builder dataEncoding(NodeDataEncoding dataEncoding) {
            this.dataEncoding(dataEncoding == null ? null : dataEncoding.toString());
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDeprecationMessage() {
            return this.deprecationMessage;
        }

        public final void setDeprecationMessage(String deprecationMessage) {
            this.deprecationMessage = deprecationMessage;
        }

        @Override
        public final Builder deprecationMessage(String deprecationMessage) {
            this.deprecationMessage = deprecationMessage;
            return this;
        }

        public final String getComment() {
            return this.comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final String getStructFullyQualifiedName() {
            return this.structFullyQualifiedName;
        }

        public final void setStructFullyQualifiedName(String structFullyQualifiedName) {
            this.structFullyQualifiedName = structFullyQualifiedName;
        }

        @Override
        public final Builder structFullyQualifiedName(String structFullyQualifiedName) {
            this.structFullyQualifiedName = structFullyQualifiedName;
            return this;
        }

        public CustomProperty build() {
            return new CustomProperty(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CustomProperty> {
        public Builder fullyQualifiedName(String var1);

        public Builder dataType(String var1);

        public Builder dataType(NodeDataType var1);

        public Builder dataEncoding(String var1);

        public Builder dataEncoding(NodeDataEncoding var1);

        public Builder description(String var1);

        public Builder deprecationMessage(String var1);

        public Builder comment(String var1);

        public Builder structFullyQualifiedName(String var1);
    }
}

