/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotfleetwise.IoTFleetWiseClient;
import software.amazon.awssdk.services.iotfleetwise.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotfleetwise.model.GetVehicleStatusRequest;
import software.amazon.awssdk.services.iotfleetwise.model.GetVehicleStatusResponse;
import software.amazon.awssdk.services.iotfleetwise.model.VehicleStatus;

public class GetVehicleStatusIterable
implements SdkIterable<GetVehicleStatusResponse> {
    private final IoTFleetWiseClient client;
    private final GetVehicleStatusRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetVehicleStatusIterable(IoTFleetWiseClient client, GetVehicleStatusRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetVehicleStatusResponseFetcher();
    }

    public Iterator<GetVehicleStatusResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<VehicleStatus> campaigns() {
        Function<GetVehicleStatusResponse, Iterator> getIterator = response -> {
            if (response != null && response.campaigns() != null) {
                return response.campaigns().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetVehicleStatusResponseFetcher
    implements SyncPageFetcher<GetVehicleStatusResponse> {
        private GetVehicleStatusResponseFetcher() {
        }

        public boolean hasNextPage(GetVehicleStatusResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetVehicleStatusResponse nextPage(GetVehicleStatusResponse previousPage) {
            if (previousPage == null) {
                return GetVehicleStatusIterable.this.client.getVehicleStatus(GetVehicleStatusIterable.this.firstRequest);
            }
            return GetVehicleStatusIterable.this.client.getVehicleStatus((GetVehicleStatusRequest)((Object)GetVehicleStatusIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

