/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum NetworkInterfaceFailureReason {
    DUPLICATE_NETWORK_INTERFACE("DUPLICATE_NETWORK_INTERFACE"),
    CONFLICTING_NETWORK_INTERFACE("CONFLICTING_NETWORK_INTERFACE"),
    NETWORK_INTERFACE_TO_ADD_ALREADY_EXISTS("NETWORK_INTERFACE_TO_ADD_ALREADY_EXISTS"),
    CAN_NETWORK_INTERFACE_INFO_IS_NULL("CAN_NETWORK_INTERFACE_INFO_IS_NULL"),
    OBD_NETWORK_INTERFACE_INFO_IS_NULL("OBD_NETWORK_INTERFACE_INFO_IS_NULL"),
    NETWORK_INTERFACE_TO_REMOVE_ASSOCIATED_WITH_SIGNALS("NETWORK_INTERFACE_TO_REMOVE_ASSOCIATED_WITH_SIGNALS"),
    VEHICLE_MIDDLEWARE_NETWORK_INTERFACE_INFO_IS_NULL("VEHICLE_MIDDLEWARE_NETWORK_INTERFACE_INFO_IS_NULL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, NetworkInterfaceFailureReason> VALUE_MAP;
    private final String value;

    private NetworkInterfaceFailureReason(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static NetworkInterfaceFailureReason fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<NetworkInterfaceFailureReason> knownValues() {
        EnumSet<NetworkInterfaceFailureReason> knownValues = EnumSet.allOf(NetworkInterfaceFailureReason.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(NetworkInterfaceFailureReason.class, NetworkInterfaceFailureReason::toString);
    }
}

