/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotfleetwise.IoTFleetWiseAsyncClient;
import software.amazon.awssdk.services.iotfleetwise.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestsRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ListModelManifestsResponse;
import software.amazon.awssdk.services.iotfleetwise.model.ModelManifestSummary;

public class ListModelManifestsPublisher
implements SdkPublisher<ListModelManifestsResponse> {
    private final IoTFleetWiseAsyncClient client;
    private final ListModelManifestsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListModelManifestsPublisher(IoTFleetWiseAsyncClient client, ListModelManifestsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListModelManifestsPublisher(IoTFleetWiseAsyncClient client, ListModelManifestsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListModelManifestsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListModelManifestsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ModelManifestSummary> summaries() {
        Function<ListModelManifestsResponse, Iterator> getIterator = response -> {
            if (response != null && response.summaries() != null) {
                return response.summaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListModelManifestsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListModelManifestsResponseFetcher
    implements AsyncPageFetcher<ListModelManifestsResponse> {
        private ListModelManifestsResponseFetcher() {
        }

        public boolean hasNextPage(ListModelManifestsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListModelManifestsResponse> nextPage(ListModelManifestsResponse previousPage) {
            if (previousPage == null) {
                return ListModelManifestsPublisher.this.client.listModelManifests(ListModelManifestsPublisher.this.firstRequest);
            }
            return ListModelManifestsPublisher.this.client.listModelManifests((ListModelManifestsRequest)((Object)ListModelManifestsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

