/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iotfleetwise.model.Actuator;
import software.amazon.awssdk.services.iotfleetwise.model.Attribute;
import software.amazon.awssdk.services.iotfleetwise.model.Branch;
import software.amazon.awssdk.services.iotfleetwise.model.Sensor;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Node
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Node> {
    private static final SdkField<Branch> BRANCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("branch").getter(Node.getter(Node::branch)).setter(Node.setter(Builder::branch)).constructor(Branch::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("branch").build()}).build();
    private static final SdkField<Sensor> SENSOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sensor").getter(Node.getter(Node::sensor)).setter(Node.setter(Builder::sensor)).constructor(Sensor::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sensor").build()}).build();
    private static final SdkField<Actuator> ACTUATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("actuator").getter(Node.getter(Node::actuator)).setter(Node.setter(Builder::actuator)).constructor(Actuator::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actuator").build()}).build();
    private static final SdkField<Attribute> ATTRIBUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("attribute").getter(Node.getter(Node::attribute)).setter(Node.setter(Builder::attribute)).constructor(Attribute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attribute").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BRANCH_FIELD, SENSOR_FIELD, ACTUATOR_FIELD, ATTRIBUTE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Branch branch;
    private final Sensor sensor;
    private final Actuator actuator;
    private final Attribute attribute;
    private final Type type;

    private Node(BuilderImpl builder) {
        this.branch = builder.branch;
        this.sensor = builder.sensor;
        this.actuator = builder.actuator;
        this.attribute = builder.attribute;
        this.type = builder.type;
    }

    public final Branch branch() {
        return this.branch;
    }

    public final Sensor sensor() {
        return this.sensor;
    }

    public final Actuator actuator() {
        return this.actuator;
    }

    public final Attribute attribute() {
        return this.attribute;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.branch());
        hashCode = 31 * hashCode + Objects.hashCode(this.sensor());
        hashCode = 31 * hashCode + Objects.hashCode(this.actuator());
        hashCode = 31 * hashCode + Objects.hashCode(this.attribute());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Node)) {
            return false;
        }
        Node other = (Node)obj;
        return Objects.equals(this.branch(), other.branch()) && Objects.equals(this.sensor(), other.sensor()) && Objects.equals(this.actuator(), other.actuator()) && Objects.equals(this.attribute(), other.attribute());
    }

    public final String toString() {
        return ToString.builder((String)"Node").add("Branch", (Object)this.branch()).add("Sensor", (Object)this.sensor()).add("Actuator", (Object)this.actuator()).add("Attribute", (Object)this.attribute()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "branch": {
                return Optional.ofNullable(clazz.cast(this.branch()));
            }
            case "sensor": {
                return Optional.ofNullable(clazz.cast(this.sensor()));
            }
            case "actuator": {
                return Optional.ofNullable(clazz.cast(this.actuator()));
            }
            case "attribute": {
                return Optional.ofNullable(clazz.cast(this.attribute()));
            }
        }
        return Optional.empty();
    }

    public static Node fromBranch(Branch branch) {
        return (Node)Node.builder().branch(branch).build();
    }

    public static Node fromBranch(Consumer<Branch.Builder> branch) {
        Branch.Builder builder = Branch.builder();
        branch.accept(builder);
        return Node.fromBranch((Branch)builder.build());
    }

    public static Node fromSensor(Sensor sensor) {
        return (Node)Node.builder().sensor(sensor).build();
    }

    public static Node fromSensor(Consumer<Sensor.Builder> sensor) {
        Sensor.Builder builder = Sensor.builder();
        sensor.accept(builder);
        return Node.fromSensor((Sensor)builder.build());
    }

    public static Node fromActuator(Actuator actuator) {
        return (Node)Node.builder().actuator(actuator).build();
    }

    public static Node fromActuator(Consumer<Actuator.Builder> actuator) {
        Actuator.Builder builder = Actuator.builder();
        actuator.accept(builder);
        return Node.fromActuator((Actuator)builder.build());
    }

    public static Node fromAttribute(Attribute attribute) {
        return (Node)Node.builder().attribute(attribute).build();
    }

    public static Node fromAttribute(Consumer<Attribute.Builder> attribute) {
        Attribute.Builder builder = Attribute.builder();
        attribute.accept(builder);
        return Node.fromAttribute((Attribute)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Node, T> g) {
        return obj -> g.apply((Node)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        BRANCH,
        SENSOR,
        ACTUATOR,
        ATTRIBUTE,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private Branch branch;
        private Sensor sensor;
        private Actuator actuator;
        private Attribute attribute;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(Node model) {
            this.branch(model.branch);
            this.sensor(model.sensor);
            this.actuator(model.actuator);
            this.attribute(model.attribute);
        }

        public final Branch.Builder getBranch() {
            return this.branch != null ? this.branch.toBuilder() : null;
        }

        public final void setBranch(Branch.BuilderImpl branch) {
            Branch oldValue = this.branch;
            this.branch = branch != null ? branch.build() : null;
            this.handleUnionValueChange(Type.BRANCH, oldValue, this.branch);
        }

        @Override
        public final Builder branch(Branch branch) {
            Branch oldValue = this.branch;
            this.branch = branch;
            this.handleUnionValueChange(Type.BRANCH, oldValue, this.branch);
            return this;
        }

        public final Sensor.Builder getSensor() {
            return this.sensor != null ? this.sensor.toBuilder() : null;
        }

        public final void setSensor(Sensor.BuilderImpl sensor) {
            Sensor oldValue = this.sensor;
            this.sensor = sensor != null ? sensor.build() : null;
            this.handleUnionValueChange(Type.SENSOR, oldValue, this.sensor);
        }

        @Override
        public final Builder sensor(Sensor sensor) {
            Sensor oldValue = this.sensor;
            this.sensor = sensor;
            this.handleUnionValueChange(Type.SENSOR, oldValue, this.sensor);
            return this;
        }

        public final Actuator.Builder getActuator() {
            return this.actuator != null ? this.actuator.toBuilder() : null;
        }

        public final void setActuator(Actuator.BuilderImpl actuator) {
            Actuator oldValue = this.actuator;
            this.actuator = actuator != null ? actuator.build() : null;
            this.handleUnionValueChange(Type.ACTUATOR, oldValue, this.actuator);
        }

        @Override
        public final Builder actuator(Actuator actuator) {
            Actuator oldValue = this.actuator;
            this.actuator = actuator;
            this.handleUnionValueChange(Type.ACTUATOR, oldValue, this.actuator);
            return this;
        }

        public final Attribute.Builder getAttribute() {
            return this.attribute != null ? this.attribute.toBuilder() : null;
        }

        public final void setAttribute(Attribute.BuilderImpl attribute) {
            Attribute oldValue = this.attribute;
            this.attribute = attribute != null ? attribute.build() : null;
            this.handleUnionValueChange(Type.ATTRIBUTE, oldValue, this.attribute);
        }

        @Override
        public final Builder attribute(Attribute attribute) {
            Attribute oldValue = this.attribute;
            this.attribute = attribute;
            this.handleUnionValueChange(Type.ATTRIBUTE, oldValue, this.attribute);
            return this;
        }

        public Node build() {
            return new Node(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Node> {
        public Builder branch(Branch var1);

        default public Builder branch(Consumer<Branch.Builder> branch) {
            return this.branch((Branch)((Branch.Builder)Branch.builder().applyMutation(branch)).build());
        }

        public Builder sensor(Sensor var1);

        default public Builder sensor(Consumer<Sensor.Builder> sensor) {
            return this.sensor((Sensor)((Sensor.Builder)Sensor.builder().applyMutation(sensor)).build());
        }

        public Builder actuator(Actuator var1);

        default public Builder actuator(Consumer<Actuator.Builder> actuator) {
            return this.actuator((Actuator)((Actuator.Builder)Actuator.builder().applyMutation(actuator)).build());
        }

        public Builder attribute(Attribute var1);

        default public Builder attribute(Consumer<Attribute.Builder> attribute) {
            return this.attribute((Attribute)((Attribute.Builder)Attribute.builder().applyMutation(attribute)).build());
        }
    }
}

