/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotfleetwise.model.NodeDataType;
import software.amazon.awssdk.services.iotfleetwise.model._listOfStringsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Actuator
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Actuator> {
    private static final SdkField<String> FULLY_QUALIFIED_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fullyQualifiedName").getter(Actuator.getter(Actuator::fullyQualifiedName)).setter(Actuator.setter(Builder::fullyQualifiedName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fullyQualifiedName").build()}).build();
    private static final SdkField<String> DATA_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataType").getter(Actuator.getter(Actuator::dataTypeAsString)).setter(Actuator.setter(Builder::dataType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataType").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(Actuator.getter(Actuator::description)).setter(Actuator.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("unit").getter(Actuator.getter(Actuator::unit)).setter(Actuator.setter(Builder::unit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unit").build()}).build();
    private static final SdkField<List<String>> ALLOWED_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("allowedValues").getter(Actuator.getter(Actuator::allowedValues)).setter(Actuator.setter(Builder::allowedValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Double> MIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("min").getter(Actuator.getter(Actuator::min)).setter(Actuator.setter(Builder::min)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("min").build()}).build();
    private static final SdkField<Double> MAX_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("max").getter(Actuator.getter(Actuator::max)).setter(Actuator.setter(Builder::max)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("max").build()}).build();
    private static final SdkField<String> ASSIGNED_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assignedValue").getter(Actuator.getter(Actuator::assignedValue)).setter(Actuator.setter(Builder::assignedValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assignedValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FULLY_QUALIFIED_NAME_FIELD, DATA_TYPE_FIELD, DESCRIPTION_FIELD, UNIT_FIELD, ALLOWED_VALUES_FIELD, MIN_FIELD, MAX_FIELD, ASSIGNED_VALUE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String fullyQualifiedName;
    private final String dataType;
    private final String description;
    private final String unit;
    private final List<String> allowedValues;
    private final Double min;
    private final Double max;
    private final String assignedValue;

    private Actuator(BuilderImpl builder) {
        this.fullyQualifiedName = builder.fullyQualifiedName;
        this.dataType = builder.dataType;
        this.description = builder.description;
        this.unit = builder.unit;
        this.allowedValues = builder.allowedValues;
        this.min = builder.min;
        this.max = builder.max;
        this.assignedValue = builder.assignedValue;
    }

    public final String fullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    public final NodeDataType dataType() {
        return NodeDataType.fromValue(this.dataType);
    }

    public final String dataTypeAsString() {
        return this.dataType;
    }

    public final String description() {
        return this.description;
    }

    public final String unit() {
        return this.unit;
    }

    public final boolean hasAllowedValues() {
        return this.allowedValues != null && !(this.allowedValues instanceof SdkAutoConstructList);
    }

    public final List<String> allowedValues() {
        return this.allowedValues;
    }

    public final Double min() {
        return this.min;
    }

    public final Double max() {
        return this.max;
    }

    public final String assignedValue() {
        return this.assignedValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fullyQualifiedName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.unit());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowedValues() ? this.allowedValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.min());
        hashCode = 31 * hashCode + Objects.hashCode(this.max());
        hashCode = 31 * hashCode + Objects.hashCode(this.assignedValue());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Actuator)) {
            return false;
        }
        Actuator other = (Actuator)obj;
        return Objects.equals(this.fullyQualifiedName(), other.fullyQualifiedName()) && Objects.equals(this.dataTypeAsString(), other.dataTypeAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.unit(), other.unit()) && this.hasAllowedValues() == other.hasAllowedValues() && Objects.equals(this.allowedValues(), other.allowedValues()) && Objects.equals(this.min(), other.min()) && Objects.equals(this.max(), other.max()) && Objects.equals(this.assignedValue(), other.assignedValue());
    }

    public final String toString() {
        return ToString.builder((String)"Actuator").add("FullyQualifiedName", (Object)this.fullyQualifiedName()).add("DataType", (Object)this.dataTypeAsString()).add("Description", (Object)this.description()).add("Unit", (Object)this.unit()).add("AllowedValues", this.hasAllowedValues() ? this.allowedValues() : null).add("Min", (Object)this.min()).add("Max", (Object)this.max()).add("AssignedValue", (Object)this.assignedValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "fullyQualifiedName": {
                return Optional.ofNullable(clazz.cast(this.fullyQualifiedName()));
            }
            case "dataType": {
                return Optional.ofNullable(clazz.cast(this.dataTypeAsString()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "unit": {
                return Optional.ofNullable(clazz.cast(this.unit()));
            }
            case "allowedValues": {
                return Optional.ofNullable(clazz.cast(this.allowedValues()));
            }
            case "min": {
                return Optional.ofNullable(clazz.cast(this.min()));
            }
            case "max": {
                return Optional.ofNullable(clazz.cast(this.max()));
            }
            case "assignedValue": {
                return Optional.ofNullable(clazz.cast(this.assignedValue()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Actuator, T> g) {
        return obj -> g.apply((Actuator)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String fullyQualifiedName;
        private String dataType;
        private String description;
        private String unit;
        private List<String> allowedValues = DefaultSdkAutoConstructList.getInstance();
        private Double min;
        private Double max;
        private String assignedValue;

        private BuilderImpl() {
        }

        private BuilderImpl(Actuator model) {
            this.fullyQualifiedName(model.fullyQualifiedName);
            this.dataType(model.dataType);
            this.description(model.description);
            this.unit(model.unit);
            this.allowedValues(model.allowedValues);
            this.min(model.min);
            this.max(model.max);
            this.assignedValue(model.assignedValue);
        }

        public final String getFullyQualifiedName() {
            return this.fullyQualifiedName;
        }

        public final void setFullyQualifiedName(String fullyQualifiedName) {
            this.fullyQualifiedName = fullyQualifiedName;
        }

        @Override
        public final Builder fullyQualifiedName(String fullyQualifiedName) {
            this.fullyQualifiedName = fullyQualifiedName;
            return this;
        }

        public final String getDataType() {
            return this.dataType;
        }

        public final void setDataType(String dataType) {
            this.dataType = dataType;
        }

        @Override
        public final Builder dataType(String dataType) {
            this.dataType = dataType;
            return this;
        }

        @Override
        public final Builder dataType(NodeDataType dataType) {
            this.dataType(dataType == null ? null : dataType.toString());
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getUnit() {
            return this.unit;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        public final Collection<String> getAllowedValues() {
            if (this.allowedValues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.allowedValues;
        }

        public final void setAllowedValues(Collection<String> allowedValues) {
            this.allowedValues = _listOfStringsCopier.copy(allowedValues);
        }

        @Override
        public final Builder allowedValues(Collection<String> allowedValues) {
            this.allowedValues = _listOfStringsCopier.copy(allowedValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedValues(String ... allowedValues) {
            this.allowedValues(Arrays.asList(allowedValues));
            return this;
        }

        public final Double getMin() {
            return this.min;
        }

        public final void setMin(Double min) {
            this.min = min;
        }

        @Override
        public final Builder min(Double min) {
            this.min = min;
            return this;
        }

        public final Double getMax() {
            return this.max;
        }

        public final void setMax(Double max) {
            this.max = max;
        }

        @Override
        public final Builder max(Double max) {
            this.max = max;
            return this;
        }

        public final String getAssignedValue() {
            return this.assignedValue;
        }

        public final void setAssignedValue(String assignedValue) {
            this.assignedValue = assignedValue;
        }

        @Override
        public final Builder assignedValue(String assignedValue) {
            this.assignedValue = assignedValue;
            return this;
        }

        public Actuator build() {
            return new Actuator(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Actuator> {
        public Builder fullyQualifiedName(String var1);

        public Builder dataType(String var1);

        public Builder dataType(NodeDataType var1);

        public Builder description(String var1);

        public Builder unit(String var1);

        public Builder allowedValues(Collection<String> var1);

        public Builder allowedValues(String ... var1);

        public Builder min(Double var1);

        public Builder max(Double var1);

        public Builder assignedValue(String var1);
    }
}

