/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleetwise.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotfleetwise.IoTFleetWiseClient;
import software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesInFleetRequest;
import software.amazon.awssdk.services.iotfleetwise.model.ListVehiclesInFleetResponse;

public class ListVehiclesInFleetIterable
implements SdkIterable<ListVehiclesInFleetResponse> {
    private final IoTFleetWiseClient client;
    private final ListVehiclesInFleetRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListVehiclesInFleetIterable(IoTFleetWiseClient client, ListVehiclesInFleetRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListVehiclesInFleetResponseFetcher();
    }

    public Iterator<ListVehiclesInFleetResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<String> vehicles() {
        Function<ListVehiclesInFleetResponse, Iterator> getIterator = response -> {
            if (response != null && response.vehicles() != null) {
                return response.vehicles().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListVehiclesInFleetResponseFetcher
    implements SyncPageFetcher<ListVehiclesInFleetResponse> {
        private ListVehiclesInFleetResponseFetcher() {
        }

        public boolean hasNextPage(ListVehiclesInFleetResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListVehiclesInFleetResponse nextPage(ListVehiclesInFleetResponse previousPage) {
            if (previousPage == null) {
                return ListVehiclesInFleetIterable.this.client.listVehiclesInFleet(ListVehiclesInFleetIterable.this.firstRequest);
            }
            return ListVehiclesInFleetIterable.this.client.listVehiclesInFleet((ListVehiclesInFleetRequest)((Object)ListVehiclesInFleetIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

