/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleethub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotfleethub.model.ApplicationSummariesCopier;
import software.amazon.awssdk.services.iotfleethub.model.ApplicationSummary;
import software.amazon.awssdk.services.iotfleethub.model.IoTFleetHubResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListApplicationsResponse
extends IoTFleetHubResponse
implements ToCopyableBuilder<Builder, ListApplicationsResponse> {
    private static final SdkField<List<ApplicationSummary>> APPLICATION_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("applicationSummaries").getter(ListApplicationsResponse.getter(ListApplicationsResponse::applicationSummaries)).setter(ListApplicationsResponse.setter(Builder::applicationSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ApplicationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListApplicationsResponse.getter(ListApplicationsResponse::nextToken)).setter(ListApplicationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<ApplicationSummary> applicationSummaries;
    private final String nextToken;

    private ListApplicationsResponse(BuilderImpl builder) {
        super(builder);
        this.applicationSummaries = builder.applicationSummaries;
        this.nextToken = builder.nextToken;
    }

    public boolean hasApplicationSummaries() {
        return this.applicationSummaries != null && !(this.applicationSummaries instanceof SdkAutoConstructList);
    }

    public List<ApplicationSummary> applicationSummaries() {
        return this.applicationSummaries;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasApplicationSummaries() ? this.applicationSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListApplicationsResponse)) {
            return false;
        }
        ListApplicationsResponse other = (ListApplicationsResponse)((Object)obj);
        return this.hasApplicationSummaries() == other.hasApplicationSummaries() && Objects.equals(this.applicationSummaries(), other.applicationSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListApplicationsResponse").add("ApplicationSummaries", this.hasApplicationSummaries() ? this.applicationSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationSummaries": {
                return Optional.ofNullable(clazz.cast(this.applicationSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListApplicationsResponse, T> g) {
        return obj -> g.apply((ListApplicationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTFleetHubResponse.BuilderImpl
    implements Builder {
        private List<ApplicationSummary> applicationSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListApplicationsResponse model) {
            super(model);
            this.applicationSummaries(model.applicationSummaries);
            this.nextToken(model.nextToken);
        }

        public final Collection<ApplicationSummary.Builder> getApplicationSummaries() {
            if (this.applicationSummaries instanceof SdkAutoConstructList) {
                return null;
            }
            return this.applicationSummaries != null ? (Collection)this.applicationSummaries.stream().map(ApplicationSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder applicationSummaries(Collection<ApplicationSummary> applicationSummaries) {
            this.applicationSummaries = ApplicationSummariesCopier.copy(applicationSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationSummaries(ApplicationSummary ... applicationSummaries) {
            this.applicationSummaries(Arrays.asList(applicationSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationSummaries(Consumer<ApplicationSummary.Builder> ... applicationSummaries) {
            this.applicationSummaries(Stream.of(applicationSummaries).map(c -> (ApplicationSummary)((ApplicationSummary.Builder)ApplicationSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setApplicationSummaries(Collection<ApplicationSummary.BuilderImpl> applicationSummaries) {
            this.applicationSummaries = ApplicationSummariesCopier.copyFromBuilder(applicationSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListApplicationsResponse build() {
            return new ListApplicationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTFleetHubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListApplicationsResponse> {
        public Builder applicationSummaries(Collection<ApplicationSummary> var1);

        public Builder applicationSummaries(ApplicationSummary ... var1);

        public Builder applicationSummaries(Consumer<ApplicationSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

