/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotfleethub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iotfleethub.model.ApplicationState;
import software.amazon.awssdk.services.iotfleethub.model.IoTFleetHubResponse;
import software.amazon.awssdk.services.iotfleethub.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeApplicationResponse
extends IoTFleetHubResponse
implements ToCopyableBuilder<Builder, DescribeApplicationResponse> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationId").getter(DescribeApplicationResponse.getter(DescribeApplicationResponse::applicationId)).setter(DescribeApplicationResponse.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationId").build()}).build();
    private static final SdkField<String> APPLICATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationArn").getter(DescribeApplicationResponse.getter(DescribeApplicationResponse::applicationArn)).setter(DescribeApplicationResponse.setter(Builder::applicationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationArn").build()}).build();
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationName").getter(DescribeApplicationResponse.getter(DescribeApplicationResponse::applicationName)).setter(DescribeApplicationResponse.setter(Builder::applicationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationName").build()}).build();
    private static final SdkField<String> APPLICATION_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationDescription").getter(DescribeApplicationResponse.getter(DescribeApplicationResponse::applicationDescription)).setter(DescribeApplicationResponse.setter(Builder::applicationDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationDescription").build()}).build();
    private static final SdkField<String> APPLICATION_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationUrl").getter(DescribeApplicationResponse.getter(DescribeApplicationResponse::applicationUrl)).setter(DescribeApplicationResponse.setter(Builder::applicationUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationUrl").build()}).build();
    private static final SdkField<String> APPLICATION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationState").getter(DescribeApplicationResponse.getter(DescribeApplicationResponse::applicationStateAsString)).setter(DescribeApplicationResponse.setter(Builder::applicationState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationState").build()}).build();
    private static final SdkField<Long> APPLICATION_CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("applicationCreationDate").getter(DescribeApplicationResponse.getter(DescribeApplicationResponse::applicationCreationDate)).setter(DescribeApplicationResponse.setter(Builder::applicationCreationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationCreationDate").build()}).build();
    private static final SdkField<Long> APPLICATION_LAST_UPDATE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("applicationLastUpdateDate").getter(DescribeApplicationResponse.getter(DescribeApplicationResponse::applicationLastUpdateDate)).setter(DescribeApplicationResponse.setter(Builder::applicationLastUpdateDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationLastUpdateDate").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(DescribeApplicationResponse.getter(DescribeApplicationResponse::roleArn)).setter(DescribeApplicationResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<String> SSO_CLIENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ssoClientId").getter(DescribeApplicationResponse.getter(DescribeApplicationResponse::ssoClientId)).setter(DescribeApplicationResponse.setter(Builder::ssoClientId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ssoClientId").build()}).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("errorMessage").getter(DescribeApplicationResponse.getter(DescribeApplicationResponse::errorMessage)).setter(DescribeApplicationResponse.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(DescribeApplicationResponse.getter(DescribeApplicationResponse::tags)).setter(DescribeApplicationResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, APPLICATION_ARN_FIELD, APPLICATION_NAME_FIELD, APPLICATION_DESCRIPTION_FIELD, APPLICATION_URL_FIELD, APPLICATION_STATE_FIELD, APPLICATION_CREATION_DATE_FIELD, APPLICATION_LAST_UPDATE_DATE_FIELD, ROLE_ARN_FIELD, SSO_CLIENT_ID_FIELD, ERROR_MESSAGE_FIELD, TAGS_FIELD));
    private final String applicationId;
    private final String applicationArn;
    private final String applicationName;
    private final String applicationDescription;
    private final String applicationUrl;
    private final String applicationState;
    private final Long applicationCreationDate;
    private final Long applicationLastUpdateDate;
    private final String roleArn;
    private final String ssoClientId;
    private final String errorMessage;
    private final Map<String, String> tags;

    private DescribeApplicationResponse(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.applicationArn = builder.applicationArn;
        this.applicationName = builder.applicationName;
        this.applicationDescription = builder.applicationDescription;
        this.applicationUrl = builder.applicationUrl;
        this.applicationState = builder.applicationState;
        this.applicationCreationDate = builder.applicationCreationDate;
        this.applicationLastUpdateDate = builder.applicationLastUpdateDate;
        this.roleArn = builder.roleArn;
        this.ssoClientId = builder.ssoClientId;
        this.errorMessage = builder.errorMessage;
        this.tags = builder.tags;
    }

    public String applicationId() {
        return this.applicationId;
    }

    public String applicationArn() {
        return this.applicationArn;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public String applicationDescription() {
        return this.applicationDescription;
    }

    public String applicationUrl() {
        return this.applicationUrl;
    }

    public ApplicationState applicationState() {
        return ApplicationState.fromValue(this.applicationState);
    }

    public String applicationStateAsString() {
        return this.applicationState;
    }

    public Long applicationCreationDate() {
        return this.applicationCreationDate;
    }

    public Long applicationLastUpdateDate() {
        return this.applicationLastUpdateDate;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public String ssoClientId() {
        return this.ssoClientId;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationCreationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationLastUpdateDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.ssoClientId());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeApplicationResponse)) {
            return false;
        }
        DescribeApplicationResponse other = (DescribeApplicationResponse)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.applicationArn(), other.applicationArn()) && Objects.equals(this.applicationName(), other.applicationName()) && Objects.equals(this.applicationDescription(), other.applicationDescription()) && Objects.equals(this.applicationUrl(), other.applicationUrl()) && Objects.equals(this.applicationStateAsString(), other.applicationStateAsString()) && Objects.equals(this.applicationCreationDate(), other.applicationCreationDate()) && Objects.equals(this.applicationLastUpdateDate(), other.applicationLastUpdateDate()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.ssoClientId(), other.ssoClientId()) && Objects.equals(this.errorMessage(), other.errorMessage()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"DescribeApplicationResponse").add("ApplicationId", (Object)this.applicationId()).add("ApplicationArn", (Object)this.applicationArn()).add("ApplicationName", (Object)this.applicationName()).add("ApplicationDescription", (Object)this.applicationDescription()).add("ApplicationUrl", (Object)this.applicationUrl()).add("ApplicationState", (Object)this.applicationStateAsString()).add("ApplicationCreationDate", (Object)this.applicationCreationDate()).add("ApplicationLastUpdateDate", (Object)this.applicationLastUpdateDate()).add("RoleArn", (Object)this.roleArn()).add("SsoClientId", (Object)this.ssoClientId()).add("ErrorMessage", (Object)this.errorMessage()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "applicationArn": {
                return Optional.ofNullable(clazz.cast(this.applicationArn()));
            }
            case "applicationName": {
                return Optional.ofNullable(clazz.cast(this.applicationName()));
            }
            case "applicationDescription": {
                return Optional.ofNullable(clazz.cast(this.applicationDescription()));
            }
            case "applicationUrl": {
                return Optional.ofNullable(clazz.cast(this.applicationUrl()));
            }
            case "applicationState": {
                return Optional.ofNullable(clazz.cast(this.applicationStateAsString()));
            }
            case "applicationCreationDate": {
                return Optional.ofNullable(clazz.cast(this.applicationCreationDate()));
            }
            case "applicationLastUpdateDate": {
                return Optional.ofNullable(clazz.cast(this.applicationLastUpdateDate()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "ssoClientId": {
                return Optional.ofNullable(clazz.cast(this.ssoClientId()));
            }
            case "errorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeApplicationResponse, T> g) {
        return obj -> g.apply((DescribeApplicationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTFleetHubResponse.BuilderImpl
    implements Builder {
        private String applicationId;
        private String applicationArn;
        private String applicationName;
        private String applicationDescription;
        private String applicationUrl;
        private String applicationState;
        private Long applicationCreationDate;
        private Long applicationLastUpdateDate;
        private String roleArn;
        private String ssoClientId;
        private String errorMessage;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeApplicationResponse model) {
            super(model);
            this.applicationId(model.applicationId);
            this.applicationArn(model.applicationArn);
            this.applicationName(model.applicationName);
            this.applicationDescription(model.applicationDescription);
            this.applicationUrl(model.applicationUrl);
            this.applicationState(model.applicationState);
            this.applicationCreationDate(model.applicationCreationDate);
            this.applicationLastUpdateDate(model.applicationLastUpdateDate);
            this.roleArn(model.roleArn);
            this.ssoClientId(model.ssoClientId);
            this.errorMessage(model.errorMessage);
            this.tags(model.tags);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final String getApplicationArn() {
            return this.applicationArn;
        }

        @Override
        public final Builder applicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
            return this;
        }

        public final void setApplicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getApplicationDescription() {
            return this.applicationDescription;
        }

        @Override
        public final Builder applicationDescription(String applicationDescription) {
            this.applicationDescription = applicationDescription;
            return this;
        }

        public final void setApplicationDescription(String applicationDescription) {
            this.applicationDescription = applicationDescription;
        }

        public final String getApplicationUrl() {
            return this.applicationUrl;
        }

        @Override
        public final Builder applicationUrl(String applicationUrl) {
            this.applicationUrl = applicationUrl;
            return this;
        }

        public final void setApplicationUrl(String applicationUrl) {
            this.applicationUrl = applicationUrl;
        }

        public final String getApplicationState() {
            return this.applicationState;
        }

        @Override
        public final Builder applicationState(String applicationState) {
            this.applicationState = applicationState;
            return this;
        }

        @Override
        public final Builder applicationState(ApplicationState applicationState) {
            this.applicationState(applicationState == null ? null : applicationState.toString());
            return this;
        }

        public final void setApplicationState(String applicationState) {
            this.applicationState = applicationState;
        }

        public final Long getApplicationCreationDate() {
            return this.applicationCreationDate;
        }

        @Override
        public final Builder applicationCreationDate(Long applicationCreationDate) {
            this.applicationCreationDate = applicationCreationDate;
            return this;
        }

        public final void setApplicationCreationDate(Long applicationCreationDate) {
            this.applicationCreationDate = applicationCreationDate;
        }

        public final Long getApplicationLastUpdateDate() {
            return this.applicationLastUpdateDate;
        }

        @Override
        public final Builder applicationLastUpdateDate(Long applicationLastUpdateDate) {
            this.applicationLastUpdateDate = applicationLastUpdateDate;
            return this;
        }

        public final void setApplicationLastUpdateDate(Long applicationLastUpdateDate) {
            this.applicationLastUpdateDate = applicationLastUpdateDate;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getSsoClientId() {
            return this.ssoClientId;
        }

        @Override
        public final Builder ssoClientId(String ssoClientId) {
            this.ssoClientId = ssoClientId;
            return this;
        }

        public final void setSsoClientId(String ssoClientId) {
            this.ssoClientId = ssoClientId;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public DescribeApplicationResponse build() {
            return new DescribeApplicationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTFleetHubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeApplicationResponse> {
        public Builder applicationId(String var1);

        public Builder applicationArn(String var1);

        public Builder applicationName(String var1);

        public Builder applicationDescription(String var1);

        public Builder applicationUrl(String var1);

        public Builder applicationState(String var1);

        public Builder applicationState(ApplicationState var1);

        public Builder applicationCreationDate(Long var1);

        public Builder applicationLastUpdateDate(Long var1);

        public Builder roleArn(String var1);

        public Builder ssoClientId(String var1);

        public Builder errorMessage(String var1);

        public Builder tags(Map<String, String> var1);
    }
}

