/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ioteventsdata.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Timer
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Timer> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Timer.getter(Timer::name)).setter(Timer.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(Timer.getter(Timer::timestamp)).setter(Timer.setter(Builder::timestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TIMESTAMP_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final Instant timestamp;

    private Timer(BuilderImpl builder) {
        this.name = builder.name;
        this.timestamp = builder.timestamp;
    }

    public String name() {
        return this.name;
    }

    public Instant timestamp() {
        return this.timestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Timer)) {
            return false;
        }
        Timer other = (Timer)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.timestamp(), other.timestamp());
    }

    public String toString() {
        return ToString.builder((String)"Timer").add("Name", (Object)this.name()).add("Timestamp", (Object)this.timestamp()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Timer, T> g) {
        return obj -> g.apply((Timer)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private Instant timestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(Timer model) {
            this.name(model.name);
            this.timestamp(model.timestamp);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        public Timer build() {
            return new Timer(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Timer> {
        public Builder name(String var1);

        public Builder timestamp(Instant var1);
    }
}

