/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ioteventsdata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ioteventsdata.model.Timer;
import software.amazon.awssdk.services.ioteventsdata.model.TimersCopier;
import software.amazon.awssdk.services.ioteventsdata.model.Variable;
import software.amazon.awssdk.services.ioteventsdata.model.VariablesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DetectorState
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DetectorState> {
    private static final SdkField<String> STATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DetectorState.getter(DetectorState::stateName)).setter(DetectorState.setter(Builder::stateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateName").build()}).build();
    private static final SdkField<List<Variable>> VARIABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DetectorState.getter(DetectorState::variables)).setter(DetectorState.setter(Builder::variables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("variables").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Variable::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Timer>> TIMERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DetectorState.getter(DetectorState::timers)).setter(DetectorState.setter(Builder::timers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Timer::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_NAME_FIELD, VARIABLES_FIELD, TIMERS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String stateName;
    private final List<Variable> variables;
    private final List<Timer> timers;

    private DetectorState(BuilderImpl builder) {
        this.stateName = builder.stateName;
        this.variables = builder.variables;
        this.timers = builder.timers;
    }

    public String stateName() {
        return this.stateName;
    }

    public List<Variable> variables() {
        return this.variables;
    }

    public List<Timer> timers() {
        return this.timers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.variables());
        hashCode = 31 * hashCode + Objects.hashCode(this.timers());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectorState)) {
            return false;
        }
        DetectorState other = (DetectorState)obj;
        return Objects.equals(this.stateName(), other.stateName()) && Objects.equals(this.variables(), other.variables()) && Objects.equals(this.timers(), other.timers());
    }

    public String toString() {
        return ToString.builder((String)"DetectorState").add("StateName", (Object)this.stateName()).add("Variables", this.variables()).add("Timers", this.timers()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "stateName": {
                return Optional.ofNullable(clazz.cast(this.stateName()));
            }
            case "variables": {
                return Optional.ofNullable(clazz.cast(this.variables()));
            }
            case "timers": {
                return Optional.ofNullable(clazz.cast(this.timers()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DetectorState, T> g) {
        return obj -> g.apply((DetectorState)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String stateName;
        private List<Variable> variables = DefaultSdkAutoConstructList.getInstance();
        private List<Timer> timers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DetectorState model) {
            this.stateName(model.stateName);
            this.variables(model.variables);
            this.timers(model.timers);
        }

        public final String getStateName() {
            return this.stateName;
        }

        @Override
        public final Builder stateName(String stateName) {
            this.stateName = stateName;
            return this;
        }

        public final void setStateName(String stateName) {
            this.stateName = stateName;
        }

        public final Collection<Variable.Builder> getVariables() {
            return this.variables != null ? (Collection)this.variables.stream().map(Variable::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder variables(Collection<Variable> variables) {
            this.variables = VariablesCopier.copy(variables);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder variables(Variable ... variables) {
            this.variables(Arrays.asList(variables));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder variables(Consumer<Variable.Builder> ... variables) {
            this.variables(Stream.of(variables).map(c -> (Variable)((Variable.Builder)Variable.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setVariables(Collection<Variable.BuilderImpl> variables) {
            this.variables = VariablesCopier.copyFromBuilder(variables);
        }

        public final Collection<Timer.Builder> getTimers() {
            return this.timers != null ? (Collection)this.timers.stream().map(Timer::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder timers(Collection<Timer> timers) {
            this.timers = TimersCopier.copy(timers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder timers(Timer ... timers) {
            this.timers(Arrays.asList(timers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder timers(Consumer<Timer.Builder> ... timers) {
            this.timers(Stream.of(timers).map(c -> (Timer)((Timer.Builder)Timer.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTimers(Collection<Timer.BuilderImpl> timers) {
            this.timers = TimersCopier.copyFromBuilder(timers);
        }

        public DetectorState build() {
            return new DetectorState(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DetectorState> {
        public Builder stateName(String var1);

        public Builder variables(Collection<Variable> var1);

        public Builder variables(Variable ... var1);

        public Builder variables(Consumer<Variable.Builder> ... var1);

        public Builder timers(Collection<Timer> var1);

        public Builder timers(Timer ... var1);

        public Builder timers(Consumer<Timer.Builder> ... var1);
    }
}

