/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotdeviceadvisor.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotdeviceadvisor.IotDeviceAdvisorClient;
import software.amazon.awssdk.services.iotdeviceadvisor.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotdeviceadvisor.model.ListSuiteDefinitionsRequest;
import software.amazon.awssdk.services.iotdeviceadvisor.model.ListSuiteDefinitionsResponse;

public class ListSuiteDefinitionsIterable
implements SdkIterable<ListSuiteDefinitionsResponse> {
    private final IotDeviceAdvisorClient client;
    private final ListSuiteDefinitionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSuiteDefinitionsIterable(IotDeviceAdvisorClient client, ListSuiteDefinitionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSuiteDefinitionsResponseFetcher();
    }

    public Iterator<ListSuiteDefinitionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListSuiteDefinitionsResponseFetcher
    implements SyncPageFetcher<ListSuiteDefinitionsResponse> {
        private ListSuiteDefinitionsResponseFetcher() {
        }

        public boolean hasNextPage(ListSuiteDefinitionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSuiteDefinitionsResponse nextPage(ListSuiteDefinitionsResponse previousPage) {
            if (previousPage == null) {
                return ListSuiteDefinitionsIterable.this.client.listSuiteDefinitions(ListSuiteDefinitionsIterable.this.firstRequest);
            }
            return ListSuiteDefinitionsIterable.this.client.listSuiteDefinitions((ListSuiteDefinitionsRequest)((Object)ListSuiteDefinitionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

