/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotdeviceadvisor.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotdeviceadvisor.IotDeviceAdvisorAsyncClient;
import software.amazon.awssdk.services.iotdeviceadvisor.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotdeviceadvisor.model.ListSuiteRunsRequest;
import software.amazon.awssdk.services.iotdeviceadvisor.model.ListSuiteRunsResponse;

public class ListSuiteRunsPublisher
implements SdkPublisher<ListSuiteRunsResponse> {
    private final IotDeviceAdvisorAsyncClient client;
    private final ListSuiteRunsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSuiteRunsPublisher(IotDeviceAdvisorAsyncClient client, ListSuiteRunsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSuiteRunsPublisher(IotDeviceAdvisorAsyncClient client, ListSuiteRunsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSuiteRunsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSuiteRunsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListSuiteRunsResponseFetcher
    implements AsyncPageFetcher<ListSuiteRunsResponse> {
        private ListSuiteRunsResponseFetcher() {
        }

        public boolean hasNextPage(ListSuiteRunsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSuiteRunsResponse> nextPage(ListSuiteRunsResponse previousPage) {
            if (previousPage == null) {
                return ListSuiteRunsPublisher.this.client.listSuiteRuns(ListSuiteRunsPublisher.this.firstRequest);
            }
            return ListSuiteRunsPublisher.this.client.listSuiteRuns((ListSuiteRunsRequest)((Object)ListSuiteRunsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

