/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotdeviceadvisor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides test case definition.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TestCaseDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<TestCaseDefinition.Builder, TestCaseDefinition> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(TestCaseDefinition::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> TEST_CASE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("testCaseVersion").getter(getter(TestCaseDefinition::testCaseVersion))
            .setter(setter(Builder::testCaseVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testCaseVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD,
            TEST_CASE_VERSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String testCaseVersion;

    private TestCaseDefinition(BuilderImpl builder) {
        this.id = builder.id;
        this.testCaseVersion = builder.testCaseVersion;
    }

    /**
     * <p>
     * Provides test case definition Id.
     * </p>
     * 
     * @return Provides test case definition Id.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * Provides test case definition version.
     * </p>
     * 
     * @return Provides test case definition version.
     */
    public final String testCaseVersion() {
        return testCaseVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(testCaseVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestCaseDefinition)) {
            return false;
        }
        TestCaseDefinition other = (TestCaseDefinition) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(testCaseVersion(), other.testCaseVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TestCaseDefinition").add("Id", id()).add("TestCaseVersion", testCaseVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "testCaseVersion":
            return Optional.ofNullable(clazz.cast(testCaseVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TestCaseDefinition, T> g) {
        return obj -> g.apply((TestCaseDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TestCaseDefinition> {
        /**
         * <p>
         * Provides test case definition Id.
         * </p>
         * 
         * @param id
         *        Provides test case definition Id.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * Provides test case definition version.
         * </p>
         * 
         * @param testCaseVersion
         *        Provides test case definition version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testCaseVersion(String testCaseVersion);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String testCaseVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(TestCaseDefinition model) {
            id(model.id);
            testCaseVersion(model.testCaseVersion);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getTestCaseVersion() {
            return testCaseVersion;
        }

        @Override
        public final Builder testCaseVersion(String testCaseVersion) {
            this.testCaseVersion = testCaseVersion;
            return this;
        }

        public final void setTestCaseVersion(String testCaseVersion) {
            this.testCaseVersion = testCaseVersion;
        }

        @Override
        public TestCaseDefinition build() {
            return new TestCaseDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
