/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotdeviceadvisor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Gets the test case category.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TestCaseCategory implements SdkPojo, Serializable,
        ToCopyableBuilder<TestCaseCategory.Builder, TestCaseCategory> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(TestCaseCategory::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<List<TestCase>> TESTS_FIELD = SdkField
            .<List<TestCase>> builder(MarshallingType.LIST)
            .memberName("tests")
            .getter(getter(TestCaseCategory::tests))
            .setter(setter(Builder::tests))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tests").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TestCase> builder(MarshallingType.SDK_POJO)
                                            .constructor(TestCase::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TESTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final List<TestCase> tests;

    private TestCaseCategory(BuilderImpl builder) {
        this.name = builder.name;
        this.tests = builder.tests;
    }

    /**
     * <p>
     * Lists all the tests name in the specified category.
     * </p>
     * 
     * @return Lists all the tests name in the specified category.
     */
    public final String name() {
        return name;
    }

    /**
     * Returns true if the Tests property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTests() {
        return tests != null && !(tests instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Lists all the tests in the specified category.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTests()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Lists all the tests in the specified category.
     */
    public final List<TestCase> tests() {
        return tests;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasTests() ? tests() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestCaseCategory)) {
            return false;
        }
        TestCaseCategory other = (TestCaseCategory) obj;
        return Objects.equals(name(), other.name()) && hasTests() == other.hasTests() && Objects.equals(tests(), other.tests());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TestCaseCategory").add("Name", name()).add("Tests", hasTests() ? tests() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "tests":
            return Optional.ofNullable(clazz.cast(tests()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TestCaseCategory, T> g) {
        return obj -> g.apply((TestCaseCategory) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TestCaseCategory> {
        /**
         * <p>
         * Lists all the tests name in the specified category.
         * </p>
         * 
         * @param name
         *        Lists all the tests name in the specified category.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Lists all the tests in the specified category.
         * </p>
         * 
         * @param tests
         *        Lists all the tests in the specified category.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tests(Collection<TestCase> tests);

        /**
         * <p>
         * Lists all the tests in the specified category.
         * </p>
         * 
         * @param tests
         *        Lists all the tests in the specified category.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tests(TestCase... tests);

        /**
         * <p>
         * Lists all the tests in the specified category.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TestCase>.Builder} avoiding the need to
         * create one manually via {@link List<TestCase>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TestCase>.Builder#build()} is called immediately and its
         * result is passed to {@link #tests(List<TestCase>)}.
         * 
         * @param tests
         *        a consumer that will call methods on {@link List<TestCase>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tests(List<TestCase>)
         */
        Builder tests(Consumer<TestCase.Builder>... tests);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private List<TestCase> tests = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TestCaseCategory model) {
            name(model.name);
            tests(model.tests);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<TestCase.Builder> getTests() {
            if (tests instanceof SdkAutoConstructList) {
                return null;
            }
            return tests != null ? tests.stream().map(TestCase::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tests(Collection<TestCase> tests) {
            this.tests = TestCaseListCopier.copy(tests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tests(TestCase... tests) {
            tests(Arrays.asList(tests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tests(Consumer<TestCase.Builder>... tests) {
            tests(Stream.of(tests).map(c -> TestCase.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTests(Collection<TestCase.BuilderImpl> tests) {
            this.tests = TestCaseListCopier.copyFromBuilder(tests);
        }

        @Override
        public TestCaseCategory build() {
            return new TestCaseCategory(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
