/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotdeviceadvisor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Gets Suite Definition Configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SuiteDefinitionConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SuiteDefinitionConfiguration.Builder, SuiteDefinitionConfiguration> {
    private static final SdkField<String> SUITE_DEFINITION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("suiteDefinitionName").getter(getter(SuiteDefinitionConfiguration::suiteDefinitionName))
            .setter(setter(Builder::suiteDefinitionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suiteDefinitionName").build())
            .build();

    private static final SdkField<List<DeviceUnderTest>> DEVICES_FIELD = SdkField
            .<List<DeviceUnderTest>> builder(MarshallingType.LIST)
            .memberName("devices")
            .getter(getter(SuiteDefinitionConfiguration::devices))
            .setter(setter(Builder::devices))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("devices").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DeviceUnderTest> builder(MarshallingType.SDK_POJO)
                                            .constructor(DeviceUnderTest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> INTENDED_FOR_QUALIFICATION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("intendedForQualification").getter(getter(SuiteDefinitionConfiguration::intendedForQualification))
            .setter(setter(Builder::intendedForQualification))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intendedForQualification").build())
            .build();

    private static final SdkField<String> ROOT_GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("rootGroup").getter(getter(SuiteDefinitionConfiguration::rootGroup)).setter(setter(Builder::rootGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rootGroup").build()).build();

    private static final SdkField<String> DEVICE_PERMISSION_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("devicePermissionRoleArn").getter(getter(SuiteDefinitionConfiguration::devicePermissionRoleArn))
            .setter(setter(Builder::devicePermissionRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("devicePermissionRoleArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUITE_DEFINITION_NAME_FIELD,
            DEVICES_FIELD, INTENDED_FOR_QUALIFICATION_FIELD, ROOT_GROUP_FIELD, DEVICE_PERMISSION_ROLE_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String suiteDefinitionName;

    private final List<DeviceUnderTest> devices;

    private final Boolean intendedForQualification;

    private final String rootGroup;

    private final String devicePermissionRoleArn;

    private SuiteDefinitionConfiguration(BuilderImpl builder) {
        this.suiteDefinitionName = builder.suiteDefinitionName;
        this.devices = builder.devices;
        this.intendedForQualification = builder.intendedForQualification;
        this.rootGroup = builder.rootGroup;
        this.devicePermissionRoleArn = builder.devicePermissionRoleArn;
    }

    /**
     * <p>
     * Gets Suite Definition Configuration name.
     * </p>
     * 
     * @return Gets Suite Definition Configuration name.
     */
    public final String suiteDefinitionName() {
        return suiteDefinitionName;
    }

    /**
     * Returns true if the Devices property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasDevices() {
        return devices != null && !(devices instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Gets the devices configured.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDevices()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Gets the devices configured.
     */
    public final List<DeviceUnderTest> devices() {
        return devices;
    }

    /**
     * <p>
     * Gets the tests intended for qualification in a suite.
     * </p>
     * 
     * @return Gets the tests intended for qualification in a suite.
     */
    public final Boolean intendedForQualification() {
        return intendedForQualification;
    }

    /**
     * <p>
     * Gets test suite root group.
     * </p>
     * 
     * @return Gets test suite root group.
     */
    public final String rootGroup() {
        return rootGroup;
    }

    /**
     * <p>
     * Gets device permission arn.
     * </p>
     * 
     * @return Gets device permission arn.
     */
    public final String devicePermissionRoleArn() {
        return devicePermissionRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(suiteDefinitionName());
        hashCode = 31 * hashCode + Objects.hashCode(hasDevices() ? devices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(intendedForQualification());
        hashCode = 31 * hashCode + Objects.hashCode(rootGroup());
        hashCode = 31 * hashCode + Objects.hashCode(devicePermissionRoleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SuiteDefinitionConfiguration)) {
            return false;
        }
        SuiteDefinitionConfiguration other = (SuiteDefinitionConfiguration) obj;
        return Objects.equals(suiteDefinitionName(), other.suiteDefinitionName()) && hasDevices() == other.hasDevices()
                && Objects.equals(devices(), other.devices())
                && Objects.equals(intendedForQualification(), other.intendedForQualification())
                && Objects.equals(rootGroup(), other.rootGroup())
                && Objects.equals(devicePermissionRoleArn(), other.devicePermissionRoleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SuiteDefinitionConfiguration").add("SuiteDefinitionName", suiteDefinitionName())
                .add("Devices", hasDevices() ? devices() : null).add("IntendedForQualification", intendedForQualification())
                .add("RootGroup", rootGroup()).add("DevicePermissionRoleArn", devicePermissionRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "suiteDefinitionName":
            return Optional.ofNullable(clazz.cast(suiteDefinitionName()));
        case "devices":
            return Optional.ofNullable(clazz.cast(devices()));
        case "intendedForQualification":
            return Optional.ofNullable(clazz.cast(intendedForQualification()));
        case "rootGroup":
            return Optional.ofNullable(clazz.cast(rootGroup()));
        case "devicePermissionRoleArn":
            return Optional.ofNullable(clazz.cast(devicePermissionRoleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SuiteDefinitionConfiguration, T> g) {
        return obj -> g.apply((SuiteDefinitionConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SuiteDefinitionConfiguration> {
        /**
         * <p>
         * Gets Suite Definition Configuration name.
         * </p>
         * 
         * @param suiteDefinitionName
         *        Gets Suite Definition Configuration name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suiteDefinitionName(String suiteDefinitionName);

        /**
         * <p>
         * Gets the devices configured.
         * </p>
         * 
         * @param devices
         *        Gets the devices configured.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder devices(Collection<DeviceUnderTest> devices);

        /**
         * <p>
         * Gets the devices configured.
         * </p>
         * 
         * @param devices
         *        Gets the devices configured.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder devices(DeviceUnderTest... devices);

        /**
         * <p>
         * Gets the devices configured.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DeviceUnderTest>.Builder} avoiding the need
         * to create one manually via {@link List<DeviceUnderTest>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DeviceUnderTest>.Builder#build()} is called immediately and
         * its result is passed to {@link #devices(List<DeviceUnderTest>)}.
         * 
         * @param devices
         *        a consumer that will call methods on {@link List<DeviceUnderTest>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #devices(List<DeviceUnderTest>)
         */
        Builder devices(Consumer<DeviceUnderTest.Builder>... devices);

        /**
         * <p>
         * Gets the tests intended for qualification in a suite.
         * </p>
         * 
         * @param intendedForQualification
         *        Gets the tests intended for qualification in a suite.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intendedForQualification(Boolean intendedForQualification);

        /**
         * <p>
         * Gets test suite root group.
         * </p>
         * 
         * @param rootGroup
         *        Gets test suite root group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rootGroup(String rootGroup);

        /**
         * <p>
         * Gets device permission arn.
         * </p>
         * 
         * @param devicePermissionRoleArn
         *        Gets device permission arn.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder devicePermissionRoleArn(String devicePermissionRoleArn);
    }

    static final class BuilderImpl implements Builder {
        private String suiteDefinitionName;

        private List<DeviceUnderTest> devices = DefaultSdkAutoConstructList.getInstance();

        private Boolean intendedForQualification;

        private String rootGroup;

        private String devicePermissionRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(SuiteDefinitionConfiguration model) {
            suiteDefinitionName(model.suiteDefinitionName);
            devices(model.devices);
            intendedForQualification(model.intendedForQualification);
            rootGroup(model.rootGroup);
            devicePermissionRoleArn(model.devicePermissionRoleArn);
        }

        public final String getSuiteDefinitionName() {
            return suiteDefinitionName;
        }

        @Override
        public final Builder suiteDefinitionName(String suiteDefinitionName) {
            this.suiteDefinitionName = suiteDefinitionName;
            return this;
        }

        public final void setSuiteDefinitionName(String suiteDefinitionName) {
            this.suiteDefinitionName = suiteDefinitionName;
        }

        public final Collection<DeviceUnderTest.Builder> getDevices() {
            if (devices instanceof SdkAutoConstructList) {
                return null;
            }
            return devices != null ? devices.stream().map(DeviceUnderTest::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder devices(Collection<DeviceUnderTest> devices) {
            this.devices = DeviceUnderTestListCopier.copy(devices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder devices(DeviceUnderTest... devices) {
            devices(Arrays.asList(devices));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder devices(Consumer<DeviceUnderTest.Builder>... devices) {
            devices(Stream.of(devices).map(c -> DeviceUnderTest.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDevices(Collection<DeviceUnderTest.BuilderImpl> devices) {
            this.devices = DeviceUnderTestListCopier.copyFromBuilder(devices);
        }

        public final Boolean getIntendedForQualification() {
            return intendedForQualification;
        }

        @Override
        public final Builder intendedForQualification(Boolean intendedForQualification) {
            this.intendedForQualification = intendedForQualification;
            return this;
        }

        public final void setIntendedForQualification(Boolean intendedForQualification) {
            this.intendedForQualification = intendedForQualification;
        }

        public final String getRootGroup() {
            return rootGroup;
        }

        @Override
        public final Builder rootGroup(String rootGroup) {
            this.rootGroup = rootGroup;
            return this;
        }

        public final void setRootGroup(String rootGroup) {
            this.rootGroup = rootGroup;
        }

        public final String getDevicePermissionRoleArn() {
            return devicePermissionRoleArn;
        }

        @Override
        public final Builder devicePermissionRoleArn(String devicePermissionRoleArn) {
            this.devicePermissionRoleArn = devicePermissionRoleArn;
            return this;
        }

        public final void setDevicePermissionRoleArn(String devicePermissionRoleArn) {
            this.devicePermissionRoleArn = devicePermissionRoleArn;
        }

        @Override
        public SuiteDefinitionConfiguration build() {
            return new SuiteDefinitionConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
