/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotdataplane;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.iotdataplane.DefaultIotDataPlaneBaseClientBuilder;
import software.amazon.awssdk.services.iotdataplane.DefaultIotDataPlaneClient;
import software.amazon.awssdk.services.iotdataplane.IotDataPlaneClient;
import software.amazon.awssdk.services.iotdataplane.IotDataPlaneClientBuilder;
import software.amazon.awssdk.services.iotdataplane.IotDataPlaneServiceClientConfiguration;
import software.amazon.awssdk.services.iotdataplane.endpoints.IotDataPlaneEndpointProvider;

@SdkInternalApi
final class DefaultIotDataPlaneClientBuilder
extends DefaultIotDataPlaneBaseClientBuilder<IotDataPlaneClientBuilder, IotDataPlaneClient>
implements IotDataPlaneClientBuilder {
    DefaultIotDataPlaneClientBuilder() {
    }

    @Override
    public DefaultIotDataPlaneClientBuilder endpointProvider(IotDataPlaneEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final IotDataPlaneClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultIotDataPlaneClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        IotDataPlaneServiceClientConfiguration serviceClientConfiguration = IotDataPlaneServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultIotDataPlaneClient(serviceClientConfiguration, clientConfiguration);
    }
}

