/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotdataplane.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iotdataplane.model.PublishRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class PublishRequestModelMarshaller {
    private static final MarshallingInfo<String> TOPIC_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("topic").isBinary(false).build();
    private static final MarshallingInfo<Integer> QOS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("qos").isBinary(false).build();
    private static final MarshallingInfo<SdkBytes> PAYLOAD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.SDK_BYTES).marshallLocation(MarshallLocation.PAYLOAD).isExplicitPayloadMember(true).isBinary(true).build();
    private static final PublishRequestModelMarshaller INSTANCE = new PublishRequestModelMarshaller();

    private PublishRequestModelMarshaller() {
    }

    public static PublishRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(PublishRequest publishRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)publishRequest), (String)"publishRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)publishRequest.topic(), TOPIC_BINDING);
            protocolMarshaller.marshall((Object)publishRequest.qos(), QOS_BINDING);
            protocolMarshaller.marshall((Object)publishRequest.payload(), PAYLOAD_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

