/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotanalytics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An activity that performs a transformation on a message.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PipelineActivity implements SdkPojo, Serializable,
        ToCopyableBuilder<PipelineActivity.Builder, PipelineActivity> {
    private static final SdkField<ChannelActivity> CHANNEL_FIELD = SdkField.<ChannelActivity> builder(MarshallingType.SDK_POJO)
            .memberName("channel").getter(getter(PipelineActivity::channel)).setter(setter(Builder::channel))
            .constructor(ChannelActivity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("channel").build()).build();

    private static final SdkField<LambdaActivity> LAMBDA_FIELD = SdkField.<LambdaActivity> builder(MarshallingType.SDK_POJO)
            .memberName("lambda").getter(getter(PipelineActivity::lambda)).setter(setter(Builder::lambda))
            .constructor(LambdaActivity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambda").build()).build();

    private static final SdkField<DatastoreActivity> DATASTORE_FIELD = SdkField
            .<DatastoreActivity> builder(MarshallingType.SDK_POJO).memberName("datastore")
            .getter(getter(PipelineActivity::datastore)).setter(setter(Builder::datastore))
            .constructor(DatastoreActivity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datastore").build()).build();

    private static final SdkField<AddAttributesActivity> ADD_ATTRIBUTES_FIELD = SdkField
            .<AddAttributesActivity> builder(MarshallingType.SDK_POJO).memberName("addAttributes")
            .getter(getter(PipelineActivity::addAttributes)).setter(setter(Builder::addAttributes))
            .constructor(AddAttributesActivity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addAttributes").build()).build();

    private static final SdkField<RemoveAttributesActivity> REMOVE_ATTRIBUTES_FIELD = SdkField
            .<RemoveAttributesActivity> builder(MarshallingType.SDK_POJO).memberName("removeAttributes")
            .getter(getter(PipelineActivity::removeAttributes)).setter(setter(Builder::removeAttributes))
            .constructor(RemoveAttributesActivity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("removeAttributes").build()).build();

    private static final SdkField<SelectAttributesActivity> SELECT_ATTRIBUTES_FIELD = SdkField
            .<SelectAttributesActivity> builder(MarshallingType.SDK_POJO).memberName("selectAttributes")
            .getter(getter(PipelineActivity::selectAttributes)).setter(setter(Builder::selectAttributes))
            .constructor(SelectAttributesActivity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("selectAttributes").build()).build();

    private static final SdkField<FilterActivity> FILTER_FIELD = SdkField.<FilterActivity> builder(MarshallingType.SDK_POJO)
            .memberName("filter").getter(getter(PipelineActivity::filter)).setter(setter(Builder::filter))
            .constructor(FilterActivity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filter").build()).build();

    private static final SdkField<MathActivity> MATH_FIELD = SdkField.<MathActivity> builder(MarshallingType.SDK_POJO)
            .memberName("math").getter(getter(PipelineActivity::math)).setter(setter(Builder::math))
            .constructor(MathActivity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("math").build()).build();

    private static final SdkField<DeviceRegistryEnrichActivity> DEVICE_REGISTRY_ENRICH_FIELD = SdkField
            .<DeviceRegistryEnrichActivity> builder(MarshallingType.SDK_POJO).memberName("deviceRegistryEnrich")
            .getter(getter(PipelineActivity::deviceRegistryEnrich)).setter(setter(Builder::deviceRegistryEnrich))
            .constructor(DeviceRegistryEnrichActivity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceRegistryEnrich").build())
            .build();

    private static final SdkField<DeviceShadowEnrichActivity> DEVICE_SHADOW_ENRICH_FIELD = SdkField
            .<DeviceShadowEnrichActivity> builder(MarshallingType.SDK_POJO).memberName("deviceShadowEnrich")
            .getter(getter(PipelineActivity::deviceShadowEnrich)).setter(setter(Builder::deviceShadowEnrich))
            .constructor(DeviceShadowEnrichActivity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceShadowEnrich").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_FIELD, LAMBDA_FIELD,
            DATASTORE_FIELD, ADD_ATTRIBUTES_FIELD, REMOVE_ATTRIBUTES_FIELD, SELECT_ATTRIBUTES_FIELD, FILTER_FIELD, MATH_FIELD,
            DEVICE_REGISTRY_ENRICH_FIELD, DEVICE_SHADOW_ENRICH_FIELD));

    private static final long serialVersionUID = 1L;

    private final ChannelActivity channel;

    private final LambdaActivity lambda;

    private final DatastoreActivity datastore;

    private final AddAttributesActivity addAttributes;

    private final RemoveAttributesActivity removeAttributes;

    private final SelectAttributesActivity selectAttributes;

    private final FilterActivity filter;

    private final MathActivity math;

    private final DeviceRegistryEnrichActivity deviceRegistryEnrich;

    private final DeviceShadowEnrichActivity deviceShadowEnrich;

    private PipelineActivity(BuilderImpl builder) {
        this.channel = builder.channel;
        this.lambda = builder.lambda;
        this.datastore = builder.datastore;
        this.addAttributes = builder.addAttributes;
        this.removeAttributes = builder.removeAttributes;
        this.selectAttributes = builder.selectAttributes;
        this.filter = builder.filter;
        this.math = builder.math;
        this.deviceRegistryEnrich = builder.deviceRegistryEnrich;
        this.deviceShadowEnrich = builder.deviceShadowEnrich;
    }

    /**
     * <p>
     * Determines the source of the messages to be processed.
     * </p>
     * 
     * @return Determines the source of the messages to be processed.
     */
    public final ChannelActivity channel() {
        return channel;
    }

    /**
     * <p>
     * Runs a Lambda function to modify the message.
     * </p>
     * 
     * @return Runs a Lambda function to modify the message.
     */
    public final LambdaActivity lambda() {
        return lambda;
    }

    /**
     * <p>
     * Specifies where to store the processed message data.
     * </p>
     * 
     * @return Specifies where to store the processed message data.
     */
    public final DatastoreActivity datastore() {
        return datastore;
    }

    /**
     * <p>
     * Adds other attributes based on existing attributes in the message.
     * </p>
     * 
     * @return Adds other attributes based on existing attributes in the message.
     */
    public final AddAttributesActivity addAttributes() {
        return addAttributes;
    }

    /**
     * <p>
     * Removes attributes from a message.
     * </p>
     * 
     * @return Removes attributes from a message.
     */
    public final RemoveAttributesActivity removeAttributes() {
        return removeAttributes;
    }

    /**
     * <p>
     * Used to create a new message using only the specified attributes from the original message.
     * </p>
     * 
     * @return Used to create a new message using only the specified attributes from the original message.
     */
    public final SelectAttributesActivity selectAttributes() {
        return selectAttributes;
    }

    /**
     * <p>
     * Filters a message based on its attributes.
     * </p>
     * 
     * @return Filters a message based on its attributes.
     */
    public final FilterActivity filter() {
        return filter;
    }

    /**
     * <p>
     * Computes an arithmetic expression using the message's attributes and adds it to the message.
     * </p>
     * 
     * @return Computes an arithmetic expression using the message's attributes and adds it to the message.
     */
    public final MathActivity math() {
        return math;
    }

    /**
     * <p>
     * Adds data from the IoT device registry to your message.
     * </p>
     * 
     * @return Adds data from the IoT device registry to your message.
     */
    public final DeviceRegistryEnrichActivity deviceRegistryEnrich() {
        return deviceRegistryEnrich;
    }

    /**
     * <p>
     * Adds information from the IoT Device Shadow service to a message.
     * </p>
     * 
     * @return Adds information from the IoT Device Shadow service to a message.
     */
    public final DeviceShadowEnrichActivity deviceShadowEnrich() {
        return deviceShadowEnrich;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(channel());
        hashCode = 31 * hashCode + Objects.hashCode(lambda());
        hashCode = 31 * hashCode + Objects.hashCode(datastore());
        hashCode = 31 * hashCode + Objects.hashCode(addAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(removeAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(selectAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(filter());
        hashCode = 31 * hashCode + Objects.hashCode(math());
        hashCode = 31 * hashCode + Objects.hashCode(deviceRegistryEnrich());
        hashCode = 31 * hashCode + Objects.hashCode(deviceShadowEnrich());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipelineActivity)) {
            return false;
        }
        PipelineActivity other = (PipelineActivity) obj;
        return Objects.equals(channel(), other.channel()) && Objects.equals(lambda(), other.lambda())
                && Objects.equals(datastore(), other.datastore()) && Objects.equals(addAttributes(), other.addAttributes())
                && Objects.equals(removeAttributes(), other.removeAttributes())
                && Objects.equals(selectAttributes(), other.selectAttributes()) && Objects.equals(filter(), other.filter())
                && Objects.equals(math(), other.math()) && Objects.equals(deviceRegistryEnrich(), other.deviceRegistryEnrich())
                && Objects.equals(deviceShadowEnrich(), other.deviceShadowEnrich());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PipelineActivity").add("Channel", channel()).add("Lambda", lambda())
                .add("Datastore", datastore()).add("AddAttributes", addAttributes()).add("RemoveAttributes", removeAttributes())
                .add("SelectAttributes", selectAttributes()).add("Filter", filter()).add("Math", math())
                .add("DeviceRegistryEnrich", deviceRegistryEnrich()).add("DeviceShadowEnrich", deviceShadowEnrich()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "channel":
            return Optional.ofNullable(clazz.cast(channel()));
        case "lambda":
            return Optional.ofNullable(clazz.cast(lambda()));
        case "datastore":
            return Optional.ofNullable(clazz.cast(datastore()));
        case "addAttributes":
            return Optional.ofNullable(clazz.cast(addAttributes()));
        case "removeAttributes":
            return Optional.ofNullable(clazz.cast(removeAttributes()));
        case "selectAttributes":
            return Optional.ofNullable(clazz.cast(selectAttributes()));
        case "filter":
            return Optional.ofNullable(clazz.cast(filter()));
        case "math":
            return Optional.ofNullable(clazz.cast(math()));
        case "deviceRegistryEnrich":
            return Optional.ofNullable(clazz.cast(deviceRegistryEnrich()));
        case "deviceShadowEnrich":
            return Optional.ofNullable(clazz.cast(deviceShadowEnrich()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PipelineActivity, T> g) {
        return obj -> g.apply((PipelineActivity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PipelineActivity> {
        /**
         * <p>
         * Determines the source of the messages to be processed.
         * </p>
         * 
         * @param channel
         *        Determines the source of the messages to be processed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channel(ChannelActivity channel);

        /**
         * <p>
         * Determines the source of the messages to be processed.
         * </p>
         * This is a convenience method that creates an instance of the {@link ChannelActivity.Builder} avoiding the
         * need to create one manually via {@link ChannelActivity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChannelActivity.Builder#build()} is called immediately and its
         * result is passed to {@link #channel(ChannelActivity)}.
         * 
         * @param channel
         *        a consumer that will call methods on {@link ChannelActivity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #channel(ChannelActivity)
         */
        default Builder channel(Consumer<ChannelActivity.Builder> channel) {
            return channel(ChannelActivity.builder().applyMutation(channel).build());
        }

        /**
         * <p>
         * Runs a Lambda function to modify the message.
         * </p>
         * 
         * @param lambda
         *        Runs a Lambda function to modify the message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambda(LambdaActivity lambda);

        /**
         * <p>
         * Runs a Lambda function to modify the message.
         * </p>
         * This is a convenience method that creates an instance of the {@link LambdaActivity.Builder} avoiding the need
         * to create one manually via {@link LambdaActivity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LambdaActivity.Builder#build()} is called immediately and its
         * result is passed to {@link #lambda(LambdaActivity)}.
         * 
         * @param lambda
         *        a consumer that will call methods on {@link LambdaActivity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lambda(LambdaActivity)
         */
        default Builder lambda(Consumer<LambdaActivity.Builder> lambda) {
            return lambda(LambdaActivity.builder().applyMutation(lambda).build());
        }

        /**
         * <p>
         * Specifies where to store the processed message data.
         * </p>
         * 
         * @param datastore
         *        Specifies where to store the processed message data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datastore(DatastoreActivity datastore);

        /**
         * <p>
         * Specifies where to store the processed message data.
         * </p>
         * This is a convenience method that creates an instance of the {@link DatastoreActivity.Builder} avoiding the
         * need to create one manually via {@link DatastoreActivity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DatastoreActivity.Builder#build()} is called immediately and its
         * result is passed to {@link #datastore(DatastoreActivity)}.
         * 
         * @param datastore
         *        a consumer that will call methods on {@link DatastoreActivity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #datastore(DatastoreActivity)
         */
        default Builder datastore(Consumer<DatastoreActivity.Builder> datastore) {
            return datastore(DatastoreActivity.builder().applyMutation(datastore).build());
        }

        /**
         * <p>
         * Adds other attributes based on existing attributes in the message.
         * </p>
         * 
         * @param addAttributes
         *        Adds other attributes based on existing attributes in the message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addAttributes(AddAttributesActivity addAttributes);

        /**
         * <p>
         * Adds other attributes based on existing attributes in the message.
         * </p>
         * This is a convenience method that creates an instance of the {@link AddAttributesActivity.Builder} avoiding
         * the need to create one manually via {@link AddAttributesActivity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AddAttributesActivity.Builder#build()} is called immediately and
         * its result is passed to {@link #addAttributes(AddAttributesActivity)}.
         * 
         * @param addAttributes
         *        a consumer that will call methods on {@link AddAttributesActivity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #addAttributes(AddAttributesActivity)
         */
        default Builder addAttributes(Consumer<AddAttributesActivity.Builder> addAttributes) {
            return addAttributes(AddAttributesActivity.builder().applyMutation(addAttributes).build());
        }

        /**
         * <p>
         * Removes attributes from a message.
         * </p>
         * 
         * @param removeAttributes
         *        Removes attributes from a message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeAttributes(RemoveAttributesActivity removeAttributes);

        /**
         * <p>
         * Removes attributes from a message.
         * </p>
         * This is a convenience method that creates an instance of the {@link RemoveAttributesActivity.Builder}
         * avoiding the need to create one manually via {@link RemoveAttributesActivity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RemoveAttributesActivity.Builder#build()} is called immediately
         * and its result is passed to {@link #removeAttributes(RemoveAttributesActivity)}.
         * 
         * @param removeAttributes
         *        a consumer that will call methods on {@link RemoveAttributesActivity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #removeAttributes(RemoveAttributesActivity)
         */
        default Builder removeAttributes(Consumer<RemoveAttributesActivity.Builder> removeAttributes) {
            return removeAttributes(RemoveAttributesActivity.builder().applyMutation(removeAttributes).build());
        }

        /**
         * <p>
         * Used to create a new message using only the specified attributes from the original message.
         * </p>
         * 
         * @param selectAttributes
         *        Used to create a new message using only the specified attributes from the original message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectAttributes(SelectAttributesActivity selectAttributes);

        /**
         * <p>
         * Used to create a new message using only the specified attributes from the original message.
         * </p>
         * This is a convenience method that creates an instance of the {@link SelectAttributesActivity.Builder}
         * avoiding the need to create one manually via {@link SelectAttributesActivity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SelectAttributesActivity.Builder#build()} is called immediately
         * and its result is passed to {@link #selectAttributes(SelectAttributesActivity)}.
         * 
         * @param selectAttributes
         *        a consumer that will call methods on {@link SelectAttributesActivity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #selectAttributes(SelectAttributesActivity)
         */
        default Builder selectAttributes(Consumer<SelectAttributesActivity.Builder> selectAttributes) {
            return selectAttributes(SelectAttributesActivity.builder().applyMutation(selectAttributes).build());
        }

        /**
         * <p>
         * Filters a message based on its attributes.
         * </p>
         * 
         * @param filter
         *        Filters a message based on its attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(FilterActivity filter);

        /**
         * <p>
         * Filters a message based on its attributes.
         * </p>
         * This is a convenience method that creates an instance of the {@link FilterActivity.Builder} avoiding the need
         * to create one manually via {@link FilterActivity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FilterActivity.Builder#build()} is called immediately and its
         * result is passed to {@link #filter(FilterActivity)}.
         * 
         * @param filter
         *        a consumer that will call methods on {@link FilterActivity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filter(FilterActivity)
         */
        default Builder filter(Consumer<FilterActivity.Builder> filter) {
            return filter(FilterActivity.builder().applyMutation(filter).build());
        }

        /**
         * <p>
         * Computes an arithmetic expression using the message's attributes and adds it to the message.
         * </p>
         * 
         * @param math
         *        Computes an arithmetic expression using the message's attributes and adds it to the message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder math(MathActivity math);

        /**
         * <p>
         * Computes an arithmetic expression using the message's attributes and adds it to the message.
         * </p>
         * This is a convenience method that creates an instance of the {@link MathActivity.Builder} avoiding the need
         * to create one manually via {@link MathActivity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MathActivity.Builder#build()} is called immediately and its
         * result is passed to {@link #math(MathActivity)}.
         * 
         * @param math
         *        a consumer that will call methods on {@link MathActivity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #math(MathActivity)
         */
        default Builder math(Consumer<MathActivity.Builder> math) {
            return math(MathActivity.builder().applyMutation(math).build());
        }

        /**
         * <p>
         * Adds data from the IoT device registry to your message.
         * </p>
         * 
         * @param deviceRegistryEnrich
         *        Adds data from the IoT device registry to your message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceRegistryEnrich(DeviceRegistryEnrichActivity deviceRegistryEnrich);

        /**
         * <p>
         * Adds data from the IoT device registry to your message.
         * </p>
         * This is a convenience method that creates an instance of the {@link DeviceRegistryEnrichActivity.Builder}
         * avoiding the need to create one manually via {@link DeviceRegistryEnrichActivity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DeviceRegistryEnrichActivity.Builder#build()} is called
         * immediately and its result is passed to {@link #deviceRegistryEnrich(DeviceRegistryEnrichActivity)}.
         * 
         * @param deviceRegistryEnrich
         *        a consumer that will call methods on {@link DeviceRegistryEnrichActivity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deviceRegistryEnrich(DeviceRegistryEnrichActivity)
         */
        default Builder deviceRegistryEnrich(Consumer<DeviceRegistryEnrichActivity.Builder> deviceRegistryEnrich) {
            return deviceRegistryEnrich(DeviceRegistryEnrichActivity.builder().applyMutation(deviceRegistryEnrich).build());
        }

        /**
         * <p>
         * Adds information from the IoT Device Shadow service to a message.
         * </p>
         * 
         * @param deviceShadowEnrich
         *        Adds information from the IoT Device Shadow service to a message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceShadowEnrich(DeviceShadowEnrichActivity deviceShadowEnrich);

        /**
         * <p>
         * Adds information from the IoT Device Shadow service to a message.
         * </p>
         * This is a convenience method that creates an instance of the {@link DeviceShadowEnrichActivity.Builder}
         * avoiding the need to create one manually via {@link DeviceShadowEnrichActivity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DeviceShadowEnrichActivity.Builder#build()} is called immediately
         * and its result is passed to {@link #deviceShadowEnrich(DeviceShadowEnrichActivity)}.
         * 
         * @param deviceShadowEnrich
         *        a consumer that will call methods on {@link DeviceShadowEnrichActivity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deviceShadowEnrich(DeviceShadowEnrichActivity)
         */
        default Builder deviceShadowEnrich(Consumer<DeviceShadowEnrichActivity.Builder> deviceShadowEnrich) {
            return deviceShadowEnrich(DeviceShadowEnrichActivity.builder().applyMutation(deviceShadowEnrich).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ChannelActivity channel;

        private LambdaActivity lambda;

        private DatastoreActivity datastore;

        private AddAttributesActivity addAttributes;

        private RemoveAttributesActivity removeAttributes;

        private SelectAttributesActivity selectAttributes;

        private FilterActivity filter;

        private MathActivity math;

        private DeviceRegistryEnrichActivity deviceRegistryEnrich;

        private DeviceShadowEnrichActivity deviceShadowEnrich;

        private BuilderImpl() {
        }

        private BuilderImpl(PipelineActivity model) {
            channel(model.channel);
            lambda(model.lambda);
            datastore(model.datastore);
            addAttributes(model.addAttributes);
            removeAttributes(model.removeAttributes);
            selectAttributes(model.selectAttributes);
            filter(model.filter);
            math(model.math);
            deviceRegistryEnrich(model.deviceRegistryEnrich);
            deviceShadowEnrich(model.deviceShadowEnrich);
        }

        public final ChannelActivity.Builder getChannel() {
            return channel != null ? channel.toBuilder() : null;
        }

        public final void setChannel(ChannelActivity.BuilderImpl channel) {
            this.channel = channel != null ? channel.build() : null;
        }

        @Override
        public final Builder channel(ChannelActivity channel) {
            this.channel = channel;
            return this;
        }

        public final LambdaActivity.Builder getLambda() {
            return lambda != null ? lambda.toBuilder() : null;
        }

        public final void setLambda(LambdaActivity.BuilderImpl lambda) {
            this.lambda = lambda != null ? lambda.build() : null;
        }

        @Override
        public final Builder lambda(LambdaActivity lambda) {
            this.lambda = lambda;
            return this;
        }

        public final DatastoreActivity.Builder getDatastore() {
            return datastore != null ? datastore.toBuilder() : null;
        }

        public final void setDatastore(DatastoreActivity.BuilderImpl datastore) {
            this.datastore = datastore != null ? datastore.build() : null;
        }

        @Override
        public final Builder datastore(DatastoreActivity datastore) {
            this.datastore = datastore;
            return this;
        }

        public final AddAttributesActivity.Builder getAddAttributes() {
            return addAttributes != null ? addAttributes.toBuilder() : null;
        }

        public final void setAddAttributes(AddAttributesActivity.BuilderImpl addAttributes) {
            this.addAttributes = addAttributes != null ? addAttributes.build() : null;
        }

        @Override
        public final Builder addAttributes(AddAttributesActivity addAttributes) {
            this.addAttributes = addAttributes;
            return this;
        }

        public final RemoveAttributesActivity.Builder getRemoveAttributes() {
            return removeAttributes != null ? removeAttributes.toBuilder() : null;
        }

        public final void setRemoveAttributes(RemoveAttributesActivity.BuilderImpl removeAttributes) {
            this.removeAttributes = removeAttributes != null ? removeAttributes.build() : null;
        }

        @Override
        public final Builder removeAttributes(RemoveAttributesActivity removeAttributes) {
            this.removeAttributes = removeAttributes;
            return this;
        }

        public final SelectAttributesActivity.Builder getSelectAttributes() {
            return selectAttributes != null ? selectAttributes.toBuilder() : null;
        }

        public final void setSelectAttributes(SelectAttributesActivity.BuilderImpl selectAttributes) {
            this.selectAttributes = selectAttributes != null ? selectAttributes.build() : null;
        }

        @Override
        public final Builder selectAttributes(SelectAttributesActivity selectAttributes) {
            this.selectAttributes = selectAttributes;
            return this;
        }

        public final FilterActivity.Builder getFilter() {
            return filter != null ? filter.toBuilder() : null;
        }

        public final void setFilter(FilterActivity.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        public final Builder filter(FilterActivity filter) {
            this.filter = filter;
            return this;
        }

        public final MathActivity.Builder getMath() {
            return math != null ? math.toBuilder() : null;
        }

        public final void setMath(MathActivity.BuilderImpl math) {
            this.math = math != null ? math.build() : null;
        }

        @Override
        public final Builder math(MathActivity math) {
            this.math = math;
            return this;
        }

        public final DeviceRegistryEnrichActivity.Builder getDeviceRegistryEnrich() {
            return deviceRegistryEnrich != null ? deviceRegistryEnrich.toBuilder() : null;
        }

        public final void setDeviceRegistryEnrich(DeviceRegistryEnrichActivity.BuilderImpl deviceRegistryEnrich) {
            this.deviceRegistryEnrich = deviceRegistryEnrich != null ? deviceRegistryEnrich.build() : null;
        }

        @Override
        public final Builder deviceRegistryEnrich(DeviceRegistryEnrichActivity deviceRegistryEnrich) {
            this.deviceRegistryEnrich = deviceRegistryEnrich;
            return this;
        }

        public final DeviceShadowEnrichActivity.Builder getDeviceShadowEnrich() {
            return deviceShadowEnrich != null ? deviceShadowEnrich.toBuilder() : null;
        }

        public final void setDeviceShadowEnrich(DeviceShadowEnrichActivity.BuilderImpl deviceShadowEnrich) {
            this.deviceShadowEnrich = deviceShadowEnrich != null ? deviceShadowEnrich.build() : null;
        }

        @Override
        public final Builder deviceShadowEnrich(DeviceShadowEnrichActivity deviceShadowEnrich) {
            this.deviceShadowEnrich = deviceShadowEnrich;
            return this;
        }

        @Override
        public PipelineActivity build() {
            return new PipelineActivity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
