/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotanalytics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotanalytics.model.AttributeNamesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SelectAttributesActivity
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SelectAttributesActivity> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(SelectAttributesActivity.getter(SelectAttributesActivity::name)).setter(SelectAttributesActivity.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<List<String>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("attributes").getter(SelectAttributesActivity.getter(SelectAttributesActivity::attributes)).setter(SelectAttributesActivity.setter(Builder::attributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("next").getter(SelectAttributesActivity.getter(SelectAttributesActivity::next)).setter(SelectAttributesActivity.setter(Builder::next)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("next").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ATTRIBUTES_FIELD, NEXT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final List<String> attributes;
    private final String next;

    private SelectAttributesActivity(BuilderImpl builder) {
        this.name = builder.name;
        this.attributes = builder.attributes;
        this.next = builder.next;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasAttributes() {
        return this.attributes != null && !(this.attributes instanceof SdkAutoConstructList);
    }

    public final List<String> attributes() {
        return this.attributes;
    }

    public final String next() {
        return this.next;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributes() ? this.attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.next());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SelectAttributesActivity)) {
            return false;
        }
        SelectAttributesActivity other = (SelectAttributesActivity)obj;
        return Objects.equals(this.name(), other.name()) && this.hasAttributes() == other.hasAttributes() && Objects.equals(this.attributes(), other.attributes()) && Objects.equals(this.next(), other.next());
    }

    public final String toString() {
        return ToString.builder((String)"SelectAttributesActivity").add("Name", (Object)this.name()).add("Attributes", this.hasAttributes() ? this.attributes() : null).add("Next", (Object)this.next()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
            case "next": {
                return Optional.ofNullable(clazz.cast(this.next()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SelectAttributesActivity, T> g) {
        return obj -> g.apply((SelectAttributesActivity)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private List<String> attributes = DefaultSdkAutoConstructList.getInstance();
        private String next;

        private BuilderImpl() {
        }

        private BuilderImpl(SelectAttributesActivity model) {
            this.name(model.name);
            this.attributes(model.attributes);
            this.next(model.next);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<String> getAttributes() {
            if (this.attributes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.attributes;
        }

        @Override
        public final Builder attributes(Collection<String> attributes) {
            this.attributes = AttributeNamesCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(String ... attributes) {
            this.attributes(Arrays.asList(attributes));
            return this;
        }

        public final void setAttributes(Collection<String> attributes) {
            this.attributes = AttributeNamesCopier.copy(attributes);
        }

        public final String getNext() {
            return this.next;
        }

        @Override
        public final Builder next(String next) {
            this.next = next;
            return this;
        }

        public final void setNext(String next) {
            this.next = next;
        }

        public SelectAttributesActivity build() {
            return new SelectAttributesActivity(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SelectAttributesActivity> {
        public Builder name(String var1);

        public Builder attributes(Collection<String> var1);

        public Builder attributes(String ... var1);

        public Builder next(String var1);
    }
}

