/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotanalytics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotanalytics.model.Datastore;
import software.amazon.awssdk.services.iotanalytics.model.DatastoreStatistics;
import software.amazon.awssdk.services.iotanalytics.model.IoTAnalyticsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDatastoreResponse
extends IoTAnalyticsResponse
implements ToCopyableBuilder<Builder, DescribeDatastoreResponse> {
    private static final SdkField<Datastore> DATASTORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("datastore").getter(DescribeDatastoreResponse.getter(DescribeDatastoreResponse::datastore)).setter(DescribeDatastoreResponse.setter(Builder::datastore)).constructor(Datastore::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datastore").build()}).build();
    private static final SdkField<DatastoreStatistics> STATISTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("statistics").getter(DescribeDatastoreResponse.getter(DescribeDatastoreResponse::statistics)).setter(DescribeDatastoreResponse.setter(Builder::statistics)).constructor(DatastoreStatistics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statistics").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASTORE_FIELD, STATISTICS_FIELD));
    private final Datastore datastore;
    private final DatastoreStatistics statistics;

    private DescribeDatastoreResponse(BuilderImpl builder) {
        super(builder);
        this.datastore = builder.datastore;
        this.statistics = builder.statistics;
    }

    public final Datastore datastore() {
        return this.datastore;
    }

    public final DatastoreStatistics statistics() {
        return this.statistics;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.datastore());
        hashCode = 31 * hashCode + Objects.hashCode(this.statistics());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDatastoreResponse)) {
            return false;
        }
        DescribeDatastoreResponse other = (DescribeDatastoreResponse)((Object)obj);
        return Objects.equals(this.datastore(), other.datastore()) && Objects.equals(this.statistics(), other.statistics());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeDatastoreResponse").add("Datastore", (Object)this.datastore()).add("Statistics", (Object)this.statistics()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "datastore": {
                return Optional.ofNullable(clazz.cast(this.datastore()));
            }
            case "statistics": {
                return Optional.ofNullable(clazz.cast(this.statistics()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDatastoreResponse, T> g) {
        return obj -> g.apply((DescribeDatastoreResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTAnalyticsResponse.BuilderImpl
    implements Builder {
        private Datastore datastore;
        private DatastoreStatistics statistics;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDatastoreResponse model) {
            super(model);
            this.datastore(model.datastore);
            this.statistics(model.statistics);
        }

        public final Datastore.Builder getDatastore() {
            return this.datastore != null ? this.datastore.toBuilder() : null;
        }

        @Override
        public final Builder datastore(Datastore datastore) {
            this.datastore = datastore;
            return this;
        }

        public final void setDatastore(Datastore.BuilderImpl datastore) {
            this.datastore = datastore != null ? datastore.build() : null;
        }

        public final DatastoreStatistics.Builder getStatistics() {
            return this.statistics != null ? this.statistics.toBuilder() : null;
        }

        @Override
        public final Builder statistics(DatastoreStatistics statistics) {
            this.statistics = statistics;
            return this;
        }

        public final void setStatistics(DatastoreStatistics.BuilderImpl statistics) {
            this.statistics = statistics != null ? statistics.build() : null;
        }

        @Override
        public DescribeDatastoreResponse build() {
            return new DescribeDatastoreResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTAnalyticsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDatastoreResponse> {
        public Builder datastore(Datastore var1);

        default public Builder datastore(Consumer<Datastore.Builder> datastore) {
            return this.datastore((Datastore)((Datastore.Builder)Datastore.builder().applyMutation(datastore)).build());
        }

        public Builder statistics(DatastoreStatistics var1);

        default public Builder statistics(Consumer<DatastoreStatistics.Builder> statistics) {
            return this.statistics((DatastoreStatistics)((DatastoreStatistics.Builder)DatastoreStatistics.builder().applyMutation(statistics)).build());
        }
    }
}

