/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotanalytics.model;

import static java.util.stream.Collectors.toList;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class LateDataRulesCopier {
    static List<LateDataRule> copy(Collection<LateDataRule> lateDataRulesParam) {
        if (lateDataRulesParam == null || lateDataRulesParam instanceof SdkAutoConstructList) {
            return DefaultSdkAutoConstructList.getInstance();
        }
        List<LateDataRule> lateDataRulesParamCopy = new ArrayList<>(lateDataRulesParam);
        return Collections.unmodifiableList(lateDataRulesParamCopy);
    }

    static List<LateDataRule> copyFromBuilder(Collection<? extends LateDataRule.Builder> lateDataRulesParam) {
        if (lateDataRulesParam == null || lateDataRulesParam instanceof DefaultSdkAutoConstructList) {
            return DefaultSdkAutoConstructList.getInstance();
        }
        return copy(lateDataRulesParam.stream().map(LateDataRule.Builder::build).collect(toList()));
    }
}
