/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotanalytics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The destination to which dataset contents are delivered.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DatasetContentDeliveryDestination implements SdkPojo, Serializable,
        ToCopyableBuilder<DatasetContentDeliveryDestination.Builder, DatasetContentDeliveryDestination> {
    private static final SdkField<IotEventsDestinationConfiguration> IOT_EVENTS_DESTINATION_CONFIGURATION_FIELD = SdkField
            .<IotEventsDestinationConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("iotEventsDestinationConfiguration")
            .getter(getter(DatasetContentDeliveryDestination::iotEventsDestinationConfiguration))
            .setter(setter(Builder::iotEventsDestinationConfiguration))
            .constructor(IotEventsDestinationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iotEventsDestinationConfiguration")
                    .build()).build();

    private static final SdkField<S3DestinationConfiguration> S3_DESTINATION_CONFIGURATION_FIELD = SdkField
            .<S3DestinationConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("s3DestinationConfiguration")
            .getter(getter(DatasetContentDeliveryDestination::s3DestinationConfiguration))
            .setter(setter(Builder::s3DestinationConfiguration))
            .constructor(S3DestinationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3DestinationConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            IOT_EVENTS_DESTINATION_CONFIGURATION_FIELD, S3_DESTINATION_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final IotEventsDestinationConfiguration iotEventsDestinationConfiguration;

    private final S3DestinationConfiguration s3DestinationConfiguration;

    private DatasetContentDeliveryDestination(BuilderImpl builder) {
        this.iotEventsDestinationConfiguration = builder.iotEventsDestinationConfiguration;
        this.s3DestinationConfiguration = builder.s3DestinationConfiguration;
    }

    /**
     * <p>
     * Configuration information for delivery of dataset contents to AWS IoT Events.
     * </p>
     * 
     * @return Configuration information for delivery of dataset contents to AWS IoT Events.
     */
    public final IotEventsDestinationConfiguration iotEventsDestinationConfiguration() {
        return iotEventsDestinationConfiguration;
    }

    /**
     * <p>
     * Configuration information for delivery of dataset contents to Amazon S3.
     * </p>
     * 
     * @return Configuration information for delivery of dataset contents to Amazon S3.
     */
    public final S3DestinationConfiguration s3DestinationConfiguration() {
        return s3DestinationConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(iotEventsDestinationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(s3DestinationConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatasetContentDeliveryDestination)) {
            return false;
        }
        DatasetContentDeliveryDestination other = (DatasetContentDeliveryDestination) obj;
        return Objects.equals(iotEventsDestinationConfiguration(), other.iotEventsDestinationConfiguration())
                && Objects.equals(s3DestinationConfiguration(), other.s3DestinationConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DatasetContentDeliveryDestination")
                .add("IotEventsDestinationConfiguration", iotEventsDestinationConfiguration())
                .add("S3DestinationConfiguration", s3DestinationConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "iotEventsDestinationConfiguration":
            return Optional.ofNullable(clazz.cast(iotEventsDestinationConfiguration()));
        case "s3DestinationConfiguration":
            return Optional.ofNullable(clazz.cast(s3DestinationConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DatasetContentDeliveryDestination, T> g) {
        return obj -> g.apply((DatasetContentDeliveryDestination) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DatasetContentDeliveryDestination> {
        /**
         * <p>
         * Configuration information for delivery of dataset contents to AWS IoT Events.
         * </p>
         * 
         * @param iotEventsDestinationConfiguration
         *        Configuration information for delivery of dataset contents to AWS IoT Events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iotEventsDestinationConfiguration(IotEventsDestinationConfiguration iotEventsDestinationConfiguration);

        /**
         * <p>
         * Configuration information for delivery of dataset contents to AWS IoT Events.
         * </p>
         * This is a convenience that creates an instance of the {@link IotEventsDestinationConfiguration.Builder}
         * avoiding the need to create one manually via {@link IotEventsDestinationConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link IotEventsDestinationConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #iotEventsDestinationConfiguration(IotEventsDestinationConfiguration)}.
         * 
         * @param iotEventsDestinationConfiguration
         *        a consumer that will call methods on {@link IotEventsDestinationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #iotEventsDestinationConfiguration(IotEventsDestinationConfiguration)
         */
        default Builder iotEventsDestinationConfiguration(
                Consumer<IotEventsDestinationConfiguration.Builder> iotEventsDestinationConfiguration) {
            return iotEventsDestinationConfiguration(IotEventsDestinationConfiguration.builder()
                    .applyMutation(iotEventsDestinationConfiguration).build());
        }

        /**
         * <p>
         * Configuration information for delivery of dataset contents to Amazon S3.
         * </p>
         * 
         * @param s3DestinationConfiguration
         *        Configuration information for delivery of dataset contents to Amazon S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3DestinationConfiguration(S3DestinationConfiguration s3DestinationConfiguration);

        /**
         * <p>
         * Configuration information for delivery of dataset contents to Amazon S3.
         * </p>
         * This is a convenience that creates an instance of the {@link S3DestinationConfiguration.Builder} avoiding the
         * need to create one manually via {@link S3DestinationConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3DestinationConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #s3DestinationConfiguration(S3DestinationConfiguration)}.
         * 
         * @param s3DestinationConfiguration
         *        a consumer that will call methods on {@link S3DestinationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3DestinationConfiguration(S3DestinationConfiguration)
         */
        default Builder s3DestinationConfiguration(Consumer<S3DestinationConfiguration.Builder> s3DestinationConfiguration) {
            return s3DestinationConfiguration(S3DestinationConfiguration.builder().applyMutation(s3DestinationConfiguration)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private IotEventsDestinationConfiguration iotEventsDestinationConfiguration;

        private S3DestinationConfiguration s3DestinationConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(DatasetContentDeliveryDestination model) {
            iotEventsDestinationConfiguration(model.iotEventsDestinationConfiguration);
            s3DestinationConfiguration(model.s3DestinationConfiguration);
        }

        public final IotEventsDestinationConfiguration.Builder getIotEventsDestinationConfiguration() {
            return iotEventsDestinationConfiguration != null ? iotEventsDestinationConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder iotEventsDestinationConfiguration(IotEventsDestinationConfiguration iotEventsDestinationConfiguration) {
            this.iotEventsDestinationConfiguration = iotEventsDestinationConfiguration;
            return this;
        }

        public final void setIotEventsDestinationConfiguration(
                IotEventsDestinationConfiguration.BuilderImpl iotEventsDestinationConfiguration) {
            this.iotEventsDestinationConfiguration = iotEventsDestinationConfiguration != null ? iotEventsDestinationConfiguration
                    .build() : null;
        }

        public final S3DestinationConfiguration.Builder getS3DestinationConfiguration() {
            return s3DestinationConfiguration != null ? s3DestinationConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder s3DestinationConfiguration(S3DestinationConfiguration s3DestinationConfiguration) {
            this.s3DestinationConfiguration = s3DestinationConfiguration;
            return this;
        }

        public final void setS3DestinationConfiguration(S3DestinationConfiguration.BuilderImpl s3DestinationConfiguration) {
            this.s3DestinationConfiguration = s3DestinationConfiguration != null ? s3DestinationConfiguration.build() : null;
        }

        @Override
        public DatasetContentDeliveryDestination build() {
            return new DatasetContentDeliveryDestination(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
