/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotanalytics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information which is used to filter message data, to segregate it according to the time frame in which it arrives.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class QueryFilter implements SdkPojo, Serializable, ToCopyableBuilder<QueryFilter.Builder, QueryFilter> {
    private static final SdkField<DeltaTime> DELTA_TIME_FIELD = SdkField.<DeltaTime> builder(MarshallingType.SDK_POJO)
            .getter(getter(QueryFilter::deltaTime)).setter(setter(Builder::deltaTime)).constructor(DeltaTime::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deltaTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELTA_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final DeltaTime deltaTime;

    private QueryFilter(BuilderImpl builder) {
        this.deltaTime = builder.deltaTime;
    }

    /**
     * <p>
     * Used to limit data to that which has arrived since the last execution of the action.
     * </p>
     * 
     * @return Used to limit data to that which has arrived since the last execution of the action.
     */
    public DeltaTime deltaTime() {
        return deltaTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deltaTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryFilter)) {
            return false;
        }
        QueryFilter other = (QueryFilter) obj;
        return Objects.equals(deltaTime(), other.deltaTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("QueryFilter").add("DeltaTime", deltaTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "deltaTime":
            return Optional.ofNullable(clazz.cast(deltaTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QueryFilter, T> g) {
        return obj -> g.apply((QueryFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, QueryFilter> {
        /**
         * <p>
         * Used to limit data to that which has arrived since the last execution of the action.
         * </p>
         * 
         * @param deltaTime
         *        Used to limit data to that which has arrived since the last execution of the action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deltaTime(DeltaTime deltaTime);

        /**
         * <p>
         * Used to limit data to that which has arrived since the last execution of the action.
         * </p>
         * This is a convenience that creates an instance of the {@link DeltaTime.Builder} avoiding the need to create
         * one manually via {@link DeltaTime#builder()}.
         *
         * When the {@link Consumer} completes, {@link DeltaTime.Builder#build()} is called immediately and its result
         * is passed to {@link #deltaTime(DeltaTime)}.
         * 
         * @param deltaTime
         *        a consumer that will call methods on {@link DeltaTime.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deltaTime(DeltaTime)
         */
        default Builder deltaTime(Consumer<DeltaTime.Builder> deltaTime) {
            return deltaTime(DeltaTime.builder().applyMutation(deltaTime).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DeltaTime deltaTime;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryFilter model) {
            deltaTime(model.deltaTime);
        }

        public final DeltaTime.Builder getDeltaTime() {
            return deltaTime != null ? deltaTime.toBuilder() : null;
        }

        @Override
        public final Builder deltaTime(DeltaTime deltaTime) {
            this.deltaTime = deltaTime;
            return this;
        }

        public final void setDeltaTime(DeltaTime.BuilderImpl deltaTime) {
            this.deltaTime = deltaTime != null ? deltaTime.build() : null;
        }

        @Override
        public QueryFilter build() {
            return new QueryFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
