/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotanalytics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about logging options.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LoggingOptions implements SdkPojo, Serializable, ToCopyableBuilder<LoggingOptions.Builder, LoggingOptions> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LoggingOptions::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<String> LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LoggingOptions::levelAsString)).setter(setter(Builder::level))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("level").build()).build();

    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(LoggingOptions::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD, LEVEL_FIELD,
            ENABLED_FIELD));

    private static final long serialVersionUID = 1L;

    private final String roleArn;

    private final String level;

    private final Boolean enabled;

    private LoggingOptions(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.level = builder.level;
        this.enabled = builder.enabled;
    }

    /**
     * <p>
     * The ARN of the role that grants permission to AWS IoT Analytics to perform logging.
     * </p>
     * 
     * @return The ARN of the role that grants permission to AWS IoT Analytics to perform logging.
     */
    public String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The logging level. Currently, only "ERROR" is supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #level} will return
     * {@link LoggingLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #levelAsString}.
     * </p>
     * 
     * @return The logging level. Currently, only "ERROR" is supported.
     * @see LoggingLevel
     */
    public LoggingLevel level() {
        return LoggingLevel.fromValue(level);
    }

    /**
     * <p>
     * The logging level. Currently, only "ERROR" is supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #level} will return
     * {@link LoggingLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #levelAsString}.
     * </p>
     * 
     * @return The logging level. Currently, only "ERROR" is supported.
     * @see LoggingLevel
     */
    public String levelAsString() {
        return level;
    }

    /**
     * <p>
     * If true, logging is enabled for AWS IoT Analytics.
     * </p>
     * 
     * @return If true, logging is enabled for AWS IoT Analytics.
     */
    public Boolean enabled() {
        return enabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(levelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoggingOptions)) {
            return false;
        }
        LoggingOptions other = (LoggingOptions) obj;
        return Objects.equals(roleArn(), other.roleArn()) && Objects.equals(levelAsString(), other.levelAsString())
                && Objects.equals(enabled(), other.enabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("LoggingOptions").add("RoleArn", roleArn()).add("Level", levelAsString())
                .add("Enabled", enabled()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "level":
            return Optional.ofNullable(clazz.cast(levelAsString()));
        case "enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LoggingOptions, T> g) {
        return obj -> g.apply((LoggingOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LoggingOptions> {
        /**
         * <p>
         * The ARN of the role that grants permission to AWS IoT Analytics to perform logging.
         * </p>
         * 
         * @param roleArn
         *        The ARN of the role that grants permission to AWS IoT Analytics to perform logging.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The logging level. Currently, only "ERROR" is supported.
         * </p>
         * 
         * @param level
         *        The logging level. Currently, only "ERROR" is supported.
         * @see LoggingLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LoggingLevel
         */
        Builder level(String level);

        /**
         * <p>
         * The logging level. Currently, only "ERROR" is supported.
         * </p>
         * 
         * @param level
         *        The logging level. Currently, only "ERROR" is supported.
         * @see LoggingLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LoggingLevel
         */
        Builder level(LoggingLevel level);

        /**
         * <p>
         * If true, logging is enabled for AWS IoT Analytics.
         * </p>
         * 
         * @param enabled
         *        If true, logging is enabled for AWS IoT Analytics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);
    }

    static final class BuilderImpl implements Builder {
        private String roleArn;

        private String level;

        private Boolean enabled;

        private BuilderImpl() {
        }

        private BuilderImpl(LoggingOptions model) {
            roleArn(model.roleArn);
            level(model.level);
            enabled(model.enabled);
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getLevelAsString() {
            return level;
        }

        @Override
        public final Builder level(String level) {
            this.level = level;
            return this;
        }

        @Override
        public final Builder level(LoggingLevel level) {
            this.level(level == null ? null : level.toString());
            return this;
        }

        public final void setLevel(String level) {
            this.level = level;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public LoggingOptions build() {
            return new LoggingOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
