/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotanalytics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Where data store data is stored.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DatastoreStorageSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<DatastoreStorageSummary.Builder, DatastoreStorageSummary> {
    private static final SdkField<ServiceManagedDatastoreS3StorageSummary> SERVICE_MANAGED_S3_FIELD = SdkField
            .<ServiceManagedDatastoreS3StorageSummary> builder(MarshallingType.SDK_POJO)
            .getter(getter(DatastoreStorageSummary::serviceManagedS3)).setter(setter(Builder::serviceManagedS3))
            .constructor(ServiceManagedDatastoreS3StorageSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceManagedS3").build()).build();

    private static final SdkField<CustomerManagedDatastoreS3StorageSummary> CUSTOMER_MANAGED_S3_FIELD = SdkField
            .<CustomerManagedDatastoreS3StorageSummary> builder(MarshallingType.SDK_POJO)
            .getter(getter(DatastoreStorageSummary::customerManagedS3)).setter(setter(Builder::customerManagedS3))
            .constructor(CustomerManagedDatastoreS3StorageSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerManagedS3").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_MANAGED_S3_FIELD,
            CUSTOMER_MANAGED_S3_FIELD));

    private static final long serialVersionUID = 1L;

    private final ServiceManagedDatastoreS3StorageSummary serviceManagedS3;

    private final CustomerManagedDatastoreS3StorageSummary customerManagedS3;

    private DatastoreStorageSummary(BuilderImpl builder) {
        this.serviceManagedS3 = builder.serviceManagedS3;
        this.customerManagedS3 = builder.customerManagedS3;
    }

    /**
     * <p>
     * Used to store data store data in an S3 bucket managed by the AWS IoT Analytics service.
     * </p>
     * 
     * @return Used to store data store data in an S3 bucket managed by the AWS IoT Analytics service.
     */
    public ServiceManagedDatastoreS3StorageSummary serviceManagedS3() {
        return serviceManagedS3;
    }

    /**
     * <p>
     * Used to store data store data in an S3 bucket that you manage.
     * </p>
     * 
     * @return Used to store data store data in an S3 bucket that you manage.
     */
    public CustomerManagedDatastoreS3StorageSummary customerManagedS3() {
        return customerManagedS3;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serviceManagedS3());
        hashCode = 31 * hashCode + Objects.hashCode(customerManagedS3());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatastoreStorageSummary)) {
            return false;
        }
        DatastoreStorageSummary other = (DatastoreStorageSummary) obj;
        return Objects.equals(serviceManagedS3(), other.serviceManagedS3())
                && Objects.equals(customerManagedS3(), other.customerManagedS3());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DatastoreStorageSummary").add("ServiceManagedS3", serviceManagedS3())
                .add("CustomerManagedS3", customerManagedS3()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "serviceManagedS3":
            return Optional.ofNullable(clazz.cast(serviceManagedS3()));
        case "customerManagedS3":
            return Optional.ofNullable(clazz.cast(customerManagedS3()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DatastoreStorageSummary, T> g) {
        return obj -> g.apply((DatastoreStorageSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DatastoreStorageSummary> {
        /**
         * <p>
         * Used to store data store data in an S3 bucket managed by the AWS IoT Analytics service.
         * </p>
         * 
         * @param serviceManagedS3
         *        Used to store data store data in an S3 bucket managed by the AWS IoT Analytics service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceManagedS3(ServiceManagedDatastoreS3StorageSummary serviceManagedS3);

        /**
         * <p>
         * Used to store data store data in an S3 bucket managed by the AWS IoT Analytics service.
         * </p>
         * This is a convenience that creates an instance of the {@link ServiceManagedDatastoreS3StorageSummary.Builder}
         * avoiding the need to create one manually via {@link ServiceManagedDatastoreS3StorageSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link ServiceManagedDatastoreS3StorageSummary.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #serviceManagedS3(ServiceManagedDatastoreS3StorageSummary)}.
         * 
         * @param serviceManagedS3
         *        a consumer that will call methods on {@link ServiceManagedDatastoreS3StorageSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceManagedS3(ServiceManagedDatastoreS3StorageSummary)
         */
        default Builder serviceManagedS3(Consumer<ServiceManagedDatastoreS3StorageSummary.Builder> serviceManagedS3) {
            return serviceManagedS3(ServiceManagedDatastoreS3StorageSummary.builder().applyMutation(serviceManagedS3).build());
        }

        /**
         * <p>
         * Used to store data store data in an S3 bucket that you manage.
         * </p>
         * 
         * @param customerManagedS3
         *        Used to store data store data in an S3 bucket that you manage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerManagedS3(CustomerManagedDatastoreS3StorageSummary customerManagedS3);

        /**
         * <p>
         * Used to store data store data in an S3 bucket that you manage.
         * </p>
         * This is a convenience that creates an instance of the
         * {@link CustomerManagedDatastoreS3StorageSummary.Builder} avoiding the need to create one manually via
         * {@link CustomerManagedDatastoreS3StorageSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link CustomerManagedDatastoreS3StorageSummary.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #customerManagedS3(CustomerManagedDatastoreS3StorageSummary)}.
         * 
         * @param customerManagedS3
         *        a consumer that will call methods on {@link CustomerManagedDatastoreS3StorageSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customerManagedS3(CustomerManagedDatastoreS3StorageSummary)
         */
        default Builder customerManagedS3(Consumer<CustomerManagedDatastoreS3StorageSummary.Builder> customerManagedS3) {
            return customerManagedS3(CustomerManagedDatastoreS3StorageSummary.builder().applyMutation(customerManagedS3).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ServiceManagedDatastoreS3StorageSummary serviceManagedS3;

        private CustomerManagedDatastoreS3StorageSummary customerManagedS3;

        private BuilderImpl() {
        }

        private BuilderImpl(DatastoreStorageSummary model) {
            serviceManagedS3(model.serviceManagedS3);
            customerManagedS3(model.customerManagedS3);
        }

        public final ServiceManagedDatastoreS3StorageSummary.Builder getServiceManagedS3() {
            return serviceManagedS3 != null ? serviceManagedS3.toBuilder() : null;
        }

        @Override
        public final Builder serviceManagedS3(ServiceManagedDatastoreS3StorageSummary serviceManagedS3) {
            this.serviceManagedS3 = serviceManagedS3;
            return this;
        }

        public final void setServiceManagedS3(ServiceManagedDatastoreS3StorageSummary.BuilderImpl serviceManagedS3) {
            this.serviceManagedS3 = serviceManagedS3 != null ? serviceManagedS3.build() : null;
        }

        public final CustomerManagedDatastoreS3StorageSummary.Builder getCustomerManagedS3() {
            return customerManagedS3 != null ? customerManagedS3.toBuilder() : null;
        }

        @Override
        public final Builder customerManagedS3(CustomerManagedDatastoreS3StorageSummary customerManagedS3) {
            this.customerManagedS3 = customerManagedS3;
            return this;
        }

        public final void setCustomerManagedS3(CustomerManagedDatastoreS3StorageSummary.BuilderImpl customerManagedS3) {
            this.customerManagedS3 = customerManagedS3 != null ? customerManagedS3.build() : null;
        }

        @Override
        public DatastoreStorageSummary build() {
            return new DatastoreStorageSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
