/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotanalytics.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a data store.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Datastore implements SdkPojo, Serializable, ToCopyableBuilder<Datastore.Builder, Datastore> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Datastore::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<DatastoreStorage> STORAGE_FIELD = SdkField.<DatastoreStorage> builder(MarshallingType.SDK_POJO)
            .getter(getter(Datastore::storage)).setter(setter(Builder::storage)).constructor(DatastoreStorage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storage").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Datastore::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Datastore::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<RetentionPeriod> RETENTION_PERIOD_FIELD = SdkField
            .<RetentionPeriod> builder(MarshallingType.SDK_POJO).getter(getter(Datastore::retentionPeriod))
            .setter(setter(Builder::retentionPeriod)).constructor(RetentionPeriod::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retentionPeriod").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Datastore::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Datastore::lastUpdateTime)).setter(setter(Builder::lastUpdateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, STORAGE_FIELD,
            ARN_FIELD, STATUS_FIELD, RETENTION_PERIOD_FIELD, CREATION_TIME_FIELD, LAST_UPDATE_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final DatastoreStorage storage;

    private final String arn;

    private final String status;

    private final RetentionPeriod retentionPeriod;

    private final Instant creationTime;

    private final Instant lastUpdateTime;

    private Datastore(BuilderImpl builder) {
        this.name = builder.name;
        this.storage = builder.storage;
        this.arn = builder.arn;
        this.status = builder.status;
        this.retentionPeriod = builder.retentionPeriod;
        this.creationTime = builder.creationTime;
        this.lastUpdateTime = builder.lastUpdateTime;
    }

    /**
     * <p>
     * The name of the data store.
     * </p>
     * 
     * @return The name of the data store.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * Where data store data is stored. You may choose one of "serviceManagedS3" or "customerManagedS3" storage. If not
     * specified, the default is "serviceManagedS3". This cannot be changed after the data store is created.
     * </p>
     * 
     * @return Where data store data is stored. You may choose one of "serviceManagedS3" or "customerManagedS3" storage.
     *         If not specified, the default is "serviceManagedS3". This cannot be changed after the data store is
     *         created.
     */
    public DatastoreStorage storage() {
        return storage;
    }

    /**
     * <p>
     * The ARN of the data store.
     * </p>
     * 
     * @return The ARN of the data store.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The status of a data store:
     * </p>
     * <dl>
     * <dt>CREATING</dt>
     * <dd>
     * <p>
     * The data store is being created.
     * </p>
     * </dd>
     * <dt>ACTIVE</dt>
     * <dd>
     * <p>
     * The data store has been created and can be used.
     * </p>
     * </dd>
     * <dt>DELETING</dt>
     * <dd>
     * <p>
     * The data store is being deleted.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DatastoreStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of a data store:</p>
     *         <dl>
     *         <dt>CREATING</dt>
     *         <dd>
     *         <p>
     *         The data store is being created.
     *         </p>
     *         </dd>
     *         <dt>ACTIVE</dt>
     *         <dd>
     *         <p>
     *         The data store has been created and can be used.
     *         </p>
     *         </dd>
     *         <dt>DELETING</dt>
     *         <dd>
     *         <p>
     *         The data store is being deleted.
     *         </p>
     *         </dd>
     * @see DatastoreStatus
     */
    public DatastoreStatus status() {
        return DatastoreStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of a data store:
     * </p>
     * <dl>
     * <dt>CREATING</dt>
     * <dd>
     * <p>
     * The data store is being created.
     * </p>
     * </dd>
     * <dt>ACTIVE</dt>
     * <dd>
     * <p>
     * The data store has been created and can be used.
     * </p>
     * </dd>
     * <dt>DELETING</dt>
     * <dd>
     * <p>
     * The data store is being deleted.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DatastoreStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of a data store:</p>
     *         <dl>
     *         <dt>CREATING</dt>
     *         <dd>
     *         <p>
     *         The data store is being created.
     *         </p>
     *         </dd>
     *         <dt>ACTIVE</dt>
     *         <dd>
     *         <p>
     *         The data store has been created and can be used.
     *         </p>
     *         </dd>
     *         <dt>DELETING</dt>
     *         <dd>
     *         <p>
     *         The data store is being deleted.
     *         </p>
     *         </dd>
     * @see DatastoreStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * How long, in days, message data is kept for the data store. When "customerManagedS3" storage is selected, this
     * parameter is ignored.
     * </p>
     * 
     * @return How long, in days, message data is kept for the data store. When "customerManagedS3" storage is selected,
     *         this parameter is ignored.
     */
    public RetentionPeriod retentionPeriod() {
        return retentionPeriod;
    }

    /**
     * <p>
     * When the data store was created.
     * </p>
     * 
     * @return When the data store was created.
     */
    public Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The last time the data store was updated.
     * </p>
     * 
     * @return The last time the data store was updated.
     */
    public Instant lastUpdateTime() {
        return lastUpdateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(storage());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(retentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Datastore)) {
            return false;
        }
        Datastore other = (Datastore) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(storage(), other.storage())
                && Objects.equals(arn(), other.arn()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(retentionPeriod(), other.retentionPeriod())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastUpdateTime(), other.lastUpdateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Datastore").add("Name", name()).add("Storage", storage()).add("Arn", arn())
                .add("Status", statusAsString()).add("RetentionPeriod", retentionPeriod()).add("CreationTime", creationTime())
                .add("LastUpdateTime", lastUpdateTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "storage":
            return Optional.ofNullable(clazz.cast(storage()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "retentionPeriod":
            return Optional.ofNullable(clazz.cast(retentionPeriod()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "lastUpdateTime":
            return Optional.ofNullable(clazz.cast(lastUpdateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Datastore, T> g) {
        return obj -> g.apply((Datastore) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Datastore> {
        /**
         * <p>
         * The name of the data store.
         * </p>
         * 
         * @param name
         *        The name of the data store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Where data store data is stored. You may choose one of "serviceManagedS3" or "customerManagedS3" storage. If
         * not specified, the default is "serviceManagedS3". This cannot be changed after the data store is created.
         * </p>
         * 
         * @param storage
         *        Where data store data is stored. You may choose one of "serviceManagedS3" or "customerManagedS3"
         *        storage. If not specified, the default is "serviceManagedS3". This cannot be changed after the data
         *        store is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storage(DatastoreStorage storage);

        /**
         * <p>
         * Where data store data is stored. You may choose one of "serviceManagedS3" or "customerManagedS3" storage. If
         * not specified, the default is "serviceManagedS3". This cannot be changed after the data store is created.
         * </p>
         * This is a convenience that creates an instance of the {@link DatastoreStorage.Builder} avoiding the need to
         * create one manually via {@link DatastoreStorage#builder()}.
         *
         * When the {@link Consumer} completes, {@link DatastoreStorage.Builder#build()} is called immediately and its
         * result is passed to {@link #storage(DatastoreStorage)}.
         * 
         * @param storage
         *        a consumer that will call methods on {@link DatastoreStorage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #storage(DatastoreStorage)
         */
        default Builder storage(Consumer<DatastoreStorage.Builder> storage) {
            return storage(DatastoreStorage.builder().applyMutation(storage).build());
        }

        /**
         * <p>
         * The ARN of the data store.
         * </p>
         * 
         * @param arn
         *        The ARN of the data store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The status of a data store:
         * </p>
         * <dl>
         * <dt>CREATING</dt>
         * <dd>
         * <p>
         * The data store is being created.
         * </p>
         * </dd>
         * <dt>ACTIVE</dt>
         * <dd>
         * <p>
         * The data store has been created and can be used.
         * </p>
         * </dd>
         * <dt>DELETING</dt>
         * <dd>
         * <p>
         * The data store is being deleted.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param status
         *        The status of a data store:</p>
         *        <dl>
         *        <dt>CREATING</dt>
         *        <dd>
         *        <p>
         *        The data store is being created.
         *        </p>
         *        </dd>
         *        <dt>ACTIVE</dt>
         *        <dd>
         *        <p>
         *        The data store has been created and can be used.
         *        </p>
         *        </dd>
         *        <dt>DELETING</dt>
         *        <dd>
         *        <p>
         *        The data store is being deleted.
         *        </p>
         *        </dd>
         * @see DatastoreStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatastoreStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of a data store:
         * </p>
         * <dl>
         * <dt>CREATING</dt>
         * <dd>
         * <p>
         * The data store is being created.
         * </p>
         * </dd>
         * <dt>ACTIVE</dt>
         * <dd>
         * <p>
         * The data store has been created and can be used.
         * </p>
         * </dd>
         * <dt>DELETING</dt>
         * <dd>
         * <p>
         * The data store is being deleted.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param status
         *        The status of a data store:</p>
         *        <dl>
         *        <dt>CREATING</dt>
         *        <dd>
         *        <p>
         *        The data store is being created.
         *        </p>
         *        </dd>
         *        <dt>ACTIVE</dt>
         *        <dd>
         *        <p>
         *        The data store has been created and can be used.
         *        </p>
         *        </dd>
         *        <dt>DELETING</dt>
         *        <dd>
         *        <p>
         *        The data store is being deleted.
         *        </p>
         *        </dd>
         * @see DatastoreStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DatastoreStatus
         */
        Builder status(DatastoreStatus status);

        /**
         * <p>
         * How long, in days, message data is kept for the data store. When "customerManagedS3" storage is selected,
         * this parameter is ignored.
         * </p>
         * 
         * @param retentionPeriod
         *        How long, in days, message data is kept for the data store. When "customerManagedS3" storage is
         *        selected, this parameter is ignored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retentionPeriod(RetentionPeriod retentionPeriod);

        /**
         * <p>
         * How long, in days, message data is kept for the data store. When "customerManagedS3" storage is selected,
         * this parameter is ignored.
         * </p>
         * This is a convenience that creates an instance of the {@link RetentionPeriod.Builder} avoiding the need to
         * create one manually via {@link RetentionPeriod#builder()}.
         *
         * When the {@link Consumer} completes, {@link RetentionPeriod.Builder#build()} is called immediately and its
         * result is passed to {@link #retentionPeriod(RetentionPeriod)}.
         * 
         * @param retentionPeriod
         *        a consumer that will call methods on {@link RetentionPeriod.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #retentionPeriod(RetentionPeriod)
         */
        default Builder retentionPeriod(Consumer<RetentionPeriod.Builder> retentionPeriod) {
            return retentionPeriod(RetentionPeriod.builder().applyMutation(retentionPeriod).build());
        }

        /**
         * <p>
         * When the data store was created.
         * </p>
         * 
         * @param creationTime
         *        When the data store was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The last time the data store was updated.
         * </p>
         * 
         * @param lastUpdateTime
         *        The last time the data store was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateTime(Instant lastUpdateTime);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private DatastoreStorage storage;

        private String arn;

        private String status;

        private RetentionPeriod retentionPeriod;

        private Instant creationTime;

        private Instant lastUpdateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(Datastore model) {
            name(model.name);
            storage(model.storage);
            arn(model.arn);
            status(model.status);
            retentionPeriod(model.retentionPeriod);
            creationTime(model.creationTime);
            lastUpdateTime(model.lastUpdateTime);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final DatastoreStorage.Builder getStorage() {
            return storage != null ? storage.toBuilder() : null;
        }

        @Override
        public final Builder storage(DatastoreStorage storage) {
            this.storage = storage;
            return this;
        }

        public final void setStorage(DatastoreStorage.BuilderImpl storage) {
            this.storage = storage != null ? storage.build() : null;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getStatusAsString() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DatastoreStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final RetentionPeriod.Builder getRetentionPeriod() {
            return retentionPeriod != null ? retentionPeriod.toBuilder() : null;
        }

        @Override
        public final Builder retentionPeriod(RetentionPeriod retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
            return this;
        }

        public final void setRetentionPeriod(RetentionPeriod.BuilderImpl retentionPeriod) {
            this.retentionPeriod = retentionPeriod != null ? retentionPeriod.build() : null;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getLastUpdateTime() {
            return lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        @Override
        public Datastore build() {
            return new Datastore(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
