/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotanalytics.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A collection of data from an MQTT topic. Channels archive the raw, unprocessed messages before publishing the data to
 * a pipeline.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Channel implements SdkPojo, Serializable, ToCopyableBuilder<Channel.Builder, Channel> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Channel::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<ChannelStorage> STORAGE_FIELD = SdkField.<ChannelStorage> builder(MarshallingType.SDK_POJO)
            .getter(getter(Channel::storage)).setter(setter(Builder::storage)).constructor(ChannelStorage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storage").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Channel::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Channel::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<RetentionPeriod> RETENTION_PERIOD_FIELD = SdkField
            .<RetentionPeriod> builder(MarshallingType.SDK_POJO).getter(getter(Channel::retentionPeriod))
            .setter(setter(Builder::retentionPeriod)).constructor(RetentionPeriod::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retentionPeriod").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Channel::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Channel::lastUpdateTime)).setter(setter(Builder::lastUpdateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, STORAGE_FIELD,
            ARN_FIELD, STATUS_FIELD, RETENTION_PERIOD_FIELD, CREATION_TIME_FIELD, LAST_UPDATE_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final ChannelStorage storage;

    private final String arn;

    private final String status;

    private final RetentionPeriod retentionPeriod;

    private final Instant creationTime;

    private final Instant lastUpdateTime;

    private Channel(BuilderImpl builder) {
        this.name = builder.name;
        this.storage = builder.storage;
        this.arn = builder.arn;
        this.status = builder.status;
        this.retentionPeriod = builder.retentionPeriod;
        this.creationTime = builder.creationTime;
        this.lastUpdateTime = builder.lastUpdateTime;
    }

    /**
     * <p>
     * The name of the channel.
     * </p>
     * 
     * @return The name of the channel.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * Where channel data is stored. You may choose one of "serviceManagedS3" or "customerManagedS3" storage. If not
     * specified, the default is "serviceManagedS3". This cannot be changed after creation of the channel.
     * </p>
     * 
     * @return Where channel data is stored. You may choose one of "serviceManagedS3" or "customerManagedS3" storage. If
     *         not specified, the default is "serviceManagedS3". This cannot be changed after creation of the channel.
     */
    public ChannelStorage storage() {
        return storage;
    }

    /**
     * <p>
     * The ARN of the channel.
     * </p>
     * 
     * @return The ARN of the channel.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The status of the channel.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ChannelStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the channel.
     * @see ChannelStatus
     */
    public ChannelStatus status() {
        return ChannelStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the channel.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ChannelStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the channel.
     * @see ChannelStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * How long, in days, message data is kept for the channel.
     * </p>
     * 
     * @return How long, in days, message data is kept for the channel.
     */
    public RetentionPeriod retentionPeriod() {
        return retentionPeriod;
    }

    /**
     * <p>
     * When the channel was created.
     * </p>
     * 
     * @return When the channel was created.
     */
    public Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * When the channel was last updated.
     * </p>
     * 
     * @return When the channel was last updated.
     */
    public Instant lastUpdateTime() {
        return lastUpdateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(storage());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(retentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Channel)) {
            return false;
        }
        Channel other = (Channel) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(storage(), other.storage())
                && Objects.equals(arn(), other.arn()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(retentionPeriod(), other.retentionPeriod())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastUpdateTime(), other.lastUpdateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Channel").add("Name", name()).add("Storage", storage()).add("Arn", arn())
                .add("Status", statusAsString()).add("RetentionPeriod", retentionPeriod()).add("CreationTime", creationTime())
                .add("LastUpdateTime", lastUpdateTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "storage":
            return Optional.ofNullable(clazz.cast(storage()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "retentionPeriod":
            return Optional.ofNullable(clazz.cast(retentionPeriod()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "lastUpdateTime":
            return Optional.ofNullable(clazz.cast(lastUpdateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Channel, T> g) {
        return obj -> g.apply((Channel) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Channel> {
        /**
         * <p>
         * The name of the channel.
         * </p>
         * 
         * @param name
         *        The name of the channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Where channel data is stored. You may choose one of "serviceManagedS3" or "customerManagedS3" storage. If not
         * specified, the default is "serviceManagedS3". This cannot be changed after creation of the channel.
         * </p>
         * 
         * @param storage
         *        Where channel data is stored. You may choose one of "serviceManagedS3" or "customerManagedS3" storage.
         *        If not specified, the default is "serviceManagedS3". This cannot be changed after creation of the
         *        channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storage(ChannelStorage storage);

        /**
         * <p>
         * Where channel data is stored. You may choose one of "serviceManagedS3" or "customerManagedS3" storage. If not
         * specified, the default is "serviceManagedS3". This cannot be changed after creation of the channel.
         * </p>
         * This is a convenience that creates an instance of the {@link ChannelStorage.Builder} avoiding the need to
         * create one manually via {@link ChannelStorage#builder()}.
         *
         * When the {@link Consumer} completes, {@link ChannelStorage.Builder#build()} is called immediately and its
         * result is passed to {@link #storage(ChannelStorage)}.
         * 
         * @param storage
         *        a consumer that will call methods on {@link ChannelStorage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #storage(ChannelStorage)
         */
        default Builder storage(Consumer<ChannelStorage.Builder> storage) {
            return storage(ChannelStorage.builder().applyMutation(storage).build());
        }

        /**
         * <p>
         * The ARN of the channel.
         * </p>
         * 
         * @param arn
         *        The ARN of the channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The status of the channel.
         * </p>
         * 
         * @param status
         *        The status of the channel.
         * @see ChannelStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the channel.
         * </p>
         * 
         * @param status
         *        The status of the channel.
         * @see ChannelStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelStatus
         */
        Builder status(ChannelStatus status);

        /**
         * <p>
         * How long, in days, message data is kept for the channel.
         * </p>
         * 
         * @param retentionPeriod
         *        How long, in days, message data is kept for the channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retentionPeriod(RetentionPeriod retentionPeriod);

        /**
         * <p>
         * How long, in days, message data is kept for the channel.
         * </p>
         * This is a convenience that creates an instance of the {@link RetentionPeriod.Builder} avoiding the need to
         * create one manually via {@link RetentionPeriod#builder()}.
         *
         * When the {@link Consumer} completes, {@link RetentionPeriod.Builder#build()} is called immediately and its
         * result is passed to {@link #retentionPeriod(RetentionPeriod)}.
         * 
         * @param retentionPeriod
         *        a consumer that will call methods on {@link RetentionPeriod.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #retentionPeriod(RetentionPeriod)
         */
        default Builder retentionPeriod(Consumer<RetentionPeriod.Builder> retentionPeriod) {
            return retentionPeriod(RetentionPeriod.builder().applyMutation(retentionPeriod).build());
        }

        /**
         * <p>
         * When the channel was created.
         * </p>
         * 
         * @param creationTime
         *        When the channel was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * When the channel was last updated.
         * </p>
         * 
         * @param lastUpdateTime
         *        When the channel was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateTime(Instant lastUpdateTime);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private ChannelStorage storage;

        private String arn;

        private String status;

        private RetentionPeriod retentionPeriod;

        private Instant creationTime;

        private Instant lastUpdateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(Channel model) {
            name(model.name);
            storage(model.storage);
            arn(model.arn);
            status(model.status);
            retentionPeriod(model.retentionPeriod);
            creationTime(model.creationTime);
            lastUpdateTime(model.lastUpdateTime);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final ChannelStorage.Builder getStorage() {
            return storage != null ? storage.toBuilder() : null;
        }

        @Override
        public final Builder storage(ChannelStorage storage) {
            this.storage = storage;
            return this;
        }

        public final void setStorage(ChannelStorage.BuilderImpl storage) {
            this.storage = storage != null ? storage.build() : null;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getStatusAsString() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ChannelStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final RetentionPeriod.Builder getRetentionPeriod() {
            return retentionPeriod != null ? retentionPeriod.toBuilder() : null;
        }

        @Override
        public final Builder retentionPeriod(RetentionPeriod retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
            return this;
        }

        public final void setRetentionPeriod(RetentionPeriod.BuilderImpl retentionPeriod) {
            this.retentionPeriod = retentionPeriod != null ? retentionPeriod.build() : null;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getLastUpdateTime() {
            return lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        @Override
        public Channel build() {
            return new Channel(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
