/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot1clickprojects;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.iot1clickprojects.model.AssociateDeviceWithPlacementRequest;
import software.amazon.awssdk.services.iot1clickprojects.model.AssociateDeviceWithPlacementResponse;
import software.amazon.awssdk.services.iot1clickprojects.model.CreatePlacementRequest;
import software.amazon.awssdk.services.iot1clickprojects.model.CreatePlacementResponse;
import software.amazon.awssdk.services.iot1clickprojects.model.CreateProjectRequest;
import software.amazon.awssdk.services.iot1clickprojects.model.CreateProjectResponse;
import software.amazon.awssdk.services.iot1clickprojects.model.DeletePlacementRequest;
import software.amazon.awssdk.services.iot1clickprojects.model.DeletePlacementResponse;
import software.amazon.awssdk.services.iot1clickprojects.model.DeleteProjectRequest;
import software.amazon.awssdk.services.iot1clickprojects.model.DeleteProjectResponse;
import software.amazon.awssdk.services.iot1clickprojects.model.DescribePlacementRequest;
import software.amazon.awssdk.services.iot1clickprojects.model.DescribePlacementResponse;
import software.amazon.awssdk.services.iot1clickprojects.model.DescribeProjectRequest;
import software.amazon.awssdk.services.iot1clickprojects.model.DescribeProjectResponse;
import software.amazon.awssdk.services.iot1clickprojects.model.DisassociateDeviceFromPlacementRequest;
import software.amazon.awssdk.services.iot1clickprojects.model.DisassociateDeviceFromPlacementResponse;
import software.amazon.awssdk.services.iot1clickprojects.model.GetDevicesInPlacementRequest;
import software.amazon.awssdk.services.iot1clickprojects.model.GetDevicesInPlacementResponse;
import software.amazon.awssdk.services.iot1clickprojects.model.InternalFailureException;
import software.amazon.awssdk.services.iot1clickprojects.model.InvalidRequestException;
import software.amazon.awssdk.services.iot1clickprojects.model.Iot1ClickProjectsException;
import software.amazon.awssdk.services.iot1clickprojects.model.ListPlacementsRequest;
import software.amazon.awssdk.services.iot1clickprojects.model.ListPlacementsResponse;
import software.amazon.awssdk.services.iot1clickprojects.model.ListProjectsRequest;
import software.amazon.awssdk.services.iot1clickprojects.model.ListProjectsResponse;
import software.amazon.awssdk.services.iot1clickprojects.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.iot1clickprojects.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.iot1clickprojects.model.ResourceConflictException;
import software.amazon.awssdk.services.iot1clickprojects.model.ResourceNotFoundException;
import software.amazon.awssdk.services.iot1clickprojects.model.TagResourceRequest;
import software.amazon.awssdk.services.iot1clickprojects.model.TagResourceResponse;
import software.amazon.awssdk.services.iot1clickprojects.model.TooManyRequestsException;
import software.amazon.awssdk.services.iot1clickprojects.model.UntagResourceRequest;
import software.amazon.awssdk.services.iot1clickprojects.model.UntagResourceResponse;
import software.amazon.awssdk.services.iot1clickprojects.model.UpdatePlacementRequest;
import software.amazon.awssdk.services.iot1clickprojects.model.UpdatePlacementResponse;
import software.amazon.awssdk.services.iot1clickprojects.model.UpdateProjectRequest;
import software.amazon.awssdk.services.iot1clickprojects.model.UpdateProjectResponse;
import software.amazon.awssdk.services.iot1clickprojects.paginators.ListPlacementsIterable;
import software.amazon.awssdk.services.iot1clickprojects.paginators.ListProjectsIterable;

/**
 * Service client for accessing AWS IoT 1-Click Projects. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * The AWS IoT 1-Click Projects API Reference
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface Iot1ClickProjectsClient extends AwsClient {
    String SERVICE_NAME = "iot1click";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "projects.iot1click";

    /**
     * <p>
     * Associates a physical device with a placement.
     * </p>
     *
     * @param associateDeviceWithPlacementRequest
     * @return Result of the AssociateDeviceWithPlacement operation returned by the service.
     * @throws InternalFailureException
     * @throws InvalidRequestException
     * @throws ResourceConflictException
     * @throws ResourceNotFoundException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Iot1ClickProjectsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Iot1ClickProjectsClient.AssociateDeviceWithPlacement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/AssociateDeviceWithPlacement"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateDeviceWithPlacementResponse associateDeviceWithPlacement(
            AssociateDeviceWithPlacementRequest associateDeviceWithPlacementRequest) throws InternalFailureException,
            InvalidRequestException, ResourceConflictException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, Iot1ClickProjectsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a physical device with a placement.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateDeviceWithPlacementRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateDeviceWithPlacementRequest#builder()}
     * </p>
     *
     * @param associateDeviceWithPlacementRequest
     *        A {@link Consumer} that will call methods on {@link AssociateDeviceWithPlacementRequest.Builder} to create
     *        a request.
     * @return Result of the AssociateDeviceWithPlacement operation returned by the service.
     * @throws InternalFailureException
     * @throws InvalidRequestException
     * @throws ResourceConflictException
     * @throws ResourceNotFoundException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Iot1ClickProjectsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Iot1ClickProjectsClient.AssociateDeviceWithPlacement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/AssociateDeviceWithPlacement"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateDeviceWithPlacementResponse associateDeviceWithPlacement(
            Consumer<AssociateDeviceWithPlacementRequest.Builder> associateDeviceWithPlacementRequest)
            throws InternalFailureException, InvalidRequestException, ResourceConflictException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, Iot1ClickProjectsException {
        return associateDeviceWithPlacement(AssociateDeviceWithPlacementRequest.builder()
                .applyMutation(associateDeviceWithPlacementRequest).build());
    }

    /**
     * <p>
     * Creates an empty placement.
     * </p>
     *
     * @param createPlacementRequest
     * @return Result of the CreatePlacement operation returned by the service.
     * @throws InternalFailureException
     * @throws InvalidRequestException
     * @throws ResourceConflictException
     * @throws ResourceNotFoundException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Iot1ClickProjectsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Iot1ClickProjectsClient.CreatePlacement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/CreatePlacement"
     *      target="_top">AWS API Documentation</a>
     */
    default CreatePlacementResponse createPlacement(CreatePlacementRequest createPlacementRequest)
            throws InternalFailureException, InvalidRequestException, ResourceConflictException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, Iot1ClickProjectsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an empty placement.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePlacementRequest.Builder} avoiding the need
     * to create one manually via {@link CreatePlacementRequest#builder()}
     * </p>
     *
     * @param createPlacementRequest
     *        A {@link Consumer} that will call methods on {@link CreatePlacementRequest.Builder} to create a request.
     * @return Result of the CreatePlacement operation returned by the service.
     * @throws InternalFailureException
     * @throws InvalidRequestException
     * @throws ResourceConflictException
     * @throws ResourceNotFoundException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Iot1ClickProjectsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Iot1ClickProjectsClient.CreatePlacement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/CreatePlacement"
     *      target="_top">AWS API Documentation</a>
     */
    default CreatePlacementResponse createPlacement(Consumer<CreatePlacementRequest.Builder> createPlacementRequest)
            throws InternalFailureException, InvalidRequestException, ResourceConflictException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, Iot1ClickProjectsException {
        return createPlacement(CreatePlacementRequest.builder().applyMutation(createPlacementRequest).build());
    }

    /**
     * <p>
     * Creates an empty project with a placement template. A project contains zero or more placements that adhere to the
     * placement template defined in the project.
     * </p>
     *
     * @param createProjectRequest
     * @return Result of the CreateProject operation returned by the service.
     * @throws InternalFailureException
     * @throws InvalidRequestException
     * @throws ResourceConflictException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Iot1ClickProjectsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Iot1ClickProjectsClient.CreateProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/CreateProject"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateProjectResponse createProject(CreateProjectRequest createProjectRequest) throws InternalFailureException,
            InvalidRequestException, ResourceConflictException, AwsServiceException, SdkClientException,
            Iot1ClickProjectsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an empty project with a placement template. A project contains zero or more placements that adhere to the
     * placement template defined in the project.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateProjectRequest.Builder} avoiding the need to
     * create one manually via {@link CreateProjectRequest#builder()}
     * </p>
     *
     * @param createProjectRequest
     *        A {@link Consumer} that will call methods on {@link CreateProjectRequest.Builder} to create a request.
     * @return Result of the CreateProject operation returned by the service.
     * @throws InternalFailureException
     * @throws InvalidRequestException
     * @throws ResourceConflictException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Iot1ClickProjectsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Iot1ClickProjectsClient.CreateProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/CreateProject"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateProjectResponse createProject(Consumer<CreateProjectRequest.Builder> createProjectRequest)
            throws InternalFailureException, InvalidRequestException, ResourceConflictException, AwsServiceException,
            SdkClientException, Iot1ClickProjectsException {
        return createProject(CreateProjectRequest.builder().applyMutation(createProjectRequest).build());
    }

    /**
     * <p>
     * Deletes a placement. To delete a placement, it must not have any devices associated with it.
     * </p>
     * <note>
     * <p>
     * When you delete a placement, all associated data becomes irretrievable.
     * </p>
     * </note>
     *
     * @param deletePlacementRequest
     * @return Result of the DeletePlacement operation returned by the service.
     * @throws InternalFailureException
     * @throws InvalidRequestException
     * @throws ResourceNotFoundException
     * @throws TooManyRequestsException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Iot1ClickProjectsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Iot1ClickProjectsClient.DeletePlacement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/DeletePlacement"
     *      target="_top">AWS API Documentation</a>
     */
    default DeletePlacementResponse deletePlacement(DeletePlacementRequest deletePlacementRequest)
            throws InternalFailureException, InvalidRequestException, ResourceNotFoundException, TooManyRequestsException,
            AwsServiceException, SdkClientException, Iot1ClickProjectsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a placement. To delete a placement, it must not have any devices associated with it.
     * </p>
     * <note>
     * <p>
     * When you delete a placement, all associated data becomes irretrievable.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePlacementRequest.Builder} avoiding the need
     * to create one manually via {@link DeletePlacementRequest#builder()}
     * </p>
     *
     * @param deletePlacementRequest
     *        A {@link Consumer} that will call methods on {@link DeletePlacementRequest.Builder} to create a request.
     * @return Result of the DeletePlacement operation returned by the service.
     * @throws InternalFailureException
     * @throws InvalidRequestException
     * @throws ResourceNotFoundException
     * @throws TooManyRequestsException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Iot1ClickProjectsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Iot1ClickProjectsClient.DeletePlacement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/DeletePlacement"
     *      target="_top">AWS API Documentation</a>
     */
    default DeletePlacementResponse deletePlacement(Consumer<DeletePlacementRequest.Builder> deletePlacementRequest)
            throws InternalFailureException, InvalidRequestException, ResourceNotFoundException, TooManyRequestsException,
            AwsServiceException, SdkClientException, Iot1ClickProjectsException {
        return deletePlacement(DeletePlacementRequest.builder().applyMutation(deletePlacementRequest).build());
    }

    /**
     * <p>
     * Deletes a project. To delete a project, it must not have any placements associated with it.
     * </p>
     * <note>
     * <p>
     * When you delete a project, all associated data becomes irretrievable.
     * </p>
     * </note>
     *
     * @param deleteProjectRequest
     * @return Result of the DeleteProject operation returned by the service.
     * @throws InternalFailureException
     * @throws InvalidRequestException
     * @throws ResourceNotFoundException
     * @throws TooManyRequestsException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Iot1ClickProjectsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Iot1ClickProjectsClient.DeleteProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/DeleteProject"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteProjectResponse deleteProject(DeleteProjectRequest deleteProjectRequest) throws InternalFailureException,
            InvalidRequestException, ResourceNotFoundException, TooManyRequestsException, AwsServiceException,
            SdkClientException, Iot1ClickProjectsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a project. To delete a project, it must not have any placements associated with it.
     * </p>
     * <note>
     * <p>
     * When you delete a project, all associated data becomes irretrievable.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteProjectRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteProjectRequest#builder()}
     * </p>
     *
     * @param deleteProjectRequest
     *        A {@link Consumer} that will call methods on {@link DeleteProjectRequest.Builder} to create a request.
     * @return Result of the DeleteProject operation returned by the service.
     * @throws InternalFailureException
     * @throws InvalidRequestException
     * @throws ResourceNotFoundException
     * @throws TooManyRequestsException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Iot1ClickProjectsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Iot1ClickProjectsClient.DeleteProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/DeleteProject"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteProjectResponse deleteProject(Consumer<DeleteProjectRequest.Builder> deleteProjectRequest)
            throws InternalFailureException, InvalidRequestException, ResourceNotFoundException, TooManyRequestsException,
            AwsServiceException, SdkClientException, Iot1ClickProjectsException {
        return deleteProject(DeleteProjectRequest.builder().applyMutation(deleteProjectRequest).build());
    }

    /**
     * <p>
     * Describes a placement in a project.
     * </p>
     *
     * @param describePlacementRequest
     * @return Result of the DescribePlacement operation returned by the service.
     * @throws InternalFailureException
     * @throws InvalidRequestException
     * @throws ResourceNotFoundException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Iot1ClickProjectsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Iot1ClickProjectsClient.DescribePlacement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/DescribePlacement"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePlacementResponse describePlacement(DescribePlacementRequest describePlacementRequest)
            throws InternalFailureException, InvalidRequestException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, Iot1ClickProjectsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a placement in a project.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePlacementRequest.Builder} avoiding the need
     * to create one manually via {@link DescribePlacementRequest#builder()}
     * </p>
     *
     * @param describePlacementRequest
     *        A {@link Consumer} that will call methods on {@link DescribePlacementRequest.Builder} to create a request.
     * @return Result of the DescribePlacement operation returned by the service.
     * @throws InternalFailureException
     * @throws InvalidRequestException
     * @throws ResourceNotFoundException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Iot1ClickProjectsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Iot1ClickProjectsClient.DescribePlacement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/DescribePlacement"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribePlacementResponse describePlacement(Consumer<DescribePlacementRequest.Builder> describePlacementRequest)
            throws InternalFailureException, InvalidRequestException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, Iot1ClickProjectsException {
        return describePlacement(DescribePlacementRequest.builder().applyMutation(describePlacementRequest).build());
    }

    /**
     * <p>
     * Returns an object describing a project.
     * </p>
     *
     * @param describeProjectRequest
     * @return Result of the DescribeProject operation returned by the service.
     * @throws InternalFailureException
     * @throws InvalidRequestException
     * @throws ResourceNotFoundException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Iot1ClickProjectsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Iot1ClickProjectsClient.DescribeProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/DescribeProject"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeProjectResponse describeProject(DescribeProjectRequest describeProjectRequest)
            throws InternalFailureException, InvalidRequestException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, Iot1ClickProjectsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an object describing a project.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeProjectRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeProjectRequest#builder()}
     * </p>
     *
     * @param describeProjectRequest
     *        A {@link Consumer} that will call methods on {@link DescribeProjectRequest.Builder} to create a request.
     * @return Result of the DescribeProject operation returned by the service.
     * @throws InternalFailureException
     * @throws InvalidRequestException
     * @throws ResourceNotFoundException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Iot1ClickProjectsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Iot1ClickProjectsClient.DescribeProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/DescribeProject"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeProjectResponse describeProject(Consumer<DescribeProjectRequest.Builder> describeProjectRequest)
            throws InternalFailureException, InvalidRequestException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, Iot1ClickProjectsException {
        return describeProject(DescribeProjectRequest.builder().applyMutation(describeProjectRequest).build());
    }

    /**
     * <p>
     * Removes a physical device from a placement.
     * </p>
     *
     * @param disassociateDeviceFromPlacementRequest
     * @return Result of the DisassociateDeviceFromPlacement operation returned by the service.
     * @throws InternalFailureException
     * @throws InvalidRequestException
     * @throws ResourceNotFoundException
     * @throws TooManyRequestsException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Iot1ClickProjectsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Iot1ClickProjectsClient.DisassociateDeviceFromPlacement
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/DisassociateDeviceFromPlacement"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateDeviceFromPlacementResponse disassociateDeviceFromPlacement(
            DisassociateDeviceFromPlacementRequest disassociateDeviceFromPlacementRequest) throws InternalFailureException,
            InvalidRequestException, ResourceNotFoundException, TooManyRequestsException, AwsServiceException,
            SdkClientException, Iot1ClickProjectsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a physical device from a placement.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateDeviceFromPlacementRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateDeviceFromPlacementRequest#builder()}
     * </p>
     *
     * @param disassociateDeviceFromPlacementRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateDeviceFromPlacementRequest.Builder} to
     *        create a request.
     * @return Result of the DisassociateDeviceFromPlacement operation returned by the service.
     * @throws InternalFailureException
     * @throws InvalidRequestException
     * @throws ResourceNotFoundException
     * @throws TooManyRequestsException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Iot1ClickProjectsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Iot1ClickProjectsClient.DisassociateDeviceFromPlacement
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/DisassociateDeviceFromPlacement"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateDeviceFromPlacementResponse disassociateDeviceFromPlacement(
            Consumer<DisassociateDeviceFromPlacementRequest.Builder> disassociateDeviceFromPlacementRequest)
            throws InternalFailureException, InvalidRequestException, ResourceNotFoundException, TooManyRequestsException,
            AwsServiceException, SdkClientException, Iot1ClickProjectsException {
        return disassociateDeviceFromPlacement(DisassociateDeviceFromPlacementRequest.builder()
                .applyMutation(disassociateDeviceFromPlacementRequest).build());
    }

    /**
     * <p>
     * Returns an object enumerating the devices in a placement.
     * </p>
     *
     * @param getDevicesInPlacementRequest
     * @return Result of the GetDevicesInPlacement operation returned by the service.
     * @throws InternalFailureException
     * @throws InvalidRequestException
     * @throws ResourceNotFoundException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Iot1ClickProjectsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Iot1ClickProjectsClient.GetDevicesInPlacement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/GetDevicesInPlacement"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDevicesInPlacementResponse getDevicesInPlacement(GetDevicesInPlacementRequest getDevicesInPlacementRequest)
            throws InternalFailureException, InvalidRequestException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, Iot1ClickProjectsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an object enumerating the devices in a placement.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDevicesInPlacementRequest.Builder} avoiding the
     * need to create one manually via {@link GetDevicesInPlacementRequest#builder()}
     * </p>
     *
     * @param getDevicesInPlacementRequest
     *        A {@link Consumer} that will call methods on {@link GetDevicesInPlacementRequest.Builder} to create a
     *        request.
     * @return Result of the GetDevicesInPlacement operation returned by the service.
     * @throws InternalFailureException
     * @throws InvalidRequestException
     * @throws ResourceNotFoundException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Iot1ClickProjectsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Iot1ClickProjectsClient.GetDevicesInPlacement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/GetDevicesInPlacement"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDevicesInPlacementResponse getDevicesInPlacement(
            Consumer<GetDevicesInPlacementRequest.Builder> getDevicesInPlacementRequest) throws InternalFailureException,
            InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            Iot1ClickProjectsException {
        return getDevicesInPlacement(GetDevicesInPlacementRequest.builder().applyMutation(getDevicesInPlacementRequest).build());
    }

    /**
     * <p>
     * Lists the placement(s) of a project.
     * </p>
     *
     * @param listPlacementsRequest
     * @return Result of the ListPlacements operation returned by the service.
     * @throws InternalFailureException
     * @throws InvalidRequestException
     * @throws ResourceNotFoundException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Iot1ClickProjectsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Iot1ClickProjectsClient.ListPlacements
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/ListPlacements"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPlacementsResponse listPlacements(ListPlacementsRequest listPlacementsRequest) throws InternalFailureException,
            InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            Iot1ClickProjectsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the placement(s) of a project.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPlacementsRequest.Builder} avoiding the need to
     * create one manually via {@link ListPlacementsRequest#builder()}
     * </p>
     *
     * @param listPlacementsRequest
     *        A {@link Consumer} that will call methods on {@link ListPlacementsRequest.Builder} to create a request.
     * @return Result of the ListPlacements operation returned by the service.
     * @throws InternalFailureException
     * @throws InvalidRequestException
     * @throws ResourceNotFoundException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Iot1ClickProjectsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Iot1ClickProjectsClient.ListPlacements
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/ListPlacements"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPlacementsResponse listPlacements(Consumer<ListPlacementsRequest.Builder> listPlacementsRequest)
            throws InternalFailureException, InvalidRequestException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, Iot1ClickProjectsException {
        return listPlacements(ListPlacementsRequest.builder().applyMutation(listPlacementsRequest).build());
    }

    /**
     * <p>
     * Lists the placement(s) of a project.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPlacements(software.amazon.awssdk.services.iot1clickprojects.model.ListPlacementsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot1clickprojects.paginators.ListPlacementsIterable responses = client.listPlacementsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iot1clickprojects.paginators.ListPlacementsIterable responses = client
     *             .listPlacementsPaginator(request);
     *     for (software.amazon.awssdk.services.iot1clickprojects.model.ListPlacementsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot1clickprojects.paginators.ListPlacementsIterable responses = client.listPlacementsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPlacements(software.amazon.awssdk.services.iot1clickprojects.model.ListPlacementsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPlacementsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalFailureException
     * @throws InvalidRequestException
     * @throws ResourceNotFoundException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Iot1ClickProjectsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Iot1ClickProjectsClient.ListPlacements
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/ListPlacements"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPlacementsIterable listPlacementsPaginator(ListPlacementsRequest listPlacementsRequest)
            throws InternalFailureException, InvalidRequestException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, Iot1ClickProjectsException {
        return new ListPlacementsIterable(this, listPlacementsRequest);
    }

    /**
     * <p>
     * Lists the placement(s) of a project.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPlacements(software.amazon.awssdk.services.iot1clickprojects.model.ListPlacementsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot1clickprojects.paginators.ListPlacementsIterable responses = client.listPlacementsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iot1clickprojects.paginators.ListPlacementsIterable responses = client
     *             .listPlacementsPaginator(request);
     *     for (software.amazon.awssdk.services.iot1clickprojects.model.ListPlacementsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot1clickprojects.paginators.ListPlacementsIterable responses = client.listPlacementsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPlacements(software.amazon.awssdk.services.iot1clickprojects.model.ListPlacementsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPlacementsRequest.Builder} avoiding the need to
     * create one manually via {@link ListPlacementsRequest#builder()}
     * </p>
     *
     * @param listPlacementsRequest
     *        A {@link Consumer} that will call methods on {@link ListPlacementsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalFailureException
     * @throws InvalidRequestException
     * @throws ResourceNotFoundException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Iot1ClickProjectsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Iot1ClickProjectsClient.ListPlacements
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/ListPlacements"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPlacementsIterable listPlacementsPaginator(Consumer<ListPlacementsRequest.Builder> listPlacementsRequest)
            throws InternalFailureException, InvalidRequestException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, Iot1ClickProjectsException {
        return listPlacementsPaginator(ListPlacementsRequest.builder().applyMutation(listPlacementsRequest).build());
    }

    /**
     * <p>
     * Lists the AWS IoT 1-Click project(s) associated with your AWS account and region.
     * </p>
     *
     * @param listProjectsRequest
     * @return Result of the ListProjects operation returned by the service.
     * @throws InternalFailureException
     * @throws InvalidRequestException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Iot1ClickProjectsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Iot1ClickProjectsClient.ListProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/ListProjects"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProjectsResponse listProjects(ListProjectsRequest listProjectsRequest) throws InternalFailureException,
            InvalidRequestException, AwsServiceException, SdkClientException, Iot1ClickProjectsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the AWS IoT 1-Click project(s) associated with your AWS account and region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProjectsRequest.Builder} avoiding the need to
     * create one manually via {@link ListProjectsRequest#builder()}
     * </p>
     *
     * @param listProjectsRequest
     *        A {@link Consumer} that will call methods on {@link ListProjectsRequest.Builder} to create a request.
     * @return Result of the ListProjects operation returned by the service.
     * @throws InternalFailureException
     * @throws InvalidRequestException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Iot1ClickProjectsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Iot1ClickProjectsClient.ListProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/ListProjects"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProjectsResponse listProjects(Consumer<ListProjectsRequest.Builder> listProjectsRequest)
            throws InternalFailureException, InvalidRequestException, AwsServiceException, SdkClientException,
            Iot1ClickProjectsException {
        return listProjects(ListProjectsRequest.builder().applyMutation(listProjectsRequest).build());
    }

    /**
     * <p>
     * Lists the AWS IoT 1-Click project(s) associated with your AWS account and region.
     * </p>
     *
     * @return Result of the ListProjects operation returned by the service.
     * @throws InternalFailureException
     * @throws InvalidRequestException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Iot1ClickProjectsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Iot1ClickProjectsClient.ListProjects
     * @see #listProjects(ListProjectsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/ListProjects"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProjectsResponse listProjects() throws InternalFailureException, InvalidRequestException, AwsServiceException,
            SdkClientException, Iot1ClickProjectsException {
        return listProjects(ListProjectsRequest.builder().build());
    }

    /**
     * <p>
     * Lists the AWS IoT 1-Click project(s) associated with your AWS account and region.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listProjects(software.amazon.awssdk.services.iot1clickprojects.model.ListProjectsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot1clickprojects.paginators.ListProjectsIterable responses = client.listProjectsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iot1clickprojects.paginators.ListProjectsIterable responses = client
     *             .listProjectsPaginator(request);
     *     for (software.amazon.awssdk.services.iot1clickprojects.model.ListProjectsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot1clickprojects.paginators.ListProjectsIterable responses = client.listProjectsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProjects(software.amazon.awssdk.services.iot1clickprojects.model.ListProjectsRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalFailureException
     * @throws InvalidRequestException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Iot1ClickProjectsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Iot1ClickProjectsClient.ListProjects
     * @see #listProjectsPaginator(ListProjectsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/ListProjects"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProjectsIterable listProjectsPaginator() throws InternalFailureException, InvalidRequestException,
            AwsServiceException, SdkClientException, Iot1ClickProjectsException {
        return listProjectsPaginator(ListProjectsRequest.builder().build());
    }

    /**
     * <p>
     * Lists the AWS IoT 1-Click project(s) associated with your AWS account and region.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listProjects(software.amazon.awssdk.services.iot1clickprojects.model.ListProjectsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot1clickprojects.paginators.ListProjectsIterable responses = client.listProjectsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iot1clickprojects.paginators.ListProjectsIterable responses = client
     *             .listProjectsPaginator(request);
     *     for (software.amazon.awssdk.services.iot1clickprojects.model.ListProjectsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot1clickprojects.paginators.ListProjectsIterable responses = client.listProjectsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProjects(software.amazon.awssdk.services.iot1clickprojects.model.ListProjectsRequest)} operation.</b>
     * </p>
     *
     * @param listProjectsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalFailureException
     * @throws InvalidRequestException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Iot1ClickProjectsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Iot1ClickProjectsClient.ListProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/ListProjects"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProjectsIterable listProjectsPaginator(ListProjectsRequest listProjectsRequest) throws InternalFailureException,
            InvalidRequestException, AwsServiceException, SdkClientException, Iot1ClickProjectsException {
        return new ListProjectsIterable(this, listProjectsRequest);
    }

    /**
     * <p>
     * Lists the AWS IoT 1-Click project(s) associated with your AWS account and region.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listProjects(software.amazon.awssdk.services.iot1clickprojects.model.ListProjectsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot1clickprojects.paginators.ListProjectsIterable responses = client.listProjectsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iot1clickprojects.paginators.ListProjectsIterable responses = client
     *             .listProjectsPaginator(request);
     *     for (software.amazon.awssdk.services.iot1clickprojects.model.ListProjectsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot1clickprojects.paginators.ListProjectsIterable responses = client.listProjectsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProjects(software.amazon.awssdk.services.iot1clickprojects.model.ListProjectsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProjectsRequest.Builder} avoiding the need to
     * create one manually via {@link ListProjectsRequest#builder()}
     * </p>
     *
     * @param listProjectsRequest
     *        A {@link Consumer} that will call methods on {@link ListProjectsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalFailureException
     * @throws InvalidRequestException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Iot1ClickProjectsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Iot1ClickProjectsClient.ListProjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/ListProjects"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProjectsIterable listProjectsPaginator(Consumer<ListProjectsRequest.Builder> listProjectsRequest)
            throws InternalFailureException, InvalidRequestException, AwsServiceException, SdkClientException,
            Iot1ClickProjectsException {
        return listProjectsPaginator(ListProjectsRequest.builder().applyMutation(listProjectsRequest).build());
    }

    /**
     * <p>
     * Lists the tags (metadata key/value pairs) which you have assigned to the resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalFailureException
     * @throws InvalidRequestException
     * @throws ResourceNotFoundException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Iot1ClickProjectsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Iot1ClickProjectsClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws InternalFailureException, InvalidRequestException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, Iot1ClickProjectsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags (metadata key/value pairs) which you have assigned to the resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalFailureException
     * @throws InvalidRequestException
     * @throws ResourceNotFoundException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Iot1ClickProjectsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Iot1ClickProjectsClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws InternalFailureException,
            InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            Iot1ClickProjectsException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Creates or modifies tags for a resource. Tags are key/value pairs (metadata) that can be used to manage a
     * resource. For more information, see <a
     * href="https://aws.amazon.com/answers/account-management/aws-tagging-strategies/">AWS Tagging Strategies</a>.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalFailureException
     * @throws InvalidRequestException
     * @throws ResourceNotFoundException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Iot1ClickProjectsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Iot1ClickProjectsClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InternalFailureException,
            InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            Iot1ClickProjectsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates or modifies tags for a resource. Tags are key/value pairs (metadata) that can be used to manage a
     * resource. For more information, see <a
     * href="https://aws.amazon.com/answers/account-management/aws-tagging-strategies/">AWS Tagging Strategies</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalFailureException
     * @throws InvalidRequestException
     * @throws ResourceNotFoundException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Iot1ClickProjectsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Iot1ClickProjectsClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws InternalFailureException, InvalidRequestException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, Iot1ClickProjectsException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes one or more tags (metadata key/value pairs) from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalFailureException
     * @throws InvalidRequestException
     * @throws ResourceNotFoundException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Iot1ClickProjectsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Iot1ClickProjectsClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InternalFailureException,
            InvalidRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            Iot1ClickProjectsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes one or more tags (metadata key/value pairs) from a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalFailureException
     * @throws InvalidRequestException
     * @throws ResourceNotFoundException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Iot1ClickProjectsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Iot1ClickProjectsClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws InternalFailureException, InvalidRequestException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, Iot1ClickProjectsException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates a placement with the given attributes. To clear an attribute, pass an empty value (i.e., "").
     * </p>
     *
     * @param updatePlacementRequest
     * @return Result of the UpdatePlacement operation returned by the service.
     * @throws InternalFailureException
     * @throws InvalidRequestException
     * @throws ResourceNotFoundException
     * @throws TooManyRequestsException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Iot1ClickProjectsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Iot1ClickProjectsClient.UpdatePlacement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/UpdatePlacement"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdatePlacementResponse updatePlacement(UpdatePlacementRequest updatePlacementRequest)
            throws InternalFailureException, InvalidRequestException, ResourceNotFoundException, TooManyRequestsException,
            AwsServiceException, SdkClientException, Iot1ClickProjectsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a placement with the given attributes. To clear an attribute, pass an empty value (i.e., "").
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdatePlacementRequest.Builder} avoiding the need
     * to create one manually via {@link UpdatePlacementRequest#builder()}
     * </p>
     *
     * @param updatePlacementRequest
     *        A {@link Consumer} that will call methods on {@link UpdatePlacementRequest.Builder} to create a request.
     * @return Result of the UpdatePlacement operation returned by the service.
     * @throws InternalFailureException
     * @throws InvalidRequestException
     * @throws ResourceNotFoundException
     * @throws TooManyRequestsException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Iot1ClickProjectsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Iot1ClickProjectsClient.UpdatePlacement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/UpdatePlacement"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdatePlacementResponse updatePlacement(Consumer<UpdatePlacementRequest.Builder> updatePlacementRequest)
            throws InternalFailureException, InvalidRequestException, ResourceNotFoundException, TooManyRequestsException,
            AwsServiceException, SdkClientException, Iot1ClickProjectsException {
        return updatePlacement(UpdatePlacementRequest.builder().applyMutation(updatePlacementRequest).build());
    }

    /**
     * <p>
     * Updates a project associated with your AWS account and region. With the exception of device template names, you
     * can pass just the values that need to be updated because the update request will change only the values that are
     * provided. To clear a value, pass the empty string (i.e., <code>""</code>).
     * </p>
     *
     * @param updateProjectRequest
     * @return Result of the UpdateProject operation returned by the service.
     * @throws InternalFailureException
     * @throws InvalidRequestException
     * @throws ResourceNotFoundException
     * @throws TooManyRequestsException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Iot1ClickProjectsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Iot1ClickProjectsClient.UpdateProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/UpdateProject"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateProjectResponse updateProject(UpdateProjectRequest updateProjectRequest) throws InternalFailureException,
            InvalidRequestException, ResourceNotFoundException, TooManyRequestsException, AwsServiceException,
            SdkClientException, Iot1ClickProjectsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a project associated with your AWS account and region. With the exception of device template names, you
     * can pass just the values that need to be updated because the update request will change only the values that are
     * provided. To clear a value, pass the empty string (i.e., <code>""</code>).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateProjectRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateProjectRequest#builder()}
     * </p>
     *
     * @param updateProjectRequest
     *        A {@link Consumer} that will call methods on {@link UpdateProjectRequest.Builder} to create a request.
     * @return Result of the UpdateProject operation returned by the service.
     * @throws InternalFailureException
     * @throws InvalidRequestException
     * @throws ResourceNotFoundException
     * @throws TooManyRequestsException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Iot1ClickProjectsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Iot1ClickProjectsClient.UpdateProject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iot1click-projects-2018-05-14/UpdateProject"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateProjectResponse updateProject(Consumer<UpdateProjectRequest.Builder> updateProjectRequest)
            throws InternalFailureException, InvalidRequestException, ResourceNotFoundException, TooManyRequestsException,
            AwsServiceException, SdkClientException, Iot1ClickProjectsException {
        return updateProject(UpdateProjectRequest.builder().applyMutation(updateProjectRequest).build());
    }

    /**
     * Create a {@link Iot1ClickProjectsClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static Iot1ClickProjectsClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link Iot1ClickProjectsClient}.
     */
    static Iot1ClickProjectsClientBuilder builder() {
        return new DefaultIot1ClickProjectsClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default Iot1ClickProjectsServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
