/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartThingRegistrationTaskRequest
extends IotRequest
implements ToCopyableBuilder<Builder, StartThingRegistrationTaskRequest> {
    private static final SdkField<String> TEMPLATE_BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StartThingRegistrationTaskRequest.getter(StartThingRegistrationTaskRequest::templateBody)).setter(StartThingRegistrationTaskRequest.setter(Builder::templateBody)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateBody").build()}).build();
    private static final SdkField<String> INPUT_FILE_BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StartThingRegistrationTaskRequest.getter(StartThingRegistrationTaskRequest::inputFileBucket)).setter(StartThingRegistrationTaskRequest.setter(Builder::inputFileBucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputFileBucket").build()}).build();
    private static final SdkField<String> INPUT_FILE_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StartThingRegistrationTaskRequest.getter(StartThingRegistrationTaskRequest::inputFileKey)).setter(StartThingRegistrationTaskRequest.setter(Builder::inputFileKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputFileKey").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(StartThingRegistrationTaskRequest.getter(StartThingRegistrationTaskRequest::roleArn)).setter(StartThingRegistrationTaskRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_BODY_FIELD, INPUT_FILE_BUCKET_FIELD, INPUT_FILE_KEY_FIELD, ROLE_ARN_FIELD));
    private final String templateBody;
    private final String inputFileBucket;
    private final String inputFileKey;
    private final String roleArn;

    private StartThingRegistrationTaskRequest(BuilderImpl builder) {
        super(builder);
        this.templateBody = builder.templateBody;
        this.inputFileBucket = builder.inputFileBucket;
        this.inputFileKey = builder.inputFileKey;
        this.roleArn = builder.roleArn;
    }

    public String templateBody() {
        return this.templateBody;
    }

    public String inputFileBucket() {
        return this.inputFileBucket;
    }

    public String inputFileKey() {
        return this.inputFileKey;
    }

    public String roleArn() {
        return this.roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.templateBody());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputFileBucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputFileKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartThingRegistrationTaskRequest)) {
            return false;
        }
        StartThingRegistrationTaskRequest other = (StartThingRegistrationTaskRequest)((Object)obj);
        return Objects.equals(this.templateBody(), other.templateBody()) && Objects.equals(this.inputFileBucket(), other.inputFileBucket()) && Objects.equals(this.inputFileKey(), other.inputFileKey()) && Objects.equals(this.roleArn(), other.roleArn());
    }

    public String toString() {
        return ToString.builder((String)"StartThingRegistrationTaskRequest").add("TemplateBody", (Object)this.templateBody()).add("InputFileBucket", (Object)this.inputFileBucket()).add("InputFileKey", (Object)this.inputFileKey()).add("RoleArn", (Object)this.roleArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "templateBody": {
                return Optional.ofNullable(clazz.cast(this.templateBody()));
            }
            case "inputFileBucket": {
                return Optional.ofNullable(clazz.cast(this.inputFileBucket()));
            }
            case "inputFileKey": {
                return Optional.ofNullable(clazz.cast(this.inputFileKey()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartThingRegistrationTaskRequest, T> g) {
        return obj -> g.apply((StartThingRegistrationTaskRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private String templateBody;
        private String inputFileBucket;
        private String inputFileKey;
        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(StartThingRegistrationTaskRequest model) {
            super(model);
            this.templateBody(model.templateBody);
            this.inputFileBucket(model.inputFileBucket);
            this.inputFileKey(model.inputFileKey);
            this.roleArn(model.roleArn);
        }

        public final String getTemplateBody() {
            return this.templateBody;
        }

        @Override
        public final Builder templateBody(String templateBody) {
            this.templateBody = templateBody;
            return this;
        }

        public final void setTemplateBody(String templateBody) {
            this.templateBody = templateBody;
        }

        public final String getInputFileBucket() {
            return this.inputFileBucket;
        }

        @Override
        public final Builder inputFileBucket(String inputFileBucket) {
            this.inputFileBucket = inputFileBucket;
            return this;
        }

        public final void setInputFileBucket(String inputFileBucket) {
            this.inputFileBucket = inputFileBucket;
        }

        public final String getInputFileKey() {
            return this.inputFileKey;
        }

        @Override
        public final Builder inputFileKey(String inputFileKey) {
            this.inputFileKey = inputFileKey;
            return this;
        }

        public final void setInputFileKey(String inputFileKey) {
            this.inputFileKey = inputFileKey;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartThingRegistrationTaskRequest build() {
            return new StartThingRegistrationTaskRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartThingRegistrationTaskRequest> {
        public Builder templateBody(String var1);

        public Builder inputFileBucket(String var1);

        public Builder inputFileKey(String var1);

        public Builder roleArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

