/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AddThingToThingGroupRequest
extends IotRequest
implements ToCopyableBuilder<Builder, AddThingToThingGroupRequest> {
    private static final SdkField<String> THING_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AddThingToThingGroupRequest.getter(AddThingToThingGroupRequest::thingGroupName)).setter(AddThingToThingGroupRequest.setter(Builder::thingGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingGroupName").build()}).build();
    private static final SdkField<String> THING_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AddThingToThingGroupRequest.getter(AddThingToThingGroupRequest::thingGroupArn)).setter(AddThingToThingGroupRequest.setter(Builder::thingGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingGroupArn").build()}).build();
    private static final SdkField<String> THING_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AddThingToThingGroupRequest.getter(AddThingToThingGroupRequest::thingName)).setter(AddThingToThingGroupRequest.setter(Builder::thingName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingName").build()}).build();
    private static final SdkField<String> THING_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AddThingToThingGroupRequest.getter(AddThingToThingGroupRequest::thingArn)).setter(AddThingToThingGroupRequest.setter(Builder::thingArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingArn").build()}).build();
    private static final SdkField<Boolean> OVERRIDE_DYNAMIC_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(AddThingToThingGroupRequest.getter(AddThingToThingGroupRequest::overrideDynamicGroups)).setter(AddThingToThingGroupRequest.setter(Builder::overrideDynamicGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overrideDynamicGroups").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THING_GROUP_NAME_FIELD, THING_GROUP_ARN_FIELD, THING_NAME_FIELD, THING_ARN_FIELD, OVERRIDE_DYNAMIC_GROUPS_FIELD));
    private final String thingGroupName;
    private final String thingGroupArn;
    private final String thingName;
    private final String thingArn;
    private final Boolean overrideDynamicGroups;

    private AddThingToThingGroupRequest(BuilderImpl builder) {
        super(builder);
        this.thingGroupName = builder.thingGroupName;
        this.thingGroupArn = builder.thingGroupArn;
        this.thingName = builder.thingName;
        this.thingArn = builder.thingArn;
        this.overrideDynamicGroups = builder.overrideDynamicGroups;
    }

    public String thingGroupName() {
        return this.thingGroupName;
    }

    public String thingGroupArn() {
        return this.thingGroupArn;
    }

    public String thingName() {
        return this.thingName;
    }

    public String thingArn() {
        return this.thingArn;
    }

    public Boolean overrideDynamicGroups() {
        return this.overrideDynamicGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.thingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.thingGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.thingName());
        hashCode = 31 * hashCode + Objects.hashCode(this.thingArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.overrideDynamicGroups());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddThingToThingGroupRequest)) {
            return false;
        }
        AddThingToThingGroupRequest other = (AddThingToThingGroupRequest)((Object)obj);
        return Objects.equals(this.thingGroupName(), other.thingGroupName()) && Objects.equals(this.thingGroupArn(), other.thingGroupArn()) && Objects.equals(this.thingName(), other.thingName()) && Objects.equals(this.thingArn(), other.thingArn()) && Objects.equals(this.overrideDynamicGroups(), other.overrideDynamicGroups());
    }

    public String toString() {
        return ToString.builder((String)"AddThingToThingGroupRequest").add("ThingGroupName", (Object)this.thingGroupName()).add("ThingGroupArn", (Object)this.thingGroupArn()).add("ThingName", (Object)this.thingName()).add("ThingArn", (Object)this.thingArn()).add("OverrideDynamicGroups", (Object)this.overrideDynamicGroups()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "thingGroupName": {
                return Optional.ofNullable(clazz.cast(this.thingGroupName()));
            }
            case "thingGroupArn": {
                return Optional.ofNullable(clazz.cast(this.thingGroupArn()));
            }
            case "thingName": {
                return Optional.ofNullable(clazz.cast(this.thingName()));
            }
            case "thingArn": {
                return Optional.ofNullable(clazz.cast(this.thingArn()));
            }
            case "overrideDynamicGroups": {
                return Optional.ofNullable(clazz.cast(this.overrideDynamicGroups()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AddThingToThingGroupRequest, T> g) {
        return obj -> g.apply((AddThingToThingGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private String thingGroupName;
        private String thingGroupArn;
        private String thingName;
        private String thingArn;
        private Boolean overrideDynamicGroups;

        private BuilderImpl() {
        }

        private BuilderImpl(AddThingToThingGroupRequest model) {
            super(model);
            this.thingGroupName(model.thingGroupName);
            this.thingGroupArn(model.thingGroupArn);
            this.thingName(model.thingName);
            this.thingArn(model.thingArn);
            this.overrideDynamicGroups(model.overrideDynamicGroups);
        }

        public final String getThingGroupName() {
            return this.thingGroupName;
        }

        @Override
        public final Builder thingGroupName(String thingGroupName) {
            this.thingGroupName = thingGroupName;
            return this;
        }

        public final void setThingGroupName(String thingGroupName) {
            this.thingGroupName = thingGroupName;
        }

        public final String getThingGroupArn() {
            return this.thingGroupArn;
        }

        @Override
        public final Builder thingGroupArn(String thingGroupArn) {
            this.thingGroupArn = thingGroupArn;
            return this;
        }

        public final void setThingGroupArn(String thingGroupArn) {
            this.thingGroupArn = thingGroupArn;
        }

        public final String getThingName() {
            return this.thingName;
        }

        @Override
        public final Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        public final void setThingName(String thingName) {
            this.thingName = thingName;
        }

        public final String getThingArn() {
            return this.thingArn;
        }

        @Override
        public final Builder thingArn(String thingArn) {
            this.thingArn = thingArn;
            return this;
        }

        public final void setThingArn(String thingArn) {
            this.thingArn = thingArn;
        }

        public final Boolean getOverrideDynamicGroups() {
            return this.overrideDynamicGroups;
        }

        @Override
        public final Builder overrideDynamicGroups(Boolean overrideDynamicGroups) {
            this.overrideDynamicGroups = overrideDynamicGroups;
            return this;
        }

        public final void setOverrideDynamicGroups(Boolean overrideDynamicGroups) {
            this.overrideDynamicGroups = overrideDynamicGroups;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AddThingToThingGroupRequest build() {
            return new AddThingToThingGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AddThingToThingGroupRequest> {
        public Builder thingGroupName(String var1);

        public Builder thingGroupArn(String var1);

        public Builder thingName(String var1);

        public Builder thingArn(String var1);

        public Builder overrideDynamicGroups(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

