/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.services.iot.model.ReportType;
import software.amazon.awssdk.services.iot.model.S3FileUrlListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListThingRegistrationTaskReportsResponse
extends IotResponse
implements ToCopyableBuilder<Builder, ListThingRegistrationTaskReportsResponse> {
    private static final SdkField<List<String>> RESOURCE_LINKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListThingRegistrationTaskReportsResponse.getter(ListThingRegistrationTaskReportsResponse::resourceLinks)).setter(ListThingRegistrationTaskReportsResponse.setter(Builder::resourceLinks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceLinks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> REPORT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListThingRegistrationTaskReportsResponse.getter(ListThingRegistrationTaskReportsResponse::reportTypeAsString)).setter(ListThingRegistrationTaskReportsResponse.setter(Builder::reportType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reportType").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListThingRegistrationTaskReportsResponse.getter(ListThingRegistrationTaskReportsResponse::nextToken)).setter(ListThingRegistrationTaskReportsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_LINKS_FIELD, REPORT_TYPE_FIELD, NEXT_TOKEN_FIELD));
    private final List<String> resourceLinks;
    private final String reportType;
    private final String nextToken;

    private ListThingRegistrationTaskReportsResponse(BuilderImpl builder) {
        super(builder);
        this.resourceLinks = builder.resourceLinks;
        this.reportType = builder.reportType;
        this.nextToken = builder.nextToken;
    }

    public List<String> resourceLinks() {
        return this.resourceLinks;
    }

    public ReportType reportType() {
        return ReportType.fromValue(this.reportType);
    }

    public String reportTypeAsString() {
        return this.reportType;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceLinks());
        hashCode = 31 * hashCode + Objects.hashCode(this.reportTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListThingRegistrationTaskReportsResponse)) {
            return false;
        }
        ListThingRegistrationTaskReportsResponse other = (ListThingRegistrationTaskReportsResponse)((Object)obj);
        return Objects.equals(this.resourceLinks(), other.resourceLinks()) && Objects.equals(this.reportTypeAsString(), other.reportTypeAsString()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListThingRegistrationTaskReportsResponse").add("ResourceLinks", this.resourceLinks()).add("ReportType", (Object)this.reportTypeAsString()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourceLinks": {
                return Optional.ofNullable(clazz.cast(this.resourceLinks()));
            }
            case "reportType": {
                return Optional.ofNullable(clazz.cast(this.reportTypeAsString()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListThingRegistrationTaskReportsResponse, T> g) {
        return obj -> g.apply((ListThingRegistrationTaskReportsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private List<String> resourceLinks = DefaultSdkAutoConstructList.getInstance();
        private String reportType;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListThingRegistrationTaskReportsResponse model) {
            super(model);
            this.resourceLinks(model.resourceLinks);
            this.reportType(model.reportType);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getResourceLinks() {
            return this.resourceLinks;
        }

        @Override
        public final Builder resourceLinks(Collection<String> resourceLinks) {
            this.resourceLinks = S3FileUrlListCopier.copy(resourceLinks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceLinks(String ... resourceLinks) {
            this.resourceLinks(Arrays.asList(resourceLinks));
            return this;
        }

        public final void setResourceLinks(Collection<String> resourceLinks) {
            this.resourceLinks = S3FileUrlListCopier.copy(resourceLinks);
        }

        public final String getReportTypeAsString() {
            return this.reportType;
        }

        @Override
        public final Builder reportType(String reportType) {
            this.reportType = reportType;
            return this;
        }

        @Override
        public final Builder reportType(ReportType reportType) {
            this.reportType(reportType == null ? null : reportType.toString());
            return this;
        }

        public final void setReportType(String reportType) {
            this.reportType = reportType;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListThingRegistrationTaskReportsResponse build() {
            return new ListThingRegistrationTaskReportsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListThingRegistrationTaskReportsResponse> {
        public Builder resourceLinks(Collection<String> var1);

        public Builder resourceLinks(String ... var1);

        public Builder reportType(String var1);

        public Builder reportType(ReportType var1);

        public Builder nextToken(String var1);
    }
}

