/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.ThingConnectivityIndexingMode;
import software.amazon.awssdk.services.iot.model.ThingIndexingMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ThingIndexingConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ThingIndexingConfiguration> {
    private static final SdkField<String> THING_INDEXING_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ThingIndexingConfiguration.getter(ThingIndexingConfiguration::thingIndexingModeAsString)).setter(ThingIndexingConfiguration.setter(Builder::thingIndexingMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingIndexingMode").build()}).build();
    private static final SdkField<String> THING_CONNECTIVITY_INDEXING_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ThingIndexingConfiguration.getter(ThingIndexingConfiguration::thingConnectivityIndexingModeAsString)).setter(ThingIndexingConfiguration.setter(Builder::thingConnectivityIndexingMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingConnectivityIndexingMode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THING_INDEXING_MODE_FIELD, THING_CONNECTIVITY_INDEXING_MODE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String thingIndexingMode;
    private final String thingConnectivityIndexingMode;

    private ThingIndexingConfiguration(BuilderImpl builder) {
        this.thingIndexingMode = builder.thingIndexingMode;
        this.thingConnectivityIndexingMode = builder.thingConnectivityIndexingMode;
    }

    public ThingIndexingMode thingIndexingMode() {
        return ThingIndexingMode.fromValue(this.thingIndexingMode);
    }

    public String thingIndexingModeAsString() {
        return this.thingIndexingMode;
    }

    public ThingConnectivityIndexingMode thingConnectivityIndexingMode() {
        return ThingConnectivityIndexingMode.fromValue(this.thingConnectivityIndexingMode);
    }

    public String thingConnectivityIndexingModeAsString() {
        return this.thingConnectivityIndexingMode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.thingIndexingModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.thingConnectivityIndexingModeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThingIndexingConfiguration)) {
            return false;
        }
        ThingIndexingConfiguration other = (ThingIndexingConfiguration)obj;
        return Objects.equals(this.thingIndexingModeAsString(), other.thingIndexingModeAsString()) && Objects.equals(this.thingConnectivityIndexingModeAsString(), other.thingConnectivityIndexingModeAsString());
    }

    public String toString() {
        return ToString.builder((String)"ThingIndexingConfiguration").add("ThingIndexingMode", (Object)this.thingIndexingModeAsString()).add("ThingConnectivityIndexingMode", (Object)this.thingConnectivityIndexingModeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "thingIndexingMode": {
                return Optional.ofNullable(clazz.cast(this.thingIndexingModeAsString()));
            }
            case "thingConnectivityIndexingMode": {
                return Optional.ofNullable(clazz.cast(this.thingConnectivityIndexingModeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ThingIndexingConfiguration, T> g) {
        return obj -> g.apply((ThingIndexingConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String thingIndexingMode;
        private String thingConnectivityIndexingMode;

        private BuilderImpl() {
        }

        private BuilderImpl(ThingIndexingConfiguration model) {
            this.thingIndexingMode(model.thingIndexingMode);
            this.thingConnectivityIndexingMode(model.thingConnectivityIndexingMode);
        }

        public final String getThingIndexingModeAsString() {
            return this.thingIndexingMode;
        }

        @Override
        public final Builder thingIndexingMode(String thingIndexingMode) {
            this.thingIndexingMode = thingIndexingMode;
            return this;
        }

        @Override
        public final Builder thingIndexingMode(ThingIndexingMode thingIndexingMode) {
            this.thingIndexingMode(thingIndexingMode == null ? null : thingIndexingMode.toString());
            return this;
        }

        public final void setThingIndexingMode(String thingIndexingMode) {
            this.thingIndexingMode = thingIndexingMode;
        }

        public final String getThingConnectivityIndexingModeAsString() {
            return this.thingConnectivityIndexingMode;
        }

        @Override
        public final Builder thingConnectivityIndexingMode(String thingConnectivityIndexingMode) {
            this.thingConnectivityIndexingMode = thingConnectivityIndexingMode;
            return this;
        }

        @Override
        public final Builder thingConnectivityIndexingMode(ThingConnectivityIndexingMode thingConnectivityIndexingMode) {
            this.thingConnectivityIndexingMode(thingConnectivityIndexingMode == null ? null : thingConnectivityIndexingMode.toString());
            return this;
        }

        public final void setThingConnectivityIndexingMode(String thingConnectivityIndexingMode) {
            this.thingConnectivityIndexingMode = thingConnectivityIndexingMode;
        }

        public ThingIndexingConfiguration build() {
            return new ThingIndexingConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ThingIndexingConfiguration> {
        public Builder thingIndexingMode(String var1);

        public Builder thingIndexingMode(ThingIndexingMode var1);

        public Builder thingConnectivityIndexingMode(String var1);

        public Builder thingConnectivityIndexingMode(ThingConnectivityIndexingMode var1);
    }
}

